/*
 * Decompiled with CFR 0.152.
 */
package org.azd.utils;

import org.azd.accounts.AccountsApi;
import org.azd.build.BuildApi;
import org.azd.connection.Connection;
import org.azd.core.CoreApi;
import org.azd.distributedtask.DistributedTaskApi;
import org.azd.extensionmanagement.ExtensionManagementApi;
import org.azd.feedmanagement.FeedManagementApi;
import org.azd.git.GitApi;
import org.azd.graph.GraphApi;
import org.azd.interfaces.AzDClient;
import org.azd.maven.MavenApi;
import org.azd.memberentitlementmanagement.MemberEntitlementManagementApi;
import org.azd.oauth.OAuthApi;
import org.azd.oauth.types.AuthorizedToken;
import org.azd.pipelines.PipelinesApi;
import org.azd.policy.PolicyApi;
import org.azd.release.ReleaseApi;
import org.azd.security.SecurityApi;
import org.azd.serviceendpoint.ServiceEndpointApi;
import org.azd.servicehooks.ServiceHooksApi;
import org.azd.test.TestApi;
import org.azd.upack.UPackApi;
import org.azd.wiki.WikiApi;
import org.azd.work.WorkApi;
import org.azd.workitemtracking.WorkItemTrackingApi;

public class AzDClientApi
implements AzDClient {
    private final Connection CONNECTION;

    public AzDClientApi(Connection connection) {
        this.CONNECTION = connection;
    }

    public AzDClientApi(String organizationName, String personalAccessToken) {
        this.CONNECTION = new Connection(organizationName, personalAccessToken);
    }

    public AzDClientApi(String organizationName, String projectName, String personalAccessToken) {
        this.CONNECTION = new Connection(organizationName, projectName, personalAccessToken);
    }

    public void setProject(String project) {
        if (this.CONNECTION != null) {
            this.CONNECTION.setProject(project);
        }
    }

    public String getOrganization() {
        if (this.CONNECTION != null) {
            return this.CONNECTION.getOrganization();
        }
        return null;
    }

    public void setOrganization(String org) {
        if (this.CONNECTION != null) {
            this.CONNECTION.setOrganization(org);
        }
    }

    public void setOauthToken(AuthorizedToken token) {
        if (this.CONNECTION != null) {
            this.CONNECTION.setOauthToken(token);
        }
    }

    public Connection getConnection() {
        return this.CONNECTION;
    }

    @Override
    public AccountsApi getAccountsApi() {
        return new AccountsApi(this.CONNECTION);
    }

    @Override
    public BuildApi getBuildApi() {
        return new BuildApi(this.CONNECTION);
    }

    @Override
    public CoreApi getCoreApi() {
        return new CoreApi(this.CONNECTION);
    }

    @Override
    public DistributedTaskApi getDistributedTaskApi() {
        return new DistributedTaskApi(this.CONNECTION);
    }

    @Override
    public FeedManagementApi getFeedManagementApi() {
        return new FeedManagementApi(this.CONNECTION);
    }

    @Override
    public GitApi getGitApi() {
        return new GitApi(this.CONNECTION);
    }

    @Override
    public GraphApi getGraphApi() {
        return new GraphApi(this.CONNECTION);
    }

    @Override
    public MavenApi getMavenApi() {
        return new MavenApi(this.CONNECTION);
    }

    @Override
    public MemberEntitlementManagementApi getMemberEntitlementManagementApi() {
        return new MemberEntitlementManagementApi(this.CONNECTION);
    }

    @Override
    public ReleaseApi getReleaseApi() {
        return new ReleaseApi(this.CONNECTION);
    }

    @Override
    public ServiceHooksApi getServiceHooksApi() {
        return new ServiceHooksApi(this.CONNECTION);
    }

    @Override
    public WikiApi getWikiApi() {
        return new WikiApi(this.CONNECTION);
    }

    @Override
    public WorkApi getWorkApi() {
        return new WorkApi(this.CONNECTION);
    }

    @Override
    public WorkItemTrackingApi getWorkItemTrackingApi() {
        return new WorkItemTrackingApi(this.CONNECTION);
    }

    @Override
    public OAuthApi getOAuth() {
        return new OAuthApi();
    }

    @Override
    public ServiceEndpointApi getServiceEndpointApi() {
        return new ServiceEndpointApi(this.CONNECTION);
    }

    @Override
    public ExtensionManagementApi getExtensionManagementApi() {
        return new ExtensionManagementApi(this.CONNECTION);
    }

    @Override
    public PolicyApi getPolicyApi() {
        return new PolicyApi(this.CONNECTION);
    }

    @Override
    public PipelinesApi getPipelinesApi() {
        return new PipelinesApi(this.CONNECTION);
    }

    @Override
    public UPackApi getUPackApi() {
        return new UPackApi(this.CONNECTION);
    }

    @Override
    public SecurityApi getSecurityApi() {
        return new SecurityApi(this.CONNECTION);
    }

    @Override
    public TestApi getTestApi() {
        return new TestApi(this.CONNECTION);
    }
}

