/*
 * Decompiled with CFR 0.152.
 */
package org.azd.utils;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import org.azd.enums.CustomHeader;
import org.azd.enums.RequestMethod;
import org.azd.exceptions.AzDException;

public abstract class BaseRestClient {
    private static final String AUTHORIZATION = "Authorization";
    private static HttpClient.Redirect REDIRECT_POLICY = HttpClient.Redirect.NORMAL;
    private static final HttpClient CLIENT = HttpClient.newBuilder().followRedirects(REDIRECT_POLICY).build();
    private static final HttpClient HTTP_CLIENT = HttpClient.newHttpClient();

    private static String encodePersonalAccessToken(String token) {
        return "Basic " + Base64.getEncoder().encodeToString((":" + token).getBytes());
    }

    private static HttpRequest.Builder build(String requestUrl, String token) {
        if (token == null) {
            return HttpRequest.newBuilder().uri(URI.create(requestUrl));
        }
        return HttpRequest.newBuilder().uri(URI.create(requestUrl)).setHeader(AUTHORIZATION, BaseRestClient.encodePersonalAccessToken(token));
    }

    private static <T> CompletableFuture<HttpResponse<T>> request(HttpRequest r, HttpResponse.BodyHandler<T> handler, boolean callback) {
        if (callback) {
            return CLIENT.sendAsync(r, handler);
        }
        return HTTP_CLIENT.sendAsync(r, handler);
    }

    public static HttpClient.Redirect getRedirectPolicy() {
        return REDIRECT_POLICY;
    }

    public static void setRedirectPolicy(HttpClient.Redirect redirectPolicy) {
        REDIRECT_POLICY = redirectPolicy;
    }

    public static <T> CompletableFuture<HttpResponse<T>> get(String requestUrl, String token, HttpResponse.BodyHandler<T> handler, CustomHeader contentType, boolean callback) {
        return BaseRestClient.request(BaseRestClient.build(requestUrl, token).GET().header(contentType.getName(), contentType.getValue()).build(), handler, callback);
    }

    public static <T> CompletableFuture<HttpResponse<T>> post(String requestUrl, String token, HttpRequest.BodyPublisher publisher, HttpResponse.BodyHandler<T> handler, CustomHeader contentType, boolean callback) throws AzDException {
        return BaseRestClient.request(BaseRestClient.build(requestUrl, token).POST(publisher).header(contentType.getName(), contentType.getValue()).build(), handler, callback);
    }

    public static <T> CompletableFuture<HttpResponse<T>> patch(String requestUrl, String token, HttpRequest.BodyPublisher publisher, HttpResponse.BodyHandler<T> handler, CustomHeader contentType, boolean callback) throws AzDException {
        return BaseRestClient.request(BaseRestClient.build(requestUrl, token).method(RequestMethod.PATCH.name(), publisher).header(contentType.getName(), contentType.getValue()).build(), handler, callback);
    }

    public static <T> CompletableFuture<HttpResponse<T>> put(String requestUrl, String token, HttpRequest.BodyPublisher publisher, HttpResponse.BodyHandler<T> handler, CustomHeader contentType, boolean callback) throws AzDException {
        return BaseRestClient.request(BaseRestClient.build(requestUrl, token).PUT(publisher).header(contentType.getName(), contentType.getValue()).build(), handler, callback);
    }

    public static <T> CompletableFuture<HttpResponse<T>> delete(String requestUrl, String token, HttpResponse.BodyHandler<T> handler) {
        return BaseRestClient.request(BaseRestClient.build(requestUrl, token).DELETE().build(), handler, false);
    }

    public static <T> CompletableFuture<HttpResponse<T>> response(RequestMethod requestMethod, String requestUrl, String token, HttpRequest.BodyPublisher publisher, HttpResponse.BodyHandler<T> handler, CustomHeader contentType, boolean callback) throws AzDException {
        if (contentType == null) {
            contentType = CustomHeader.JSON;
        }
        if (requestMethod == RequestMethod.GET) {
            return BaseRestClient.get(requestUrl, token, handler, contentType, callback);
        }
        if (requestMethod == RequestMethod.POST) {
            return BaseRestClient.post(requestUrl, token, publisher, handler, contentType, callback);
        }
        if (requestMethod == RequestMethod.PATCH) {
            return BaseRestClient.patch(requestUrl, token, publisher, handler, contentType, callback);
        }
        if (requestMethod == RequestMethod.PUT) {
            return BaseRestClient.put(requestUrl, token, publisher, handler, contentType, callback);
        }
        if (requestMethod == RequestMethod.DELETE) {
            return BaseRestClient.delete(requestUrl, token, handler);
        }
        return null;
    }

    protected static HttpRequest.Builder getBuilder(String requestUrl, String token) {
        return BaseRestClient.build(requestUrl, token);
    }

    protected static <T> CompletableFuture<HttpResponse<T>> getResponse(HttpRequest r, HttpResponse.BodyHandler<T> handler, boolean callback) {
        if (callback) {
            return CLIENT.sendAsync(r, handler);
        }
        return HTTP_CLIENT.sendAsync(r, handler);
    }
}

