/*
 * Decompiled with CFR 0.152.
 */
package org.azd.utils;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.azd.enums.ApiExceptionTypes;
import org.azd.exceptions.AzDException;
import org.azd.helpers.JsonMapper;

public class ModelBuilder {
    private static final JsonMapper MAPPER = new JsonMapper();

    public static Map build(Object model, List<String> valuesToRemove) throws AzDException {
        if (model == null) {
            throw new AzDException(ApiExceptionTypes.InvalidArgumentException.name(), "Request body cannot be null");
        }
        Map definedModel = MAPPER.mapJsonResponse(MAPPER.convertToString(model), Map.class);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (String key : definedModel.keySet()) {
            if (definedModel.get(key) == null) continue;
            result.put(key, definedModel.get(key));
        }
        return ModelBuilder.removeKeys(result, valuesToRemove);
    }

    private static Map removeKeys(Map<String, Object> map, List<String> valuesToRemove) {
        if (valuesToRemove == null) {
            return map;
        }
        valuesToRemove.forEach(key -> map.remove(key, map.get(key)));
        return map;
    }
}

