/*
 * Decompiled with CFR 0.152.
 */
package org.azd.utils;

import java.io.InputStream;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Map;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import org.azd.connection.Connection;
import org.azd.enums.ApiExceptionTypes;
import org.azd.enums.CustomHeader;
import org.azd.enums.RequestMethod;
import org.azd.exceptions.AzDException;
import org.azd.utils.RestClientProvider;

public abstract class RestClient {
    static HttpHeaders headersFromLastRequest = null;

    static OptionalLong retryAfterInterval() {
        if (headersFromLastRequest != null) {
            return headersFromLastRequest.firstValueAsLong("Retry-After");
        }
        return OptionalLong.empty();
    }

    public static String send(RequestMethod requestMethod, Connection connection, String resourceId, String project, String area, String id, String resource, String apiVersion, Map queryString, Object requestBody, CustomHeader contentType) throws AzDException {
        String requestUrl = RestClientProvider.buildRequestUrl(connection.getOrganization(), resourceId, project, area, id, resource, apiVersion, queryString);
        if (contentType == null) {
            contentType = CustomHeader.JSON;
        }
        HttpResponse<String> response = RestClientProvider.response(requestMethod, requestUrl, connection.getPersonalAccessToken(), HttpRequest.BodyPublishers.ofString(RestClientProvider.MAPPER.convertToString(requestBody)), HttpResponse.BodyHandlers.ofString(), contentType, false).join();
        headersFromLastRequest = response.headers();
        return response.body();
    }

    public static InputStream send(RequestMethod requestMethod, Connection connection, String resourceId, String project, String area, String id, String resource, String apiVersion, Map queryString, InputStream contentStream, CustomHeader contentType, boolean callback) throws AzDException {
        String requestUrl = RestClientProvider.buildRequestUrl(connection.getOrganization(), resourceId, project, area, id, resource, apiVersion, queryString);
        if (contentType == null) {
            contentType = CustomHeader.STREAM;
        }
        return (InputStream)((CompletableFuture)RestClientProvider.response(requestMethod, requestUrl, connection.getPersonalAccessToken(), HttpRequest.BodyPublishers.ofInputStream(() -> contentStream), HttpResponse.BodyHandlers.ofInputStream(), contentType, callback).thenApplyAsync(HttpResponse::body)).join();
    }

    public static CompletableFuture<HttpResponse<InputStream>> send(String requestUrl, RequestMethod requestMethod, Connection connection, String resourceId, String project, String area, String id, String resource, String apiVersion, Map queryString, InputStream contentStream, CustomHeader contentType, boolean callback) throws AzDException {
        if (requestUrl == null) {
            requestUrl = RestClientProvider.buildRequestUrl(connection.getOrganization(), resourceId, project, area, id, resource, apiVersion, queryString);
        }
        if (contentType == null) {
            contentType = CustomHeader.STREAM;
        }
        if (connection != null) {
            return RestClientProvider.response(requestMethod, requestUrl, connection.getPersonalAccessToken(), HttpRequest.BodyPublishers.ofInputStream(() -> contentStream), HttpResponse.BodyHandlers.ofInputStream(), contentType, callback);
        }
        return RestClientProvider.response(requestMethod, requestUrl, null, HttpRequest.BodyPublishers.ofInputStream(() -> contentStream), HttpResponse.BodyHandlers.ofInputStream(), contentType, callback);
    }

    public static String send(String requestUrl, RequestMethod requestMethod, Object requestBody, CustomHeader contentType, boolean callback) throws AzDException {
        if (contentType == null) {
            contentType = CustomHeader.JSON;
        }
        HttpResponse<String> response = RestClientProvider.response(requestMethod, requestUrl, null, HttpRequest.BodyPublishers.ofString(RestClientProvider.MAPPER.convertToString(requestBody)), HttpResponse.BodyHandlers.ofString(), contentType, callback).join();
        headersFromLastRequest = response.headers();
        return response.body();
    }

    public static String send(String requestUrl, Connection connection, RequestMethod requestMethod, Object requestBody, CustomHeader contentType, boolean callback) throws AzDException {
        if (contentType == null) {
            contentType = CustomHeader.JSON;
        }
        HttpResponse<String> response = RestClientProvider.response(requestMethod, requestUrl, connection.getPersonalAccessToken(), HttpRequest.BodyPublishers.ofString(RestClientProvider.MAPPER.convertToString(requestBody)), HttpResponse.BodyHandlers.ofString(), contentType, callback).join();
        headersFromLastRequest = response.headers();
        return response.body();
    }

    public static <T> CompletableFuture<HttpResponse<T>> send(String requestUrl, RequestMethod requestMethod, Connection connection, String resourceId, String project, String area, String id, String resource, String apiVersion, Map queryString, HttpRequest.BodyPublisher publisher, HttpResponse.BodyHandler<T> handler, Map<String, CustomHeader> headerMap, boolean callback) throws AzDException {
        if (requestUrl == null) {
            requestUrl = RestClientProvider.buildRequestUrl(connection.getOrganization(), resourceId, project, area, id, resource, apiVersion, queryString);
        }
        if (headerMap == null) {
            headerMap = Map.of("Accept", CustomHeader.JSON);
        }
        if (connection != null) {
            HttpRequest.Builder builder = RestClientProvider.getBuilder(requestUrl, connection.getPersonalAccessToken());
            for (String key : headerMap.keySet()) {
                builder.header(headerMap.get(key).getName(), headerMap.get(key).getValue());
            }
            if (requestMethod == RequestMethod.GET) {
                return RestClientProvider.getResponse(builder.GET().build(), handler, callback);
            }
            if (requestMethod == RequestMethod.POST) {
                return RestClientProvider.getResponse(builder.POST(publisher).build(), handler, callback);
            }
            if (requestMethod == RequestMethod.PATCH) {
                return RestClientProvider.getResponse(builder.method(RequestMethod.PATCH.name(), publisher).build(), handler, callback);
            }
            if (requestMethod == RequestMethod.PUT) {
                return RestClientProvider.getResponse(builder.PUT(publisher).build(), handler, callback);
            }
            if (requestMethod == RequestMethod.DELETE) {
                return RestClientProvider.getResponse(builder.DELETE().build(), handler, callback);
            }
        }
        throw new AzDException(ApiExceptionTypes.InvalidArgumentException.name(), "Connection object cannot be null.");
    }
}

