/*
 * Decompiled with CFR 0.152.
 */
package org.azd.utils;

import java.net.http.HttpResponse;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.azd.common.types.LocationUrl;
import org.azd.enums.ApiExceptionTypes;
import org.azd.enums.Instance;
import org.azd.enums.RequestMethod;
import org.azd.exceptions.AzDException;
import org.azd.helpers.JsonMapper;
import org.azd.utils.BaseRestClient;

public final class RestClientProvider
extends BaseRestClient {
    protected static final JsonMapper MAPPER = new JsonMapper();
    private static final String API_RELATIVE_PATH = "_apis";
    private static final String API_PREVIEW_INDICATOR = "?api-preview=";
    private static final String API_VERSION_INDICATOR = "?api-version=";

    private static String getLocationUrl(String resourceID, String organizationName) throws AzDException {
        String INSTANCE = Instance.BASE_INSTANCE.getInstance();
        if (resourceID == null) {
            return INSTANCE + organizationName;
        }
        if (resourceID.equals("accounts")) {
            return Instance.ACCOUNT_INSTANCE.getInstance();
        }
        String url = INSTANCE + organizationName + "/_apis/resourceAreas/" + resourceID + API_PREVIEW_INDICATOR + "5.0-preview.1";
        try {
            String response = (String)((CompletableFuture)RestClientProvider.response(RequestMethod.GET, url, null, null, HttpResponse.BodyHandlers.ofString(), null, false).thenApplyAsync(HttpResponse::body)).join();
            String r = MAPPER.mapJsonResponse(response, LocationUrl.class).getLocationUrl();
            return r.replaceAll("/$", "");
        }
        catch (Exception e) {
            throw new AzDException(ApiExceptionTypes.InvalidOrganizationNameException.name(), "Couldn't find the organization name '" + organizationName + "'.");
        }
    }

    protected static String buildRequestUrl(String organizationName, String resourceId, String project, String area, String id, String resource, String apiVersion, Map<String, Object> queryString) throws AzDException {
        String pathSeparator = "/";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(RestClientProvider.getLocationUrl(resourceId, organizationName));
        if (project != null) {
            stringBuilder.append(pathSeparator).append(project);
        }
        stringBuilder.append(pathSeparator + API_RELATIVE_PATH);
        if (area != null) {
            stringBuilder.append(pathSeparator).append(area);
        }
        if (id != null) {
            stringBuilder.append(pathSeparator).append(id);
        }
        if (resource != null) {
            stringBuilder.append(pathSeparator).append(resource);
        }
        stringBuilder.append(API_VERSION_INDICATOR).append(apiVersion);
        if (queryString != null) {
            for (String key : queryString.keySet()) {
                stringBuilder.append(RestClientProvider.getQueryString(key, queryString.get(key)));
            }
        }
        return stringBuilder.toString();
    }

    private static String getQueryString(String key, Object value) {
        return "&" + key + "=" + String.valueOf(value);
    }
}

