/*
 * Decompiled with CFR 0.152.
 */
package org.azd.wiki;

import java.io.InputStream;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.azd.connection.Connection;
import org.azd.enums.CustomHeader;
import org.azd.enums.GitVersionOptions;
import org.azd.enums.GitVersionType;
import org.azd.enums.RequestMethod;
import org.azd.enums.VersionControlRecursionType;
import org.azd.exceptions.AzDException;
import org.azd.helpers.JsonMapper;
import org.azd.helpers.StreamHelper;
import org.azd.helpers.URLHelper;
import org.azd.interfaces.WikiDetails;
import org.azd.utils.AzDAsyncApi;
import org.azd.utils.RestClient;
import org.azd.wiki.types.WikiAttachment;
import org.azd.wiki.types.WikiCreateParameters;
import org.azd.wiki.types.WikiPage;
import org.azd.wiki.types.WikiPageDetail;
import org.azd.wiki.types.WikiPageMove;
import org.azd.wiki.types.WikiPageMoveParameters;
import org.azd.wiki.types.WikiV2;
import org.azd.wiki.types.WikiV2Pages;

public class WikiApi
extends AzDAsyncApi<WikiApi>
implements WikiDetails {
    private final Connection CONNECTION;
    private final JsonMapper MAPPER = new JsonMapper();
    private final String AREA = "wiki/wikis";
    private final String WIKI = "bf7d82a0-8aa5-4613-94ef-6172a5ea01f3";

    public WikiApi(Connection connection) {
        this.CONNECTION = connection;
    }

    @Override
    public WikiV2 createWiki(WikiCreateParameters wikiCreateParameters) throws AzDException {
        if (wikiCreateParameters.getProjectId() == null) {
            throw new AzDException("Project id cannot be empty.");
        }
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "bf7d82a0-8aa5-4613-94ef-6172a5ea01f3", wikiCreateParameters.getProjectId(), "wiki/wikis", null, null, "7.1-preview.2", null, wikiCreateParameters, CustomHeader.JSON_CONTENT_TYPE);
        return this.MAPPER.mapJsonResponse(r, WikiV2.class);
    }

    @Override
    public WikiV2 deleteWiki(String wikiIdentifier) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "bf7d82a0-8aa5-4613-94ef-6172a5ea01f3", this.CONNECTION.getProject(), "wiki/wikis", wikiIdentifier, null, "7.1-preview.2", null, null, null);
        return this.MAPPER.mapJsonResponse(r, WikiV2.class);
    }

    @Override
    public WikiV2 getWiki(String wikiIdentifier) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "bf7d82a0-8aa5-4613-94ef-6172a5ea01f3", this.CONNECTION.getProject(), "wiki/wikis", wikiIdentifier, null, "7.1-preview.2", null, null, null);
        return this.MAPPER.mapJsonResponse(r, WikiV2.class);
    }

    @Override
    public WikiV2Pages getWikis() throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "bf7d82a0-8aa5-4613-94ef-6172a5ea01f3", this.CONNECTION.getProject(), "wiki/wikis", null, null, "7.1-preview.2", null, null, null);
        return this.MAPPER.mapJsonResponse(r, WikiV2Pages.class);
    }

    @Override
    public WikiAttachment createWikiAttachment(String wikiIdentifier, final String name, InputStream content) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("name", name != null ? URLHelper.encodeSpecialWithSpace(name) : null);
            }
        };
        String body = StreamHelper.convertStreamToBase64(content);
        CompletableFuture<HttpResponse<String>> r = RestClient.send(null, RequestMethod.PUT, this.CONNECTION, "bf7d82a0-8aa5-4613-94ef-6172a5ea01f3", this.CONNECTION.getProject(), "wiki/wikis", wikiIdentifier, "attachments", "7.1-preview.1", q, HttpRequest.BodyPublishers.ofString(body), HttpResponse.BodyHandlers.ofString(), Map.of("Stream", CustomHeader.STREAM), false);
        WikiAttachment result = this.MAPPER.mapJsonResponse((String)((CompletableFuture)r.thenApplyAsync(HttpResponse::body)).join(), WikiAttachment.class);
        String eTag = this.getValueFromHeader((HttpHeaders)((CompletableFuture)r.thenApplyAsync(HttpResponse::headers)).join(), "etag");
        if (eTag != null) {
            result.seteTag(eTag);
        }
        return result;
    }

    @Override
    public WikiAttachment createWikiAttachment(String wikiIdentifier, final String name, final String version, final GitVersionType versionType, final GitVersionOptions versionOptions, InputStream content) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("name", name != null ? URLHelper.encodeSpecialWithSpace(name) : null);
                this.put("version", version);
                this.put("versionType", versionType.name());
                this.put("versionOptions", versionOptions.name());
            }
        };
        String body = StreamHelper.convertStreamToBase64(content);
        CompletableFuture<HttpResponse<String>> r = RestClient.send(null, RequestMethod.PUT, this.CONNECTION, "bf7d82a0-8aa5-4613-94ef-6172a5ea01f3", this.CONNECTION.getProject(), "wiki/wikis", wikiIdentifier, "attachments", "7.1-preview.1", q, HttpRequest.BodyPublishers.ofString(body), HttpResponse.BodyHandlers.ofString(), Map.of("Stream", CustomHeader.STREAM), false);
        WikiAttachment result = this.MAPPER.mapJsonResponse((String)((CompletableFuture)r.thenApplyAsync(HttpResponse::body)).join(), WikiAttachment.class);
        String eTag = this.getValueFromHeader((HttpHeaders)((CompletableFuture)r.thenApplyAsync(HttpResponse::headers)).join(), "etag");
        if (eTag != null) {
            result.seteTag(eTag);
        }
        return result;
    }

    @Override
    public WikiPageMove createPageMove(String wikiIdentifier, final String comment, WikiPageMoveParameters pageMoveParameters) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("comment", comment != null ? URLHelper.encodeSpecialWithSpace(comment) : null);
            }
        };
        CompletableFuture<HttpResponse<String>> r = RestClient.send(null, RequestMethod.POST, this.CONNECTION, "bf7d82a0-8aa5-4613-94ef-6172a5ea01f3", this.CONNECTION.getProject(), "wiki/wikis", wikiIdentifier, "pagemoves", "7.1-preview.1", q, HttpRequest.BodyPublishers.ofString(this.MAPPER.convertToString(pageMoveParameters)), HttpResponse.BodyHandlers.ofString(), Map.of("Content-Type", CustomHeader.JSON_CONTENT_TYPE), false);
        WikiPageMove result = this.MAPPER.mapJsonResponse((String)((CompletableFuture)r.thenApplyAsync(HttpResponse::body)).join(), WikiPageMove.class);
        String eTag = this.getValueFromHeader((HttpHeaders)((CompletableFuture)r.thenApplyAsync(HttpResponse::headers)).join(), "etag");
        if (eTag != null) {
            result.seteTag(eTag);
        }
        return result;
    }

    @Override
    public WikiPageMove createPageMove(String wikiIdentifier, final String comment, final String version, final GitVersionType versionType, final GitVersionOptions versionOptions, WikiPageMoveParameters pageMoveParameters) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("comment", comment);
                this.put("version", version);
                this.put("versionType", versionType.name());
                this.put("versionOptions", versionOptions.name());
            }
        };
        CompletableFuture<HttpResponse<String>> r = RestClient.send(null, RequestMethod.POST, this.CONNECTION, "bf7d82a0-8aa5-4613-94ef-6172a5ea01f3", this.CONNECTION.getProject(), "wiki/wikis", wikiIdentifier, "pagemoves", "7.1-preview.1", q, HttpRequest.BodyPublishers.ofString(this.MAPPER.convertToString(pageMoveParameters)), HttpResponse.BodyHandlers.ofString(), Map.of("Content-Type", CustomHeader.JSON_CONTENT_TYPE), false);
        WikiPageMove result = this.MAPPER.mapJsonResponse((String)((CompletableFuture)r.thenApplyAsync(HttpResponse::body)).join(), WikiPageMove.class);
        String eTag = this.getValueFromHeader((HttpHeaders)((CompletableFuture)r.thenApplyAsync(HttpResponse::headers)).join(), "etag");
        if (eTag != null) {
            result.seteTag(eTag);
        }
        return result;
    }

    @Override
    public WikiPageDetail getPageStats(String wikiIdentifier, int pageId, final int pageViewsForDays) throws AzDException {
        HashMap<String, Integer> q = new HashMap<String, Integer>(){
            {
                this.put("pageViewsForDays", pageViewsForDays);
            }
        };
        String r = RestClient.send(RequestMethod.POST, this.CONNECTION, "bf7d82a0-8aa5-4613-94ef-6172a5ea01f3", this.CONNECTION.getProject(), "wiki/wikis", wikiIdentifier, "pages/" + pageId + "/stats", "7.1-preview.1", q, null, CustomHeader.JSON);
        return this.MAPPER.mapJsonResponse(r, WikiPageDetail.class);
    }

    @Override
    public WikiPage createOrUpdateWikiPage(String wikiIdentifier, final String path, final String comment, String eTagVersion, String content) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("path", path);
                this.put("comment", comment != null ? URLHelper.encodeSpecialWithSpace(comment) : null);
            }
        };
        HashMap<String, CustomHeader> headers = new HashMap<String, CustomHeader>(){
            {
                this.put("Content-Type", CustomHeader.JSON_CONTENT_TYPE);
            }
        };
        if (eTagVersion != null) {
            CustomHeader.CUSTOM_HEADER.setCustomHeaders("If-Match", eTagVersion);
            headers.put("If-Match", CustomHeader.CUSTOM_HEADER);
        }
        CompletableFuture<HttpResponse<String>> r = RestClient.send(null, RequestMethod.PUT, this.CONNECTION, "bf7d82a0-8aa5-4613-94ef-6172a5ea01f3", this.CONNECTION.getProject(), "wiki/wikis", wikiIdentifier, "pages", "7.1-preview.1", q, HttpRequest.BodyPublishers.ofString(this.MAPPER.convertToString(Map.of("content", content))), HttpResponse.BodyHandlers.ofString(), (Map<String, CustomHeader>)headers, false);
        WikiPage result = this.MAPPER.mapJsonResponse((String)((CompletableFuture)r.thenApplyAsync(HttpResponse::body)).join(), WikiPage.class);
        String eTag = this.getValueFromHeader((HttpHeaders)((CompletableFuture)r.thenApplyAsync(HttpResponse::headers)).join(), "etag");
        if (eTag != null) {
            result.seteTag(eTag);
        }
        return result;
    }

    @Override
    public WikiPage createOrUpdateWikiPage(String wikiIdentifier, final String path, final String comment, String eTagVersion, final String version, final GitVersionType versionType, final GitVersionOptions versionOptions, String content) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("path", path);
                this.put("comment", comment != null ? URLHelper.encodeSpecialWithSpace(comment) : null);
                this.put("version", version);
                this.put("versionType", versionType.name());
                this.put("versionOptions", versionOptions.name());
            }
        };
        HashMap<String, CustomHeader> headers = new HashMap<String, CustomHeader>(){
            {
                this.put("Content-Type", CustomHeader.JSON_CONTENT_TYPE);
            }
        };
        if (eTagVersion != null) {
            CustomHeader.CUSTOM_HEADER.setCustomHeaders("If-Match", eTagVersion);
            headers.put("If-Match", CustomHeader.CUSTOM_HEADER);
        }
        CompletableFuture<HttpResponse<String>> r = RestClient.send(null, RequestMethod.PUT, this.CONNECTION, "bf7d82a0-8aa5-4613-94ef-6172a5ea01f3", this.CONNECTION.getProject(), "wiki/wikis", wikiIdentifier, "pages", "7.1-preview.1", q, HttpRequest.BodyPublishers.ofString(this.MAPPER.convertToString(Map.of("content", content))), HttpResponse.BodyHandlers.ofString(), (Map<String, CustomHeader>)headers, false);
        WikiPage result = this.MAPPER.mapJsonResponse((String)((CompletableFuture)r.thenApplyAsync(HttpResponse::body)).join(), WikiPage.class);
        String eTag = this.getValueFromHeader((HttpHeaders)((CompletableFuture)r.thenApplyAsync(HttpResponse::headers)).join(), "etag");
        if (eTag != null) {
            result.seteTag(eTag);
        }
        return result;
    }

    @Override
    public WikiPage deleteWikiPage(String wikiIdentifier, final String path, final String comment) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("path", path);
                this.put("comment", comment != null ? URLHelper.encodeSpecialWithSpace(comment) : null);
            }
        };
        CompletableFuture<HttpResponse<String>> r = RestClient.send(null, RequestMethod.DELETE, this.CONNECTION, "bf7d82a0-8aa5-4613-94ef-6172a5ea01f3", this.CONNECTION.getProject(), "wiki/wikis", wikiIdentifier, "pages", "7.1-preview.1", q, null, HttpResponse.BodyHandlers.ofString(), Map.of("Content-Type", CustomHeader.JSON_CONTENT_TYPE), false);
        WikiPage result = this.MAPPER.mapJsonResponse((String)((CompletableFuture)r.thenApplyAsync(HttpResponse::body)).join(), WikiPage.class);
        String eTag = this.getValueFromHeader((HttpHeaders)((CompletableFuture)r.thenApplyAsync(HttpResponse::headers)).join(), "etag");
        if (eTag != null) {
            result.seteTag(eTag);
        }
        return result;
    }

    @Override
    public WikiPage deleteWikiPage(String wikiIdentifier, final String path, final String comment, final String version, final GitVersionType versionType, final GitVersionOptions versionOptions) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("path", path);
                this.put("comment", comment != null ? URLHelper.encodeSpecialWithSpace(comment) : null);
                this.put("version", version);
                this.put("versionType", versionType.name());
                this.put("versionOptions", versionOptions.name());
            }
        };
        CompletableFuture<HttpResponse<String>> r = RestClient.send(null, RequestMethod.DELETE, this.CONNECTION, "bf7d82a0-8aa5-4613-94ef-6172a5ea01f3", this.CONNECTION.getProject(), "wiki/wikis", wikiIdentifier, "pages", "7.1-preview.1", q, null, HttpResponse.BodyHandlers.ofString(), Map.of("Content-Type", CustomHeader.JSON_CONTENT_TYPE), false);
        WikiPage result = this.MAPPER.mapJsonResponse((String)((CompletableFuture)r.thenApplyAsync(HttpResponse::body)).join(), WikiPage.class);
        String eTag = this.getValueFromHeader((HttpHeaders)((CompletableFuture)r.thenApplyAsync(HttpResponse::headers)).join(), "etag");
        if (eTag != null) {
            result.seteTag(eTag);
        }
        return result;
    }

    @Override
    public WikiPage deleteWikiPageById(String id, String wikiIdentifier, final String path, final String comment, String version, GitVersionType versionType, GitVersionOptions versionOptions) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("path", path);
                this.put("comment", comment != null ? URLHelper.encodeSpecialWithSpace(comment) : null);
            }
        };
        CompletableFuture<HttpResponse<String>> r = RestClient.send(null, RequestMethod.DELETE, this.CONNECTION, "bf7d82a0-8aa5-4613-94ef-6172a5ea01f3", this.CONNECTION.getProject(), "wiki/wikis", wikiIdentifier, "pages/" + id, "7.1-preview.1", q, null, HttpResponse.BodyHandlers.ofString(), Map.of("Content-Type", CustomHeader.JSON_CONTENT_TYPE), false);
        WikiPage result = this.MAPPER.mapJsonResponse((String)((CompletableFuture)r.thenApplyAsync(HttpResponse::body)).join(), WikiPage.class);
        String eTag = this.getValueFromHeader((HttpHeaders)((CompletableFuture)r.thenApplyAsync(HttpResponse::headers)).join(), "etag");
        if (eTag != null) {
            result.seteTag(eTag);
        }
        return result;
    }

    @Override
    public WikiPage getWikiPage(String wikiIdentifier) throws AzDException {
        CompletableFuture<HttpResponse<String>> r = RestClient.send(null, RequestMethod.GET, this.CONNECTION, "bf7d82a0-8aa5-4613-94ef-6172a5ea01f3", this.CONNECTION.getProject(), "wiki/wikis", wikiIdentifier, "pages", "7.1-preview.1", null, null, HttpResponse.BodyHandlers.ofString(), null, false);
        WikiPage result = this.MAPPER.mapJsonResponse((String)((CompletableFuture)r.thenApplyAsync(HttpResponse::body)).join(), WikiPage.class);
        String eTag = this.getValueFromHeader((HttpHeaders)((CompletableFuture)r.thenApplyAsync(HttpResponse::headers)).join(), "etag");
        if (eTag != null) {
            result.seteTag(eTag);
        }
        return result;
    }

    @Override
    public WikiPage getWikiPage(String wikiIdentifier, final boolean includeContent, final String path, final VersionControlRecursionType recursionLevel, final String comment, final String version, final GitVersionType versionType, final GitVersionOptions versionOptions) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("path", path);
                this.put("includeContent", includeContent);
                this.put("comment", comment != null ? URLHelper.encodeSpecialWithSpace(comment) : null);
                this.put("recursionLevel", recursionLevel.name());
                this.put("version", version);
                this.put("versionType", versionType.name());
                this.put("versionOptions", versionOptions.name());
            }
        };
        CompletableFuture<HttpResponse<String>> r = RestClient.send(null, RequestMethod.GET, this.CONNECTION, "bf7d82a0-8aa5-4613-94ef-6172a5ea01f3", this.CONNECTION.getProject(), "wiki/wikis", wikiIdentifier, "pages", "7.1-preview.1", q, null, HttpResponse.BodyHandlers.ofString(), null, false);
        WikiPage result = this.MAPPER.mapJsonResponse((String)((CompletableFuture)r.thenApplyAsync(HttpResponse::body)).join(), WikiPage.class);
        String eTag = this.getValueFromHeader((HttpHeaders)((CompletableFuture)r.thenApplyAsync(HttpResponse::headers)).join(), "etag");
        if (eTag != null) {
            result.seteTag(eTag);
        }
        return result;
    }

    @Override
    public WikiPage getWikiPage(String wikiIdentifier, boolean includeContent, String path, VersionControlRecursionType recursionLevel) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>();
        if (includeContent) {
            q.put("includeContent", true);
        }
        if (path != null) {
            q.put("path", URLHelper.encodeSpecialWithSpace(path));
        }
        if (recursionLevel != null) {
            q.put("recursionLevel", recursionLevel.name());
        }
        CompletableFuture<HttpResponse<String>> r = RestClient.send(null, RequestMethod.GET, this.CONNECTION, "bf7d82a0-8aa5-4613-94ef-6172a5ea01f3", this.CONNECTION.getProject(), "wiki/wikis", wikiIdentifier, "pages", "7.1-preview.1", q, null, HttpResponse.BodyHandlers.ofString(), null, false);
        WikiPage result = this.MAPPER.mapJsonResponse((String)((CompletableFuture)r.thenApplyAsync(HttpResponse::body)).join(), WikiPage.class);
        String eTag = this.getValueFromHeader((HttpHeaders)((CompletableFuture)r.thenApplyAsync(HttpResponse::headers)).join(), "etag");
        if (eTag != null) {
            result.seteTag(eTag);
        }
        return result;
    }

    @Override
    public WikiPage getWikiPageById(String id, String wikiIdentifier) throws AzDException {
        CompletableFuture<HttpResponse<String>> r = RestClient.send(null, RequestMethod.GET, this.CONNECTION, "bf7d82a0-8aa5-4613-94ef-6172a5ea01f3", this.CONNECTION.getProject(), "wiki/wikis", wikiIdentifier, "pages/" + id, "7.1-preview.1", null, null, HttpResponse.BodyHandlers.ofString(), null, false);
        WikiPage result = this.MAPPER.mapJsonResponse((String)((CompletableFuture)r.thenApplyAsync(HttpResponse::body)).join(), WikiPage.class);
        String eTag = this.getValueFromHeader((HttpHeaders)((CompletableFuture)r.thenApplyAsync(HttpResponse::headers)).join(), "etag");
        if (eTag != null) {
            result.seteTag(eTag);
        }
        return result;
    }

    @Override
    public WikiPage getWikiPageById(String id, String wikiIdentifier, final boolean includeContent, final VersionControlRecursionType recursionLevel) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("includeContent", includeContent);
                this.put("recursionLevel", recursionLevel.name());
            }
        };
        CompletableFuture<HttpResponse<String>> r = RestClient.send(null, RequestMethod.GET, this.CONNECTION, "bf7d82a0-8aa5-4613-94ef-6172a5ea01f3", this.CONNECTION.getProject(), "wiki/wikis", wikiIdentifier, "pages/" + id, "7.1-preview.1", q, null, HttpResponse.BodyHandlers.ofString(), null, false);
        WikiPage result = this.MAPPER.mapJsonResponse((String)((CompletableFuture)r.thenApplyAsync(HttpResponse::body)).join(), WikiPage.class);
        String eTag = this.getValueFromHeader((HttpHeaders)((CompletableFuture)r.thenApplyAsync(HttpResponse::headers)).join(), "etag");
        if (eTag != null) {
            result.seteTag(eTag);
        }
        return result;
    }

    @Override
    public String getWikiPageContent(String id, String wikiIdentifier) throws AzDException {
        CompletableFuture<HttpResponse<String>> r = RestClient.send(null, RequestMethod.GET, this.CONNECTION, "bf7d82a0-8aa5-4613-94ef-6172a5ea01f3", this.CONNECTION.getProject(), "wiki/wikis", wikiIdentifier, "pages/" + id, "7.1-preview.1", null, null, HttpResponse.BodyHandlers.ofString(), Map.of("Content-Type", CustomHeader.TEXT_CONTENT), false);
        return (String)((CompletableFuture)r.thenApplyAsync(HttpResponse::body)).join();
    }

    @Override
    public InputStream getWikiPageAsZip(String id, String wikiIdentifier) throws AzDException {
        CompletableFuture<HttpResponse<InputStream>> r = RestClient.send(null, RequestMethod.GET, this.CONNECTION, "bf7d82a0-8aa5-4613-94ef-6172a5ea01f3", this.CONNECTION.getProject(), "wiki/wikis", wikiIdentifier, "pages/" + id, "7.1-preview.1", null, null, HttpResponse.BodyHandlers.ofInputStream(), Map.of("Stream-Zip", CustomHeader.STREAM_ZIP_ACCEPT), false);
        return (InputStream)((CompletableFuture)r.thenApplyAsync(HttpResponse::body)).join();
    }

    @Override
    public WikiPage updateWikiPage(String id, String wikiIdentifier, final String comment, String eTagVersion, String content) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("comment", comment != null ? URLHelper.encodeSpecialWithSpace(comment) : null);
            }
        };
        CustomHeader.CUSTOM_HEADER.setCustomHeaders("If-Match", eTagVersion);
        HashMap<String, CustomHeader> headers = new HashMap<String, CustomHeader>(){
            {
                this.put("Content-Type", CustomHeader.JSON_CONTENT_TYPE);
                this.put("If-Match", CustomHeader.CUSTOM_HEADER);
            }
        };
        CompletableFuture<HttpResponse<String>> r = RestClient.send(null, RequestMethod.PATCH, this.CONNECTION, "bf7d82a0-8aa5-4613-94ef-6172a5ea01f3", this.CONNECTION.getProject(), "wiki/wikis", wikiIdentifier, "pages/" + id, "7.1-preview.1", q, HttpRequest.BodyPublishers.ofString(this.MAPPER.convertToString(Map.of("content", content))), HttpResponse.BodyHandlers.ofString(), (Map<String, CustomHeader>)headers, false);
        WikiPage result = this.MAPPER.mapJsonResponse((String)((CompletableFuture)r.thenApplyAsync(HttpResponse::body)).join(), WikiPage.class);
        String eTag = this.getValueFromHeader((HttpHeaders)((CompletableFuture)r.thenApplyAsync(HttpResponse::headers)).join(), "etag");
        if (eTag != null) {
            result.seteTag(eTag);
        }
        return result;
    }

    private String getValueFromHeader(HttpHeaders headers, String keyName) {
        if (headers.firstValue(keyName).isPresent()) {
            return headers.firstValue(keyName).get().replaceAll("\"", "");
        }
        return null;
    }
}

