/*
 * Decompiled with CFR 0.152.
 */
package org.azd.work;

import java.util.HashMap;
import java.util.Map;
import org.azd.connection.Connection;
import org.azd.enums.IterationsTimeFrame;
import org.azd.enums.RequestMethod;
import org.azd.exceptions.AzDException;
import org.azd.helpers.JsonMapper;
import org.azd.helpers.URLHelper;
import org.azd.interfaces.WorkDetails;
import org.azd.utils.AzDAsyncApi;
import org.azd.utils.RestClient;
import org.azd.work.types.IterationWorkItems;
import org.azd.work.types.TeamSettingsIteration;
import org.azd.work.types.TeamSettingsIterations;

public class WorkApi
extends AzDAsyncApi<WorkApi>
implements WorkDetails {
    private final Connection CONNECTION;
    private final JsonMapper MAPPER = new JsonMapper();
    private final String AREA = "work";
    private final String WORK = "1d4f49f9-02b9-4e26-b826-2cdb6195f2a9";

    public WorkApi(Connection connection) {
        this.CONNECTION = connection;
    }

    @Override
    public TeamSettingsIterations getTeamSettingsIterations(String teamName) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "1d4f49f9-02b9-4e26-b826-2cdb6195f2a9", this.CONNECTION.getProject() + "/" + URLHelper.encodeSpace(teamName), "work", null, "teamsettings/iterations", "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, TeamSettingsIterations.class);
    }

    @Override
    public TeamSettingsIterations getTeamSettingsIterations(String teamName, final IterationsTimeFrame timeFrame) throws AzDException {
        HashMap<String, Object> q = new HashMap<String, Object>(){
            {
                this.put("$timeframe", timeFrame.toString().toLowerCase());
            }
        };
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "1d4f49f9-02b9-4e26-b826-2cdb6195f2a9", this.CONNECTION.getProject() + "/" + URLHelper.encodeSpace(teamName), "work", null, "teamsettings/iterations", "7.1-preview.1", q, null, null);
        return this.MAPPER.mapJsonResponse(r, TeamSettingsIterations.class);
    }

    @Override
    public IterationWorkItems getTeamIterationWorkItems(String teamName, String iterationId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "1d4f49f9-02b9-4e26-b826-2cdb6195f2a9", this.CONNECTION.getProject() + "/" + URLHelper.encodeSpace(teamName), "work/teamsettings/iterations", iterationId, "workitems", "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, IterationWorkItems.class);
    }

    @Override
    public TeamSettingsIteration getTeamSettingsIteration(String teamName, String iterationId) throws AzDException {
        String r = RestClient.send(RequestMethod.GET, this.CONNECTION, "1d4f49f9-02b9-4e26-b826-2cdb6195f2a9", this.CONNECTION.getProject() + "/" + URLHelper.encodeSpace(teamName), "work/teamsettings/iterations", iterationId, null, "7.1-preview.1", null, null, null);
        return this.MAPPER.mapJsonResponse(r, TeamSettingsIteration.class);
    }

    @Override
    public Void deleteTeamSettingsIteration(String teamName, String iterationId) throws AzDException {
        String r = RestClient.send(RequestMethod.DELETE, this.CONNECTION, "1d4f49f9-02b9-4e26-b826-2cdb6195f2a9", this.CONNECTION.getProject() + "/" + URLHelper.encodeSpace(teamName), "work/teamsettings/iterations", iterationId, null, "7.1-preview.1", null, null, null);
        if (!r.isEmpty()) {
            this.MAPPER.mapJsonResponse(r, Map.class);
        }
        return null;
    }
}

