/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Paint;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.PainterUtils;
import org.jdesktop.swingx.util.PaintUtils;

public class CheckerboardPainter
extends AbstractPainter<Component> {
    private transient Paint checkerPaint;
    private Paint darkPaint = new Color(204, 204, 204);
    private Paint lightPaint = Color.WHITE;
    private int squareSize = 8;

    @Override
    protected void doPaint(Graphics2D g, Component t, int width, int height) {
        g.setPaint(this.getCheckerPaint(t));
        g.fillRect(0, 0, width, height);
    }

    public CheckerboardPainter() {
    }

    public CheckerboardPainter(Paint darkPaint, Paint lightPaint) {
        this(darkPaint, lightPaint, 8);
    }

    public CheckerboardPainter(Paint darkPaint, Paint lightPaint, int squareSize) {
        this.darkPaint = darkPaint;
        this.lightPaint = lightPaint;
        this.squareSize = squareSize;
    }

    public void setSquareSize(int squareSize) {
        if (squareSize <= 0) {
            throw new IllegalArgumentException("Length must be > 0");
        }
        double old = this.getSquareSize();
        this.squareSize = squareSize;
        this.checkerPaint = null;
        this.setDirty(true);
        this.firePropertyChange("squareSize", old, this.getSquareSize());
    }

    public int getSquareSize() {
        return this.squareSize;
    }

    public void setDarkPaint(Paint color) {
        Paint old = this.getDarkPaint();
        this.darkPaint = color;
        this.checkerPaint = null;
        this.setDirty(true);
        this.firePropertyChange("darkPaint", old, this.getDarkPaint());
    }

    public Paint getDarkPaint() {
        return this.darkPaint;
    }

    public void setLightPaint(Paint color) {
        Paint old = this.getLightPaint();
        this.lightPaint = color;
        this.checkerPaint = null;
        this.setDirty(true);
        this.firePropertyChange("lightPaint", old, this.getLightPaint());
    }

    public Paint getLightPaint() {
        return this.lightPaint;
    }

    private Paint getCheckerPaint(Object c) {
        if (this.checkerPaint == null) {
            Paint p1 = PainterUtils.getForegroundPaint(this.getLightPaint(), c);
            Paint p2 = PainterUtils.getBackgroundPaint(this.getDarkPaint(), c);
            this.checkerPaint = PaintUtils.getCheckerPaint((Paint)p1, (Paint)p2, (int)(this.getSquareSize() * 2));
        }
        return this.checkerPaint;
    }
}

