/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Pipeline;
import redis.embedded.Redis;
import redis.embedded.RedisClusterBuilder;
import redis.embedded.exceptions.EmbeddedRedisException;

public class RedisCluster
implements Redis {
    private final List<Redis> servers = new LinkedList<Redis>();
    private List<Integer> mastersPorts;
    private List<Integer> slavesPorts;

    RedisCluster(List<Redis> servers, List<Integer> mastersPorts, List<Integer> slavesPorts) {
        this.servers.addAll(servers);
        this.mastersPorts = mastersPorts;
        this.slavesPorts = slavesPorts;
    }

    @Override
    public boolean isActive() {
        for (Redis redis : this.servers) {
            if (redis.isActive()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void start() throws EmbeddedRedisException, InterruptedException {
        for (Redis redis : this.servers) {
            redis.start();
        }
        Integer clusterMeetTarget = this.mastersPorts.get(0);
        Jedis j = null;
        try {
            Integer i = 0;
            while (i < this.mastersPorts.size()) {
                Serializable err;
                try {
                    j = new Jedis("127.0.0.1", this.mastersPorts.get(i).intValue());
                    if (!i.equals(clusterMeetTarget)) {
                        j.clusterMeet("127.0.0.1", clusterMeetTarget.intValue());
                    }
                    Integer finalI = i;
                    Pipeline jp = j.pipelined();
                    IntStream.range(0, 16384).filter(is -> Integer.valueOf(is % this.mastersPorts.size()).equals(finalI)).forEach(xva$0 -> jp.clusterAddSlots(new int[]{xva$0}));
                    jp.sync();
                }
                catch (Exception e) {
                    err = new EmbeddedRedisException("Failed creating master instance at port: " + this.mastersPorts.get(i));
                    err.setStackTrace(e.getStackTrace());
                    throw err;
                }
                finally {
                    if (j != null) {
                        j.close();
                        j = null;
                    }
                }
                Integer e = i;
                i = i + 1;
                err = i;
            }
        }
        catch (EmbeddedRedisException e) {
            this.stop();
            throw e;
        }
        Thread.sleep(this.mastersPorts.size() * 300);
        try {
            for (Integer sp : this.slavesPorts) {
                try {
                    j = new Jedis("127.0.0.1", sp.intValue());
                    j.clusterMeet("127.0.0.1", clusterMeetTarget.intValue());
                }
                catch (Exception e) {
                    EmbeddedRedisException err = new EmbeddedRedisException("Failed creating slave instance at port: " + sp);
                    err.setStackTrace(e.getStackTrace());
                    throw err;
                }
                finally {
                    if (j == null) continue;
                    j.close();
                    j = null;
                }
            }
        }
        catch (EmbeddedRedisException e) {
            this.stop();
            throw e;
        }
        Thread.sleep(500L);
    }

    @Override
    public void stop() throws EmbeddedRedisException {
        for (Redis redis : this.servers) {
            redis.stop();
        }
    }

    @Override
    public List<Integer> ports() {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        ports.addAll(this.serverPorts());
        return ports;
    }

    public List<Integer> serverPorts() {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        ports.addAll(this.mastersPorts);
        ports.addAll(this.slavesPorts);
        return ports;
    }

    public static RedisClusterBuilder builder() {
        return new RedisClusterBuilder();
    }
}

