/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import redis.embedded.PortProvider;
import redis.embedded.Redis;
import redis.embedded.RedisCluster;
import redis.embedded.RedisServer;
import redis.embedded.RedisServerBuilder;
import redis.embedded.ports.EphemeralPortProvider;
import redis.embedded.ports.PredefinedPortProvider;
import redis.embedded.ports.SequencePortProvider;

public class RedisClusterBuilder {
    private RedisServerBuilder serverBuilder = new RedisServerBuilder();
    private PortProvider replicationGroupPortProvider = new SequencePortProvider(6379);
    private final List<ReplicationGroup> groups = new LinkedList<ReplicationGroup>();
    private final List<Integer> mastersPorts = new ArrayList<Integer>();
    private final List<Integer> slavesPorts = new ArrayList<Integer>();

    public RedisClusterBuilder withServerBuilder(RedisServerBuilder serverBuilder) {
        this.serverBuilder = serverBuilder;
        return this;
    }

    public RedisClusterBuilder serverPorts(Collection<Integer> ports) {
        this.replicationGroupPortProvider = new PredefinedPortProvider(ports);
        return this;
    }

    public RedisClusterBuilder ephemeralServers() {
        this.replicationGroupPortProvider = new EphemeralPortProvider();
        return this;
    }

    public RedisClusterBuilder ephemeral() {
        this.ephemeralServers();
        return this;
    }

    public RedisClusterBuilder replicationGroup(String masterName, int slaveCount) {
        this.groups.add(new ReplicationGroup(masterName, slaveCount, this.replicationGroupPortProvider));
        return this;
    }

    public RedisCluster build() {
        List<Redis> servers = this.buildServers();
        return new RedisCluster(servers, this.mastersPorts, this.slavesPorts);
    }

    private List<Redis> buildServers() {
        ArrayList<Redis> servers = new ArrayList<Redis>();
        for (ReplicationGroup g : this.groups) {
            servers.add(this.buildMaster(g));
            this.buildSlaves(servers, g);
        }
        return servers;
    }

    private void buildSlaves(List<Redis> servers, ReplicationGroup g) {
        for (Integer slavePort : g.slavePorts) {
            this.slavesPorts.add(slavePort);
            this.serverBuilder.reset();
            this.serverBuilder.port(slavePort);
            RedisServer slave = this.serverBuilder.setting("cluster-enabled yes").setting("cluster-config-file nodes-slave-" + slavePort + ".conf").setting("cluster-node-timeout 5000").setting("appendonly no").build();
            servers.add(slave);
        }
    }

    private Redis buildMaster(ReplicationGroup g) {
        this.mastersPorts.add(g.masterPort);
        this.serverBuilder.reset();
        return this.serverBuilder.port(g.masterPort).setting("cluster-enabled yes").setting("cluster-config-file nodes-slave-" + g.masterPort + ".conf").setting("cluster-node-timeout 5000").setting("appendonly no").build();
    }

    private static class ReplicationGroup {
        private final String masterName;
        private final int masterPort;
        private final List<Integer> slavePorts = new LinkedList<Integer>();

        private ReplicationGroup(String masterName, int slaveCount, PortProvider portProvider) {
            this.masterName = masterName;
            this.masterPort = portProvider.next();
            while (slaveCount-- > 0) {
                this.slavePorts.add(portProvider.next());
            }
        }
    }
}

