/*
 * Decompiled with CFR 0.152.
 */
package io.github.hqktech;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class JDWP {
    public static final int PACKET_HEADER_SIZE = 11;
    private static final byte[] HANDSHAKE_BYTES = "JDWP-Handshake".getBytes();
    private final ValueTag valueTag;
    private final VirtualMachine virtualMachine;
    private final ReferenceType referenceType;
    private final ClassType classType;
    private final ArrayType arrayType;
    private final InterfaceType interfaceType;
    private final Method method;
    private final Field field;
    private final ObjectReference objectReference;
    private final StringReference stringReference;
    private final ThreadReference threadReference;
    private final ThreadGroupReference threadGroupReference;
    private final ArrayReference arrayReference;
    private final ClassLoaderReference classLoaderReference;
    private final EventRequest eventRequest;
    private final StackFrame stackFrame;
    private final ClassObjectReference classObjectReference;
    private final Event event;
    private final JdwpObjectID mObjectID;
    private final JdwpTaggedobjectID mTaggedobjectID;
    private final JdwpThreadID mThreadID;
    private final JdwpThreadGroupID mThreadGroupID;
    private final JdwpStringID mStringID;
    private final JdwpModuleID mModuleID;
    private final JdwpClassLoaderID mClassLoaderID;
    private final JdwpClassObjectID mClassObjectID;
    private final JdwpArrayID mArrayID;
    private final JdwpReferenceTypeID mReferenceTypeID;
    private final JdwpClassID mClassID;
    private final JdwpInterfaceID mInterfaceID;
    private final JdwpArrayTypeID mArrayTypeID;
    private final JdwpMethodID mMethodID;
    private final JdwpFieldID mFieldID;
    private final JdwpFrameID mFrameID;
    private final JdwpLocation mLocation;
    private final JdwpValue mValue;
    private final JdwpUntaggedvalue mUntaggedvalue;
    private final JdwpArrayregion mArrayregion;

    public JDWP(IDSizes.IDSizesReplyData sizes) {
        this(sizes.fieldIDSize, sizes.methodIDSize, sizes.objectIDSize, sizes.referenceTypeIDSize, sizes.frameIDSize);
    }

    private JDWP(int fieldIDSize, int methodIDSize, int objectIDSize, int referenceTypeIDSize, int frameIDSize) {
        this.valueTag = new ValueTag(objectIDSize);
        this.virtualMachine = new VirtualMachine();
        this.referenceType = new ReferenceType();
        this.classType = new ClassType();
        this.arrayType = new ArrayType();
        this.interfaceType = new InterfaceType();
        this.method = new Method();
        this.field = new Field();
        this.objectReference = new ObjectReference();
        this.stringReference = new StringReference();
        this.threadReference = new ThreadReference();
        this.threadGroupReference = new ThreadGroupReference();
        this.arrayReference = new ArrayReference();
        this.classLoaderReference = new ClassLoaderReference();
        this.eventRequest = new EventRequest();
        this.stackFrame = new StackFrame();
        this.classObjectReference = new ClassObjectReference();
        this.event = new Event();
        this.mObjectID = new JdwpObjectID(objectIDSize);
        this.mTaggedobjectID = new JdwpTaggedobjectID(objectIDSize);
        this.mThreadID = new JdwpThreadID(objectIDSize);
        this.mThreadGroupID = new JdwpThreadGroupID(objectIDSize);
        this.mStringID = new JdwpStringID(objectIDSize);
        this.mModuleID = new JdwpModuleID(objectIDSize);
        this.mClassLoaderID = new JdwpClassLoaderID(objectIDSize);
        this.mClassObjectID = new JdwpClassObjectID(objectIDSize);
        this.mArrayID = new JdwpArrayID(objectIDSize);
        this.mReferenceTypeID = new JdwpReferenceTypeID(referenceTypeIDSize);
        this.mClassID = new JdwpClassID(referenceTypeIDSize);
        this.mInterfaceID = new JdwpInterfaceID(referenceTypeIDSize);
        this.mArrayTypeID = new JdwpArrayTypeID(referenceTypeIDSize);
        this.mMethodID = new JdwpMethodID(methodIDSize);
        this.mFieldID = new JdwpFieldID(fieldIDSize);
        this.mFrameID = new JdwpFrameID(frameIDSize);
        this.mLocation = new JdwpLocation(referenceTypeIDSize, methodIDSize);
        this.mValue = new JdwpValue();
        this.mUntaggedvalue = new JdwpUntaggedvalue();
        this.mArrayregion = new JdwpArrayregion();
    }

    public VirtualMachine virtualMachine() {
        return this.virtualMachine;
    }

    public ReferenceType referenceType() {
        return this.referenceType;
    }

    public ClassType classType() {
        return this.classType;
    }

    public ArrayType arrayType() {
        return this.arrayType;
    }

    public InterfaceType interfaceType() {
        return this.interfaceType;
    }

    public Method method() {
        return this.method;
    }

    public Field field() {
        return this.field;
    }

    public ObjectReference objectReference() {
        return this.objectReference;
    }

    public StringReference stringReference() {
        return this.stringReference;
    }

    public ThreadReference threadReference() {
        return this.threadReference;
    }

    public ThreadGroupReference threadGroupReference() {
        return this.threadGroupReference;
    }

    public ArrayReference arrayReference() {
        return this.arrayReference;
    }

    public ClassLoaderReference classLoaderReference() {
        return this.classLoaderReference;
    }

    public EventRequest eventRequest() {
        return this.eventRequest;
    }

    public StackFrame stackFrame() {
        return this.stackFrame;
    }

    public ClassObjectReference classObjectReference() {
        return this.classObjectReference;
    }

    public Event event() {
        return this.event;
    }

    public static byte[] encodeHandShakePacket() {
        return HANDSHAKE_BYTES;
    }

    public static boolean decodeHandShakePacket(byte[] bytes) {
        return Arrays.equals(HANDSHAKE_BYTES, bytes);
    }

    public static int getPacketLength(byte[] bytes, int start) throws JdwpRuntimeException {
        return JDWP.decodeInt(bytes, start);
    }

    public static int getPacketID(byte[] bytes, int start) throws JdwpRuntimeException {
        return JDWP.decodeInt(bytes, start + 4);
    }

    public static byte getPacketFlags(byte[] bytes, int start) throws JdwpRuntimeException {
        return JDWP.decodeByte(bytes, start + 8);
    }

    public static boolean isReplyPacket(byte[] bytes, int start) throws JdwpRuntimeException {
        return (JDWP.decodeByte(bytes, start + 8) & 0xFF) == 128;
    }

    public static boolean isEventPacket(byte[] bytes, int start) throws JdwpRuntimeException {
        return !JDWP.isReplyPacket(bytes, start) && JDWP.getPacketCommandSetID(bytes, start) == 64 && JDWP.getPacketCommandID(bytes, start) == 100;
    }

    public static short getPacketErrorCode(byte[] bytes, int start) throws JdwpRuntimeException {
        return JDWP.decodeShort(bytes, start + 9);
    }

    public static int getPacketCommandSetID(byte[] bytes, int start) throws JdwpRuntimeException {
        return JDWP.decodeByte(bytes, start + 9);
    }

    public static int getPacketCommandID(byte[] bytes, int start) throws JdwpRuntimeException {
        return JDWP.decodeByte(bytes, start + 10);
    }

    public static void setPacketID(byte[] bytes, int id) {
        bytes[4] = (byte)(id >> 24);
        bytes[5] = (byte)(id >> 16);
        bytes[6] = (byte)(id >> 8);
        bytes[7] = (byte)id;
    }

    private static void setPacketLen(ByteBuffer bytes) {
        int size = bytes.size();
        bytes.set(0, (byte)(size >> 24)).set(1, (byte)(size >> 16)).set(2, (byte)(size >> 8)).set(3, (byte)size);
    }

    private static ByteBuffer encodeCommandPacket(int setID, int commandID) {
        byte[] bytes = new byte[11];
        bytes[9] = (byte)setID;
        bytes[10] = (byte)commandID;
        ByteBuffer buf = new ByteBuffer(bytes);
        return buf;
    }

    private static void checkCapability(byte[] bytes, int start, int size) throws JdwpRuntimeException {
        if (bytes.length - start < size) {
            throw new JdwpRuntimeException(String.format("Insufficient space for decoding, size(%d) > bytes.length(%d).", size, bytes.length - start));
        }
    }

    public static long decodeBySize(byte[] bytes, int start, int size) throws JdwpRuntimeException {
        int i;
        JDWP.checkCapability(bytes, start, size);
        long rst = 0L;
        int shift = 56;
        for (i = 0; i < 8 - size; ++i) {
            shift -= 8;
        }
        for (i = 0; i < size && start < bytes.length; ++i, ++start) {
            rst += (long)(bytes[start] & 0xFF) << shift - i * 8;
        }
        return rst;
    }

    public static byte decodeByte(byte[] bytes, int start) throws JdwpRuntimeException {
        JDWP.checkCapability(bytes, start, 1);
        return (byte)(bytes[start] & 0xFF);
    }

    public static boolean decodeBoolean(byte[] bytes, int start) throws JdwpRuntimeException {
        JDWP.checkCapability(bytes, start, 1);
        return (bytes[start] & 0xFF) == 1;
    }

    public static short decodeShort(byte[] bytes, int start) throws JdwpRuntimeException {
        JDWP.checkCapability(bytes, start, 2);
        short result = (short)((bytes[start] & 0xFF) << 8);
        result = (short)(result + (bytes[start + 1] & 0xFF));
        return result;
    }

    public static char decodeChar(byte[] bytes, int start) throws JdwpRuntimeException {
        JDWP.checkCapability(bytes, start, 2);
        char result = (char)((bytes[start] & 0xFF) << 8);
        result = (char)(result + (bytes[start + 1] & 0xFF));
        return result;
    }

    public static int decodeInt(byte[] bytes, int start) throws JdwpRuntimeException {
        JDWP.checkCapability(bytes, start, 4);
        int result = 0;
        result = (bytes[start] & 0xFF) << 24;
        result += (bytes[start + 1] & 0xFF) << 16;
        result += (bytes[start + 2] & 0xFF) << 8;
        return result += bytes[start + 3] & 0xFF;
    }

    public static float decodeFloat(byte[] bytes, int start) throws JdwpRuntimeException {
        int val = JDWP.decodeInt(bytes, start);
        return Float.intBitsToFloat(val);
    }

    public static double decodeDouble(byte[] bytes, int start) throws JdwpRuntimeException {
        long val = JDWP.decodeBySize(bytes, start, 8);
        return Double.longBitsToDouble(val);
    }

    public static byte[] decodeRaw(byte[] bytes, int start, int size) throws JdwpRuntimeException {
        JDWP.checkCapability(bytes, start, size);
        byte[] raw = new byte[size];
        System.arraycopy(bytes, start, raw, 0, size);
        return raw;
    }

    public static void encodeBySize(ByteBuffer bytes, int size, long val) {
        int i;
        int shift = 56;
        for (i = 0; i < 8 - size; ++i) {
            shift -= 8;
        }
        for (i = 0; i < size; ++i) {
            bytes.add((byte)(val >> shift - i * 8));
        }
    }

    public static void encodeByte(ByteBuffer bytes, byte val) {
        bytes.add(val);
    }

    public static void encodeBoolean(ByteBuffer bytes, boolean val) {
        bytes.add((byte)(val ? 1 : 0));
    }

    public static void encodeShort(ByteBuffer bytes, short val) {
        bytes.add((byte)(val >> 8));
        bytes.add((byte)val);
    }

    public static void encodeChar(ByteBuffer bytes, char val) {
        bytes.add((byte)(val >> 8));
        bytes.add((byte)val);
    }

    public static void encodeInt(ByteBuffer bytes, int val) {
        bytes.add((byte)(val >> 24));
        bytes.add((byte)(val >> 16));
        bytes.add((byte)(val >> 8));
        bytes.add((byte)val);
    }

    public static void encodeFloat(ByteBuffer bytes, float f) {
        int val = Float.floatToRawIntBits(f);
        bytes.add((byte)(val >> 24));
        bytes.add((byte)(val >> 16));
        bytes.add((byte)(val >> 8));
        bytes.add((byte)val);
    }

    public static void encodeDouble(ByteBuffer bytes, double d) {
        long val = Double.doubleToRawLongBits(d);
        JDWP.encodeBySize(bytes, 8, val);
    }

    public static void encodeString(ByteBuffer bytes, String str) {
        JDWP.encodeInt(bytes, str.length());
        JDWP.encodeRaw(bytes, str.getBytes(StandardCharsets.UTF_8));
    }

    public static void encodeRaw(ByteBuffer bytes, ByteBuffer raw) {
        bytes.addAll(raw);
    }

    public static void encodeRaw(ByteBuffer bytes, byte[] raw) {
        bytes.addAll(raw);
    }

    public static void encodeAny(ByteBuffer bytes, Object idOrValue) {
        if (idOrValue instanceof Integer) {
            JDWP.encodeInt(bytes, (Integer)idOrValue);
            return;
        }
        if (idOrValue instanceof String) {
            JDWP.encodeString(bytes, (String)idOrValue);
            return;
        }
        if (idOrValue instanceof Long) {
            JDWP.encodeBySize(bytes, 8, (Long)idOrValue);
            return;
        }
        if (idOrValue instanceof Float) {
            JDWP.encodeFloat(bytes, ((Float)idOrValue).floatValue());
            return;
        }
        if (idOrValue instanceof Double) {
            JDWP.encodeDouble(bytes, (Double)idOrValue);
            return;
        }
        if (idOrValue instanceof Byte) {
            JDWP.encodeByte(bytes, (Byte)idOrValue);
            return;
        }
        if (idOrValue instanceof Character) {
            JDWP.encodeChar(bytes, ((Character)idOrValue).charValue());
            return;
        }
        if (idOrValue instanceof Short) {
            JDWP.encodeShort(bytes, (Short)idOrValue);
            return;
        }
        if (idOrValue instanceof Boolean) {
            JDWP.encodeBoolean(bytes, (Boolean)idOrValue);
            return;
        }
        throw new JdwpRuntimeException("Unexpected type: " + idOrValue);
    }

    public static class ByteBuffer {
        private static final int MIN_INC = 16;
        private byte[] buf;
        private int cap;
        private int size;

        public ByteBuffer() {
            this(24);
        }

        public ByteBuffer(byte[] bytes) {
            this.setBuffer(bytes);
        }

        public ByteBuffer(int initCap) {
            this.buf = new byte[initCap];
            this.cap = initCap;
            this.size = 0;
        }

        private void extend(int incr) {
            this.cap += incr;
            byte[] tempBuf = new byte[this.cap];
            System.arraycopy(this.buf, 0, tempBuf, 0, this.size);
            this.buf = tempBuf;
        }

        public ByteBuffer set(int pos, byte b) {
            this.buf[pos] = b;
            return this;
        }

        public byte get(int pos) {
            return this.buf[pos];
        }

        public ByteBuffer setBuffer(byte[] bs) {
            this.buf = bs;
            this.size = bs.length;
            this.cap = bs.length;
            return this;
        }

        public ByteBuffer setPacketID(int id) {
            JDWP.setPacketID(this.buf, id);
            return this;
        }

        public void add(byte b) {
            if (this.size >= this.cap) {
                this.extend(16);
            }
            this.buf[this.size] = b;
            ++this.size;
        }

        public void addAll(byte[] bs) {
            int newSize = this.size + bs.length;
            if (newSize >= this.cap) {
                this.extend(Math.max(bs.length, 16));
            }
            System.arraycopy(bs, 0, this.buf, this.size, bs.length);
            this.size = newSize;
        }

        public void addAll(ByteBuffer bs) {
            int newSize = this.size + bs.size();
            if (newSize >= this.cap) {
                this.extend(Math.max(bs.size(), 16));
            }
            System.arraycopy(bs.buf, 0, this.buf, this.size, bs.size());
            this.size = newSize;
        }

        public int size() {
            return this.size;
        }

        public byte[] getBytes() {
            return this.getBytes(0);
        }

        public byte[] getBytes(int start) {
            int copySize = this.size - start;
            byte[] ret = new byte[copySize];
            System.arraycopy(this.buf, start, ret, 0, copySize);
            return ret;
        }

        public ByteBuffer resetIndex(int to) {
            this.size = to;
            return this;
        }

        public boolean equals(byte[] bs) {
            return Arrays.equals(this.buf, bs);
        }
    }

    public static class JdwpRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = -1111111202103260221L;

        public JdwpRuntimeException(String msg) {
            super(msg);
        }
    }

    private class ValueTag {
        public int tag;
        public ByteBuffer idOrValue;
        int objectIDSize;

        public ValueTag() {
        }

        public ValueTag(int objectIDSize) {
            this.objectIDSize = objectIDSize;
        }

        public boolean isPrimitive(int tag) throws JdwpRuntimeException {
            switch (tag) {
                case 66: 
                case 67: 
                case 68: 
                case 70: 
                case 73: 
                case 74: 
                case 83: 
                case 86: 
                case 90: {
                    return true;
                }
                case 76: 
                case 91: 
                case 99: 
                case 103: 
                case 108: 
                case 115: 
                case 116: {
                    return false;
                }
            }
            throw new JdwpRuntimeException("Unexpected tag: " + tag);
        }

        public int getSize(int tag) throws JdwpRuntimeException {
            switch (tag) {
                case 91: {
                    return this.objectIDSize;
                }
                case 66: {
                    return 1;
                }
                case 67: {
                    return 2;
                }
                case 76: {
                    return this.objectIDSize;
                }
                case 70: {
                    return 4;
                }
                case 68: {
                    return 8;
                }
                case 73: {
                    return 4;
                }
                case 74: {
                    return 8;
                }
                case 83: {
                    return 2;
                }
                case 86: {
                    return 0;
                }
                case 90: {
                    return 1;
                }
                case 115: {
                    return this.objectIDSize;
                }
                case 116: {
                    return this.objectIDSize;
                }
                case 103: {
                    return this.objectIDSize;
                }
                case 108: {
                    return this.objectIDSize;
                }
                case 99: {
                    return this.objectIDSize;
                }
            }
            throw new JdwpRuntimeException("Unexpected tag: " + tag);
        }

        public boolean getBoolean() throws JdwpRuntimeException {
            return JDWP.decodeBoolean(this.idOrValue.getBytes(), 0);
        }

        public byte getByte() throws JdwpRuntimeException {
            return JDWP.decodeByte(this.idOrValue.getBytes(), 0);
        }

        public char getChar() throws JdwpRuntimeException {
            return JDWP.decodeChar(this.idOrValue.getBytes(), 0);
        }

        public short getShort() throws JdwpRuntimeException {
            return JDWP.decodeShort(this.idOrValue.getBytes(), 0);
        }

        public int getInt() throws JdwpRuntimeException {
            return JDWP.decodeInt(this.idOrValue.getBytes(), 0);
        }

        public float getFloat() throws JdwpRuntimeException {
            return JDWP.decodeFloat(this.idOrValue.getBytes(), 0);
        }

        public double getDouble() throws JdwpRuntimeException {
            return JDWP.decodeDouble(this.idOrValue.getBytes(), 0);
        }

        public long getLong() throws JdwpRuntimeException {
            return JDWP.decodeBySize(this.idOrValue.getBytes(), 0, 8);
        }

        public long getID() throws JdwpRuntimeException {
            return JDWP.this.mObjectID.decode(this.idOrValue.getBytes(), 0);
        }

        public ValueTag encode(int tag, Object idOrValue) throws JdwpRuntimeException {
            ValueTag valueTag = new ValueTag();
            valueTag.tag = tag;
            valueTag.idOrValue = new ByteBuffer();
            switch (tag) {
                case 66: {
                    JDWP.encodeByte(valueTag.idOrValue, (Byte)idOrValue);
                    return valueTag;
                }
                case 67: {
                    JDWP.encodeChar(valueTag.idOrValue, ((Character)idOrValue).charValue());
                    return valueTag;
                }
                case 70: {
                    JDWP.encodeFloat(valueTag.idOrValue, ((Float)idOrValue).floatValue());
                    return valueTag;
                }
                case 68: {
                    JDWP.encodeDouble(valueTag.idOrValue, (Double)idOrValue);
                    return valueTag;
                }
                case 73: {
                    JDWP.encodeInt(valueTag.idOrValue, (Integer)idOrValue);
                    return valueTag;
                }
                case 74: {
                    JDWP.encodeBySize(valueTag.idOrValue, 8, (Long)idOrValue);
                    return valueTag;
                }
                case 83: {
                    JDWP.encodeShort(valueTag.idOrValue, (Short)idOrValue);
                    return valueTag;
                }
                case 86: {
                    return valueTag;
                }
                case 90: {
                    JDWP.encodeBoolean(valueTag.idOrValue, (Boolean)idOrValue);
                    return valueTag;
                }
                case 76: 
                case 91: 
                case 99: 
                case 103: 
                case 108: 
                case 115: 
                case 116: {
                    JDWP.this.mObjectID.encode((Long)idOrValue, valueTag.idOrValue);
                    return valueTag;
                }
            }
            throw new JdwpRuntimeException("Unexpected tag: " + tag);
        }
    }

    private class JdwpArrayregion {
        private JdwpArrayregion() {
        }

        ArrayRegionPacket decode(byte[] bytes, int start) throws JdwpRuntimeException {
            ArrayRegionPacket arrayRegionPacket = new ArrayRegionPacket();
            byte tag = JDWP.decodeByte(bytes, start);
            int arrayLen = JDWP.decodeInt(bytes, start + 1);
            int tagSize = JDWP.this.valueTag.getSize(tag);
            boolean isPrim = JDWP.this.valueTag.isPrimitive(tag);
            arrayRegionPacket.tag = tag;
            arrayRegionPacket.arrayLen = arrayLen;
            if (tagSize > 0 && arrayLen > 0) {
                arrayRegionPacket.idOrValues = new ArrayList<Long>(arrayLen);
                start += 5;
                for (int i = 0; i < arrayLen; ++i) {
                    if (!isPrim) {
                        ++start;
                    }
                    arrayRegionPacket.idOrValues.add(JDWP.decodeBySize(bytes, start, tagSize));
                    start += tagSize;
                }
            } else {
                arrayRegionPacket.idOrValues = Collections.emptyList();
            }
            return arrayRegionPacket;
        }

        void encode(ArrayRegionPacket val, ByteBuffer bytes) throws JdwpRuntimeException {
            JDWP.encodeByte(bytes, (byte)val.tag);
            JDWP.encodeInt(bytes, val.arrayLen);
            int tagSize = JDWP.this.valueTag.getSize(val.tag);
            for (Long idOrVal : val.idOrValues) {
                JDWP.encodeBySize(bytes, tagSize, idOrVal);
            }
        }

        public int getSize(int arrayLen, int tag) throws JdwpRuntimeException {
            return 5 + JDWP.this.valueTag.getSize(tag) * arrayLen;
        }

        public class ArrayRegionPacket {
            public int tag;
            public int arrayLen;
            public List<Long> idOrValues;
        }
    }

    public class UntaggedValuePacket
    extends ValueTag {
    }

    private class JdwpUntaggedvalue {
        private JdwpUntaggedvalue() {
        }

        UntaggedValuePacket decode(byte[] bytes, int start, int tag) throws JdwpRuntimeException {
            UntaggedValuePacket untaggedValuePacket = new UntaggedValuePacket();
            untaggedValuePacket.tag = tag;
            untaggedValuePacket.idOrValue = new ByteBuffer(JDWP.decodeRaw(bytes, start, this.getSize(tag)));
            return untaggedValuePacket;
        }

        void encode(UntaggedValuePacket val, ByteBuffer bytes) {
            JDWP.encodeRaw(bytes, val.idOrValue);
        }

        int getSize(int tag) throws JdwpRuntimeException {
            return JDWP.this.valueTag.getSize(tag);
        }
    }

    public class ValuePacket
    extends ValueTag {
    }

    private class JdwpValue {
        private JdwpValue() {
        }

        ValuePacket decode(byte[] bytes, int start) throws JdwpRuntimeException {
            ValuePacket valuePacket = new ValuePacket();
            byte tag = JDWP.decodeByte(bytes, start);
            valuePacket.tag = tag;
            int tagSize = this.getSize(tag) - 1;
            valuePacket.idOrValue = new ByteBuffer(JDWP.decodeRaw(bytes, start + 1, tagSize));
            return valuePacket;
        }

        void encode(ValuePacket val, ByteBuffer bytes) throws JdwpRuntimeException {
            JDWP.encodeByte(bytes, (byte)val.tag);
            JDWP.encodeRaw(bytes, val.idOrValue);
        }

        int getSize(int tag) throws JdwpRuntimeException {
            return 1 + JDWP.this.valueTag.getSize(tag);
        }
    }

    private static class JdwpString {
        private JdwpString() {
        }

        static String decode(byte[] bytes, int start) throws JdwpRuntimeException {
            int len = JDWP.decodeInt(bytes, start);
            return new String(JDWP.decodeRaw(bytes, start + 4, len), StandardCharsets.UTF_8);
        }

        static void encode(String val, ByteBuffer bytes) {
            JDWP.encodeInt(bytes, val.length());
            bytes.addAll(val.getBytes(StandardCharsets.UTF_8));
        }

        static int getSize(String str) {
            return 4 + str.length();
        }
    }

    private static class JdwpLocation {
        int size;
        int classIDSize;
        int methodIDSize;

        JdwpLocation(int classIDSize, int methodIDSize) {
            this.classIDSize = classIDSize;
            this.methodIDSize = methodIDSize;
            this.size = classIDSize + methodIDSize;
        }

        LocationPacket decode(byte[] bytes, int start) throws JdwpRuntimeException {
            LocationPacket locationPacket = new LocationPacket();
            locationPacket.tag = JDWP.decodeByte(bytes, start);
            locationPacket.classID = JDWP.decodeBySize(bytes, start + 1, this.classIDSize);
            locationPacket.methodID = JDWP.decodeBySize(bytes, start + this.classIDSize + 1, this.methodIDSize);
            locationPacket.index = JDWP.decodeBySize(bytes, start + this.classIDSize + this.methodIDSize + 1, 8);
            return locationPacket;
        }

        void encode(LocationPacket val, ByteBuffer bytes) {
            JDWP.encodeByte(bytes, (byte)val.tag);
            JDWP.encodeBySize(bytes, this.classIDSize, val.classID);
            JDWP.encodeBySize(bytes, this.methodIDSize, val.methodID);
            JDWP.encodeBySize(bytes, 8, val.index);
        }

        int getSize() {
            return 1 + this.size + 8;
        }

        public static class LocationPacket {
            public int tag;
            public long classID;
            public long methodID;
            public long index;
        }
    }

    private class JdwpFrameID {
        private int size;

        JdwpFrameID(int frameIDSize) {
            this.size = frameIDSize;
        }

        long decode(byte[] bytes, int start) throws JdwpRuntimeException {
            return JDWP.decodeBySize(bytes, start, this.getSize());
        }

        void encode(long val, ByteBuffer bytes) {
            JDWP.encodeBySize(bytes, this.getSize(), val);
        }

        int getSize() {
            return this.size;
        }
    }

    private class JdwpFieldID {
        private int size;

        JdwpFieldID(int fieldIDSize) {
            this.size = fieldIDSize;
        }

        long decode(byte[] bytes, int start) throws JdwpRuntimeException {
            return JDWP.decodeBySize(bytes, start, this.getSize());
        }

        void encode(long val, ByteBuffer bytes) {
            JDWP.encodeBySize(bytes, this.getSize(), val);
        }

        int getSize() {
            return this.size;
        }
    }

    private class JdwpMethodID {
        private int size;

        JdwpMethodID(int methodIDSize) {
            this.size = methodIDSize;
        }

        long decode(byte[] bytes, int start) throws JdwpRuntimeException {
            return JDWP.decodeBySize(bytes, start, this.getSize());
        }

        void encode(long val, ByteBuffer bytes) {
            JDWP.encodeBySize(bytes, this.getSize(), val);
        }

        int getSize() {
            return this.size;
        }
    }

    private class JdwpArrayTypeID {
        private int size;

        JdwpArrayTypeID(int referenceTypeIDSize) {
            this.size = referenceTypeIDSize;
        }

        long decode(byte[] bytes, int start) throws JdwpRuntimeException {
            return JDWP.decodeBySize(bytes, start, this.getSize());
        }

        void encode(long val, ByteBuffer bytes) {
            JDWP.encodeBySize(bytes, this.getSize(), val);
        }

        int getSize() {
            return this.size;
        }
    }

    private class JdwpInterfaceID {
        private int size;

        JdwpInterfaceID(int referenceTypeIDSize) {
            this.size = referenceTypeIDSize;
        }

        long decode(byte[] bytes, int start) throws JdwpRuntimeException {
            return JDWP.decodeBySize(bytes, start, this.getSize());
        }

        void encode(long val, ByteBuffer bytes) {
            JDWP.encodeBySize(bytes, this.getSize(), val);
        }

        int getSize() {
            return this.size;
        }
    }

    private class JdwpClassID {
        private int size;

        JdwpClassID(int referenceTypeIDSize) {
            this.size = referenceTypeIDSize;
        }

        long decode(byte[] bytes, int start) throws JdwpRuntimeException {
            return JDWP.decodeBySize(bytes, start, this.getSize());
        }

        void encode(long val, ByteBuffer bytes) {
            JDWP.encodeBySize(bytes, this.getSize(), val);
        }

        int getSize() {
            return this.size;
        }
    }

    private class JdwpReferenceTypeID {
        private int size;

        JdwpReferenceTypeID(int referenceTypeIDSize) {
            this.size = referenceTypeIDSize;
        }

        long decode(byte[] bytes, int start) throws JdwpRuntimeException {
            return JDWP.decodeBySize(bytes, start, this.getSize());
        }

        void encode(long val, ByteBuffer bytes) {
            JDWP.encodeBySize(bytes, this.getSize(), val);
        }

        int getSize() {
            return this.size;
        }
    }

    private class JdwpArrayID {
        private int size;

        JdwpArrayID(int objectIDSize) {
            this.size = objectIDSize;
        }

        long decode(byte[] bytes, int start) throws JdwpRuntimeException {
            return JDWP.decodeBySize(bytes, start, this.getSize());
        }

        void encode(long val, ByteBuffer bytes) {
            JDWP.encodeBySize(bytes, this.getSize(), val);
        }

        int getSize() {
            return this.size;
        }
    }

    private class JdwpClassObjectID {
        private int size;

        JdwpClassObjectID(int objectIDSize) {
            this.size = objectIDSize;
        }

        long decode(byte[] bytes, int start) throws JdwpRuntimeException {
            return JDWP.decodeBySize(bytes, start, this.getSize());
        }

        void encode(long val, ByteBuffer bytes) {
            JDWP.encodeBySize(bytes, this.getSize(), val);
        }

        int getSize() {
            return this.size;
        }
    }

    private class JdwpClassLoaderID {
        private int size;

        JdwpClassLoaderID(int objectIDSize) {
            this.size = objectIDSize;
        }

        long decode(byte[] bytes, int start) throws JdwpRuntimeException {
            return JDWP.decodeBySize(bytes, start, this.getSize());
        }

        void encode(long val, ByteBuffer bytes) {
            JDWP.encodeBySize(bytes, this.getSize(), val);
        }

        int getSize() {
            return this.size;
        }
    }

    private class JdwpModuleID {
        private int size;

        JdwpModuleID(int objectIDSize) {
            this.size = objectIDSize;
        }

        long decode(byte[] bytes, int start) throws JdwpRuntimeException {
            return JDWP.decodeBySize(bytes, start, this.getSize());
        }

        void encode(long val, ByteBuffer bytes) {
            JDWP.encodeBySize(bytes, this.getSize(), val);
        }

        int getSize() {
            return this.size;
        }
    }

    private class JdwpStringID {
        private int size;

        JdwpStringID(int objectIDSize) {
            this.size = objectIDSize;
        }

        long decode(byte[] bytes, int start) throws JdwpRuntimeException {
            return JDWP.decodeBySize(bytes, start, this.getSize());
        }

        void encode(long val, ByteBuffer bytes) {
            JDWP.encodeBySize(bytes, this.getSize(), val);
        }

        int getSize() {
            return this.size;
        }
    }

    private class JdwpThreadGroupID {
        private int size;

        JdwpThreadGroupID(int objectIDSize) {
            this.size = objectIDSize;
        }

        long decode(byte[] bytes, int start) throws JdwpRuntimeException {
            return JDWP.decodeBySize(bytes, start, this.getSize());
        }

        void encode(long val, ByteBuffer bytes) {
            JDWP.encodeBySize(bytes, this.getSize(), val);
        }

        int getSize() {
            return this.size;
        }
    }

    private class JdwpThreadID {
        private int size;

        JdwpThreadID(int objectIDSize) {
            this.size = objectIDSize;
        }

        long decode(byte[] bytes, int start) throws JdwpRuntimeException {
            return JDWP.decodeBySize(bytes, start, this.getSize());
        }

        void encode(long val, ByteBuffer bytes) {
            JDWP.encodeBySize(bytes, this.getSize(), val);
        }

        int getSize() {
            return this.size;
        }
    }

    private class JdwpTaggedobjectID {
        private int size;

        JdwpTaggedobjectID(int objectIDSize) {
            this.size = objectIDSize;
        }

        TaggedObjectIDPacket decode(byte[] bytes, int start) throws JdwpRuntimeException {
            TaggedObjectIDPacket taggedObjectIDPacket = new TaggedObjectIDPacket();
            taggedObjectIDPacket.tag = JDWP.decodeByte(bytes, start);
            taggedObjectIDPacket.objectID = JDWP.decodeBySize(bytes, start + 1, this.size);
            return taggedObjectIDPacket;
        }

        void encode(TaggedObjectIDPacket val, ByteBuffer bytes) {
            JDWP.encodeByte(bytes, (byte)val.tag);
            JDWP.encodeBySize(bytes, this.size, val.objectID);
        }

        int getSize() {
            return 1 + this.size;
        }

        public class TaggedObjectIDPacket {
            public int tag;
            public long objectID;
        }
    }

    private class JdwpObjectID {
        private int size;

        JdwpObjectID(int objectIDSize) {
            this.size = objectIDSize;
        }

        long decode(byte[] bytes, int start) throws JdwpRuntimeException {
            return JDWP.decodeBySize(bytes, start, this.getSize());
        }

        void encode(long val, ByteBuffer bytes) {
            JDWP.encodeBySize(bytes, this.getSize(), val);
        }

        int getSize() {
            return this.size;
        }
    }

    private static class JdwpLong {
        private JdwpLong() {
        }

        static long decode(byte[] bytes, int start) throws JdwpRuntimeException {
            return JDWP.decodeBySize(bytes, start, JdwpLong.getSize());
        }

        static void encode(long val, ByteBuffer bytes) {
            JDWP.encodeBySize(bytes, JdwpLong.getSize(), val);
        }

        static int getSize() {
            return 8;
        }
    }

    private static class JdwpInt {
        private JdwpInt() {
        }

        static int decode(byte[] bytes, int start) throws JdwpRuntimeException {
            return JDWP.decodeInt(bytes, start);
        }

        static void encode(int val, ByteBuffer bytes) {
            JDWP.encodeInt(bytes, val);
        }

        static int getSize() {
            return 4;
        }
    }

    private static class JdwpBoolean {
        private JdwpBoolean() {
        }

        static boolean decode(byte[] bytes, int start) throws JdwpRuntimeException {
            return JDWP.decodeBoolean(bytes, start);
        }

        static void encode(boolean val, ByteBuffer bytes) {
            JDWP.encodeBoolean(bytes, val);
        }

        static int getSize() {
            return 1;
        }
    }

    private static class JdwpByte {
        private JdwpByte() {
        }

        static byte decode(byte[] bytes, int start) throws JdwpRuntimeException {
            return JDWP.decodeByte(bytes, start);
        }

        static void encode(byte val, ByteBuffer bytes) {
            JDWP.encodeByte(bytes, val);
        }

        static int getSize() {
            return 1;
        }
    }

    public static class InvokeOptions {
        public static final int INVOKE_SINGLE_THREADED = 1;
        public static final int INVOKE_NONVIRTUAL = 2;
    }

    public static class SuspendPolicy {
        public static final int NONE = 0;
        public static final int EVENT_THREAD = 1;
        public static final int ALL = 2;
    }

    public static class StepSize {
        public static final int MIN = 0;
        public static final int LINE = 1;
    }

    public static class StepDepth {
        public static final int INTO = 0;
        public static final int OVER = 1;
        public static final int OUT = 2;
    }

    public static class Tag {
        public static final int ARRAY = 91;
        public static final int BYTE = 66;
        public static final int CHAR = 67;
        public static final int OBJECT = 76;
        public static final int FLOAT = 70;
        public static final int DOUBLE = 68;
        public static final int INT = 73;
        public static final int LONG = 74;
        public static final int SHORT = 83;
        public static final int VOID = 86;
        public static final int BOOLEAN = 90;
        public static final int STRING = 115;
        public static final int THREAD = 116;
        public static final int THREAD_GROUP = 103;
        public static final int CLASS_LOADER = 108;
        public static final int CLASS_OBJECT = 99;
    }

    public static class TypeTag {
        public static final int CLASS = 1;
        public static final int INTERFACE = 2;
        public static final int ARRAY = 3;
    }

    public static class ClassStatus {
        public static final int VERIFIED = 1;
        public static final int PREPARED = 2;
        public static final int INITIALIZED = 4;
        public static final int ERROR = 8;
    }

    public static class SuspendStatus {
        public static final int SUSPEND_STATUS_SUSPENDED = 1;
    }

    public static class ThreadStatus {
        public static final int ZOMBIE = 0;
        public static final int RUNNING = 1;
        public static final int SLEEPING = 2;
        public static final int MONITOR = 3;
        public static final int WAIT = 4;
    }

    public static class EventKind {
        public static final int SINGLE_STEP = 1;
        public static final int BREAKPOINT = 2;
        public static final int FRAME_POP = 3;
        public static final int EXCEPTION = 4;
        public static final int USER_DEFINED = 5;
        public static final int THREAD_START = 6;
        public static final int THREAD_DEATH = 7;
        public static final int THREAD_END = 7;
        public static final int CLASS_PREPARE = 8;
        public static final int CLASS_UNLOAD = 9;
        public static final int CLASS_LOAD = 10;
        public static final int FIELD_ACCESS = 20;
        public static final int FIELD_MODIFICATION = 21;
        public static final int EXCEPTION_CATCH = 30;
        public static final int METHOD_ENTRY = 40;
        public static final int METHOD_EXIT = 41;
        public static final int METHOD_EXIT_WITH_RETURN_VALUE = 42;
        public static final int MONITOR_CONTENDED_ENTER = 43;
        public static final int MONITOR_CONTENDED_ENTERED = 44;
        public static final int MONITOR_WAIT = 45;
        public static final int MONITOR_WAITED = 46;
        public static final int VM_START = 90;
        public static final int VM_INIT = 90;
        public static final int VM_DEATH = 99;
        public static final int VM_DISCONNECTED = 100;
    }

    public static class Error {
        public static final int NONE = 0;
        public static final int INVALID_THREAD = 10;
        public static final int INVALID_THREAD_GROUP = 11;
        public static final int INVALID_PRIORITY = 12;
        public static final int THREAD_NOT_SUSPENDED = 13;
        public static final int THREAD_SUSPENDED = 14;
        public static final int THREAD_NOT_ALIVE = 15;
        public static final int INVALID_OBJECT = 20;
        public static final int INVALID_CLASS = 21;
        public static final int CLASS_NOT_PREPARED = 22;
        public static final int INVALID_METHODID = 23;
        public static final int INVALID_LOCATION = 24;
        public static final int INVALID_FIELDID = 25;
        public static final int INVALID_FRAMEID = 30;
        public static final int NO_MORE_FRAMES = 31;
        public static final int OPAQUE_FRAME = 32;
        public static final int NOT_CURRENT_FRAME = 33;
        public static final int TYPE_MISMATCH = 34;
        public static final int INVALID_SLOT = 35;
        public static final int DUPLICATE = 40;
        public static final int NOT_FOUND = 41;
        public static final int INVALID_MONITOR = 50;
        public static final int NOT_MONITOR_OWNER = 51;
        public static final int INTERRUPT = 52;
        public static final int INVALID_CLASS_FORMAT = 60;
        public static final int CIRCULAR_CLASS_DEFINITION = 61;
        public static final int FAILS_VERIFICATION = 62;
        public static final int ADD_METHOD_NOT_IMPLEMENTED = 63;
        public static final int SCHEMA_CHANGE_NOT_IMPLEMENTED = 64;
        public static final int INVALID_TYPESTATE = 65;
        public static final int HIERARCHY_CHANGE_NOT_IMPLEMENTED = 66;
        public static final int DELETE_METHOD_NOT_IMPLEMENTED = 67;
        public static final int UNSUPPORTED_VERSION = 68;
        public static final int NAMES_DONT_MATCH = 69;
        public static final int CLASS_MODIFIERS_CHANGE_NOT_IMPLEMENTED = 70;
        public static final int METHOD_MODIFIERS_CHANGE_NOT_IMPLEMENTED = 71;
        public static final int NOT_IMPLEMENTED = 99;
        public static final int NULL_POINTER = 100;
        public static final int ABSENT_INFORMATION = 101;
        public static final int INVALID_EVENT_TYPE = 102;
        public static final int ILLEGAL_ARGUMENT = 103;
        public static final int OUT_OF_MEMORY = 110;
        public static final int ACCESS_DENIED = 111;
        public static final int VM_DEAD = 112;
        public static final int INTERNAL = 113;
        public static final int UNATTACHED_THREAD = 115;
        public static final int INVALID_TAG = 500;
        public static final int ALREADY_INVOKING = 502;
        public static final int INVALID_INDEX = 503;
        public static final int INVALID_LENGTH = 504;
        public static final int INVALID_STRING = 506;
        public static final int INVALID_CLASS_LOADER = 507;
        public static final int INVALID_ARRAY = 508;
        public static final int TRANSPORT_LOAD = 509;
        public static final int TRANSPORT_INIT = 510;
        public static final int NATIVE_METHOD = 511;
        public static final int INVALID_COUNT = 512;

        public static String getErrorText(int errCode) {
            switch (errCode) {
                case 0: {
                    return "No error has occurred.";
                }
                case 10: {
                    return "Passed thread is null, is not a valid thread or has exited.";
                }
                case 11: {
                    return "Thread group invalid.";
                }
                case 12: {
                    return "Invalid priority.";
                }
                case 13: {
                    return "If the specified thread has not been suspended by an event.";
                }
                case 14: {
                    return "Thread already suspended.";
                }
                case 15: {
                    return "Thread has not been started or is now dead.";
                }
                case 20: {
                    return "If this reference type has been unloaded and garbage collected.";
                }
                case 21: {
                    return "Invalid class.";
                }
                case 22: {
                    return "Class has been loaded but not yet prepared.";
                }
                case 23: {
                    return "Invalid method.";
                }
                case 24: {
                    return "Invalid location.";
                }
                case 25: {
                    return "Invalid field.";
                }
                case 30: {
                    return "Invalid jframeID.";
                }
                case 31: {
                    return "There are no more Java or JNI frames on the call stack.";
                }
                case 32: {
                    return "Information about the frame is not available.";
                }
                case 33: {
                    return "Operation can only be performed on current frame.";
                }
                case 34: {
                    return "The variable is not an appropriate type for the function used.";
                }
                case 35: {
                    return "Invalid slot.";
                }
                case 40: {
                    return "Item already set.";
                }
                case 41: {
                    return "Desired element not found.";
                }
                case 50: {
                    return "Invalid monitor.";
                }
                case 51: {
                    return "This thread doesn't own the monitor.";
                }
                case 52: {
                    return "The call has been interrupted before completion.";
                }
                case 60: {
                    return "The virtual machine attempted to read a class file and determined that the file is malformed or otherwise cannot be interpreted as a class file.";
                }
                case 61: {
                    return "A circularity has been detected while initializing a class.";
                }
                case 62: {
                    return "The verifier detected that a class file, though well formed, contained some sort of internal inconsistency or security problem.";
                }
                case 63: {
                    return "Adding methods has not been implemented.";
                }
                case 64: {
                    return "Schema change has not been implemented.";
                }
                case 65: {
                    return "The state of the thread has been modified, and is now inconsistent.";
                }
                case 66: {
                    return "A direct superclass is different for the new class version, or the set of directly implemented interfaces is different and canUnrestrictedlyRedefineClasses is false.";
                }
                case 67: {
                    return "The new class version does not declare a method declared in the old class version and canUnrestrictedlyRedefineClasses is false.";
                }
                case 68: {
                    return "A class file has a version number not supported by this VM.";
                }
                case 69: {
                    return "The class name defined in the new class file is different from the name in the old class object.";
                }
                case 70: {
                    return "The new class version has different modifiers and and canUnrestrictedlyRedefineClasses is false.";
                }
                case 71: {
                    return "A method in the new class version has different modifiers than its counterpart in the old class version and and canUnrestrictedlyRedefineClasses is false.";
                }
                case 99: {
                    return "The functionality is not implemented in this virtual machine.";
                }
                case 100: {
                    return "Invalid pointer.";
                }
                case 101: {
                    return "Desired information is not available.";
                }
                case 102: {
                    return "The specified event type id is not recognized.";
                }
                case 103: {
                    return "Illegal argument.";
                }
                case 110: {
                    return "The function needed to allocate memory and no more memory was available for allocation.";
                }
                case 111: {
                    return "Debugging has not been enabled in this virtual machine. JVMTI cannot be used.";
                }
                case 112: {
                    return "The virtual machine is not running.";
                }
                case 113: {
                    return "An unexpected internal error has occurred.";
                }
                case 115: {
                    return "The thread being used to call this function is not attached to the virtual machine. Calls must be made from attached threads.";
                }
                case 500: {
                    return "object type id or class tag.";
                }
                case 502: {
                    return "Previous invoke not complete.";
                }
                case 503: {
                    return "Index is invalid.";
                }
                case 504: {
                    return "The length is invalid.";
                }
                case 506: {
                    return "The string is invalid.";
                }
                case 507: {
                    return "The class loader is invalid.";
                }
                case 508: {
                    return "The array is invalid.";
                }
                case 509: {
                    return "Unable to load the transport.";
                }
                case 510: {
                    return "Unable to initialize the transport.";
                }
                case 511: {
                    return "NATIVE_METHOD";
                }
                case 512: {
                    return "The count is invalid.";
                }
            }
            return "Unknown error.";
        }
    }

    public static interface EventRequestDecoder {
        public EventRequestDecoder decode(byte[] var1, int[] var2) throws JdwpRuntimeException;

        public int getRequestID();
    }

    public class Event {
        private final Composite cmdComposite = new Composite();

        public Composite cmdComposite() {
            return this.cmdComposite;
        }

        private Event() {
        }

        public class Composite {
            public EventData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                EventData data = new EventData();
                data.suspendPolicy = JdwpByte.decode(bytes, start);
                int events = JdwpInt.decode(bytes, start += JdwpByte.getSize());
                start += JdwpInt.getSize();
                data.events = new ArrayList<EventRequestDecoder>(events);
                int[] starts = new int[]{0};
                for (int i = 0; i < events; ++i) {
                    byte eventKind = JdwpByte.decode(bytes, start);
                    starts[0] = start += JdwpByte.getSize();
                    data.events.add(this.getDecoder(eventKind).decode(bytes, starts));
                    start = starts[0];
                }
                return data;
            }

            private EventRequestDecoder getDecoder(int eventKind) throws JdwpRuntimeException {
                switch (eventKind) {
                    case 90: {
                        return new VMStartEvent();
                    }
                    case 1: {
                        return new SingleStepEvent();
                    }
                    case 2: {
                        return new BreakpointEvent();
                    }
                    case 40: {
                        return new MethodEntryEvent();
                    }
                    case 41: {
                        return new MethodExitEvent();
                    }
                    case 42: {
                        return new MethodExitWithReturnValueEvent();
                    }
                    case 43: {
                        return new MonitorContendedEnterEvent();
                    }
                    case 44: {
                        return new MonitorContendedEnteredEvent();
                    }
                    case 45: {
                        return new MonitorWaitEvent();
                    }
                    case 46: {
                        return new MonitorWaitedEvent();
                    }
                    case 4: {
                        return new ExceptionEvent();
                    }
                    case 6: {
                        return new ThreadStartEvent();
                    }
                    case 7: {
                        return new ThreadDeathEvent();
                    }
                    case 8: {
                        return new ClassPrepareEvent();
                    }
                    case 9: {
                        return new ClassUnloadEvent();
                    }
                    case 20: {
                        return new FieldAccessEvent();
                    }
                    case 21: {
                        return new FieldModificationEvent();
                    }
                    case 99: {
                        return new VMDeathEvent();
                    }
                }
                throw new JdwpRuntimeException("Unexpected event kind: " + eventKind);
            }

            public class VMDeathEvent
            implements EventRequestDecoder {
                public static final byte EVENT_KIND = 99;
                public int requestID;

                @Override
                public EventRequestDecoder decode(byte[] bytes, int[] starts) throws JdwpRuntimeException {
                    int start = starts[0];
                    VMDeathEvent vMDeathEvent = new VMDeathEvent();
                    vMDeathEvent.requestID = JdwpInt.decode(bytes, start);
                    starts[0] = start += JdwpInt.getSize();
                    return vMDeathEvent;
                }

                @Override
                public int getRequestID() {
                    return this.requestID;
                }
            }

            public class FieldModificationEvent
            implements EventRequestDecoder {
                public static final byte EVENT_KIND = 21;
                public int requestID;
                public long thread;
                public JdwpLocation.LocationPacket location;
                public byte refTypeTag;
                public long typeID;
                public long fieldID;
                public JdwpTaggedobjectID.TaggedObjectIDPacket object;
                public ValuePacket valueToBe;

                @Override
                public EventRequestDecoder decode(byte[] bytes, int[] starts) throws JdwpRuntimeException {
                    int start = starts[0];
                    FieldModificationEvent fieldModificationEvent = new FieldModificationEvent();
                    fieldModificationEvent.requestID = JdwpInt.decode(bytes, start);
                    fieldModificationEvent.thread = JDWP.this.mThreadID.decode(bytes, start += JdwpInt.getSize());
                    fieldModificationEvent.location = JDWP.this.mLocation.decode(bytes, start += JDWP.this.mThreadID.getSize());
                    fieldModificationEvent.refTypeTag = JdwpByte.decode(bytes, start += JDWP.this.mLocation.getSize());
                    fieldModificationEvent.typeID = JDWP.this.mReferenceTypeID.decode(bytes, start += JdwpByte.getSize());
                    fieldModificationEvent.fieldID = JDWP.this.mFieldID.decode(bytes, start += JDWP.this.mReferenceTypeID.getSize());
                    fieldModificationEvent.object = JDWP.this.mTaggedobjectID.decode(bytes, start += JDWP.this.mFieldID.getSize());
                    fieldModificationEvent.valueToBe = JDWP.this.mValue.decode(bytes, start += JDWP.this.mTaggedobjectID.getSize());
                    starts[0] = start += JDWP.this.mValue.getSize(fieldModificationEvent.valueToBe.tag);
                    return fieldModificationEvent;
                }

                @Override
                public int getRequestID() {
                    return this.requestID;
                }
            }

            public class FieldAccessEvent
            implements EventRequestDecoder {
                public static final byte EVENT_KIND = 20;
                public int requestID;
                public long thread;
                public JdwpLocation.LocationPacket location;
                public byte refTypeTag;
                public long typeID;
                public long fieldID;
                public JdwpTaggedobjectID.TaggedObjectIDPacket object;

                @Override
                public EventRequestDecoder decode(byte[] bytes, int[] starts) throws JdwpRuntimeException {
                    int start = starts[0];
                    FieldAccessEvent fieldAccessEvent = new FieldAccessEvent();
                    fieldAccessEvent.requestID = JdwpInt.decode(bytes, start);
                    fieldAccessEvent.thread = JDWP.this.mThreadID.decode(bytes, start += JdwpInt.getSize());
                    fieldAccessEvent.location = JDWP.this.mLocation.decode(bytes, start += JDWP.this.mThreadID.getSize());
                    fieldAccessEvent.refTypeTag = JdwpByte.decode(bytes, start += JDWP.this.mLocation.getSize());
                    fieldAccessEvent.typeID = JDWP.this.mReferenceTypeID.decode(bytes, start += JdwpByte.getSize());
                    fieldAccessEvent.fieldID = JDWP.this.mFieldID.decode(bytes, start += JDWP.this.mReferenceTypeID.getSize());
                    fieldAccessEvent.object = JDWP.this.mTaggedobjectID.decode(bytes, start += JDWP.this.mFieldID.getSize());
                    starts[0] = start += JDWP.this.mTaggedobjectID.getSize();
                    return fieldAccessEvent;
                }

                @Override
                public int getRequestID() {
                    return this.requestID;
                }
            }

            public class ClassUnloadEvent
            implements EventRequestDecoder {
                public static final byte EVENT_KIND = 9;
                public int requestID;
                public String signature;

                @Override
                public EventRequestDecoder decode(byte[] bytes, int[] starts) throws JdwpRuntimeException {
                    int start = starts[0];
                    ClassUnloadEvent classUnloadEvent = new ClassUnloadEvent();
                    classUnloadEvent.requestID = JdwpInt.decode(bytes, start);
                    classUnloadEvent.signature = JdwpString.decode(bytes, start += JdwpInt.getSize());
                    starts[0] = start += JdwpString.getSize(classUnloadEvent.signature);
                    return classUnloadEvent;
                }

                @Override
                public int getRequestID() {
                    return this.requestID;
                }
            }

            public class ClassPrepareEvent
            implements EventRequestDecoder {
                public static final byte EVENT_KIND = 8;
                public int requestID;
                public long thread;
                public byte refTypeTag;
                public long typeID;
                public String signature;
                public int status;

                @Override
                public EventRequestDecoder decode(byte[] bytes, int[] starts) throws JdwpRuntimeException {
                    int start = starts[0];
                    ClassPrepareEvent classPrepareEvent = new ClassPrepareEvent();
                    classPrepareEvent.requestID = JdwpInt.decode(bytes, start);
                    classPrepareEvent.thread = JDWP.this.mThreadID.decode(bytes, start += JdwpInt.getSize());
                    classPrepareEvent.refTypeTag = JdwpByte.decode(bytes, start += JDWP.this.mThreadID.getSize());
                    classPrepareEvent.typeID = JDWP.this.mReferenceTypeID.decode(bytes, start += JdwpByte.getSize());
                    classPrepareEvent.signature = JdwpString.decode(bytes, start += JDWP.this.mReferenceTypeID.getSize());
                    classPrepareEvent.status = JdwpInt.decode(bytes, start += JdwpString.getSize(classPrepareEvent.signature));
                    starts[0] = start += JdwpInt.getSize();
                    return classPrepareEvent;
                }

                @Override
                public int getRequestID() {
                    return this.requestID;
                }
            }

            public class ThreadDeathEvent
            implements EventRequestDecoder {
                public static final byte EVENT_KIND = 7;
                public int requestID;
                public long thread;

                @Override
                public EventRequestDecoder decode(byte[] bytes, int[] starts) throws JdwpRuntimeException {
                    int start = starts[0];
                    ThreadDeathEvent threadDeathEvent = new ThreadDeathEvent();
                    threadDeathEvent.requestID = JdwpInt.decode(bytes, start);
                    threadDeathEvent.thread = JDWP.this.mThreadID.decode(bytes, start += JdwpInt.getSize());
                    starts[0] = start += JDWP.this.mThreadID.getSize();
                    return threadDeathEvent;
                }

                @Override
                public int getRequestID() {
                    return this.requestID;
                }
            }

            public class ThreadStartEvent
            implements EventRequestDecoder {
                public static final byte EVENT_KIND = 6;
                public int requestID;
                public long thread;

                @Override
                public EventRequestDecoder decode(byte[] bytes, int[] starts) throws JdwpRuntimeException {
                    int start = starts[0];
                    ThreadStartEvent threadStartEvent = new ThreadStartEvent();
                    threadStartEvent.requestID = JdwpInt.decode(bytes, start);
                    threadStartEvent.thread = JDWP.this.mThreadID.decode(bytes, start += JdwpInt.getSize());
                    starts[0] = start += JDWP.this.mThreadID.getSize();
                    return threadStartEvent;
                }

                @Override
                public int getRequestID() {
                    return this.requestID;
                }
            }

            public class ExceptionEvent
            implements EventRequestDecoder {
                public static final byte EVENT_KIND = 4;
                public int requestID;
                public long thread;
                public JdwpLocation.LocationPacket location;
                public JdwpTaggedobjectID.TaggedObjectIDPacket exception;
                public JdwpLocation.LocationPacket catchLocation;

                @Override
                public EventRequestDecoder decode(byte[] bytes, int[] starts) throws JdwpRuntimeException {
                    int start = starts[0];
                    ExceptionEvent exceptionEvent = new ExceptionEvent();
                    exceptionEvent.requestID = JdwpInt.decode(bytes, start);
                    exceptionEvent.thread = JDWP.this.mThreadID.decode(bytes, start += JdwpInt.getSize());
                    exceptionEvent.location = JDWP.this.mLocation.decode(bytes, start += JDWP.this.mThreadID.getSize());
                    exceptionEvent.exception = JDWP.this.mTaggedobjectID.decode(bytes, start += JDWP.this.mLocation.getSize());
                    exceptionEvent.catchLocation = JDWP.this.mLocation.decode(bytes, start += JDWP.this.mTaggedobjectID.getSize());
                    starts[0] = start += JDWP.this.mLocation.getSize();
                    return exceptionEvent;
                }

                @Override
                public int getRequestID() {
                    return this.requestID;
                }
            }

            public class MonitorWaitedEvent
            implements EventRequestDecoder {
                public static final byte EVENT_KIND = 46;
                public int requestID;
                public long thread;
                public JdwpTaggedobjectID.TaggedObjectIDPacket object;
                public JdwpLocation.LocationPacket location;
                public boolean timedOut;

                @Override
                public EventRequestDecoder decode(byte[] bytes, int[] starts) throws JdwpRuntimeException {
                    int start = starts[0];
                    MonitorWaitedEvent monitorWaitedEvent = new MonitorWaitedEvent();
                    monitorWaitedEvent.requestID = JdwpInt.decode(bytes, start);
                    monitorWaitedEvent.thread = JDWP.this.mThreadID.decode(bytes, start += JdwpInt.getSize());
                    monitorWaitedEvent.object = JDWP.this.mTaggedobjectID.decode(bytes, start += JDWP.this.mThreadID.getSize());
                    monitorWaitedEvent.location = JDWP.this.mLocation.decode(bytes, start += JDWP.this.mTaggedobjectID.getSize());
                    monitorWaitedEvent.timedOut = JdwpBoolean.decode(bytes, start += JDWP.this.mLocation.getSize());
                    starts[0] = start += JdwpBoolean.getSize();
                    return monitorWaitedEvent;
                }

                @Override
                public int getRequestID() {
                    return this.requestID;
                }
            }

            public class MonitorWaitEvent
            implements EventRequestDecoder {
                public static final byte EVENT_KIND = 45;
                public int requestID;
                public long thread;
                public JdwpTaggedobjectID.TaggedObjectIDPacket object;
                public JdwpLocation.LocationPacket location;
                public long timeout;

                @Override
                public EventRequestDecoder decode(byte[] bytes, int[] starts) throws JdwpRuntimeException {
                    int start = starts[0];
                    MonitorWaitEvent monitorWaitEvent = new MonitorWaitEvent();
                    monitorWaitEvent.requestID = JdwpInt.decode(bytes, start);
                    monitorWaitEvent.thread = JDWP.this.mThreadID.decode(bytes, start += JdwpInt.getSize());
                    monitorWaitEvent.object = JDWP.this.mTaggedobjectID.decode(bytes, start += JDWP.this.mThreadID.getSize());
                    monitorWaitEvent.location = JDWP.this.mLocation.decode(bytes, start += JDWP.this.mTaggedobjectID.getSize());
                    monitorWaitEvent.timeout = JdwpLong.decode(bytes, start += JDWP.this.mLocation.getSize());
                    starts[0] = start += JdwpLong.getSize();
                    return monitorWaitEvent;
                }

                @Override
                public int getRequestID() {
                    return this.requestID;
                }
            }

            public class MonitorContendedEnteredEvent
            implements EventRequestDecoder {
                public static final byte EVENT_KIND = 44;
                public int requestID;
                public long thread;
                public JdwpTaggedobjectID.TaggedObjectIDPacket object;
                public JdwpLocation.LocationPacket location;

                @Override
                public EventRequestDecoder decode(byte[] bytes, int[] starts) throws JdwpRuntimeException {
                    int start = starts[0];
                    MonitorContendedEnteredEvent monitorContendedEnteredEvent = new MonitorContendedEnteredEvent();
                    monitorContendedEnteredEvent.requestID = JdwpInt.decode(bytes, start);
                    monitorContendedEnteredEvent.thread = JDWP.this.mThreadID.decode(bytes, start += JdwpInt.getSize());
                    monitorContendedEnteredEvent.object = JDWP.this.mTaggedobjectID.decode(bytes, start += JDWP.this.mThreadID.getSize());
                    monitorContendedEnteredEvent.location = JDWP.this.mLocation.decode(bytes, start += JDWP.this.mTaggedobjectID.getSize());
                    starts[0] = start += JDWP.this.mLocation.getSize();
                    return monitorContendedEnteredEvent;
                }

                @Override
                public int getRequestID() {
                    return this.requestID;
                }
            }

            public class MonitorContendedEnterEvent
            implements EventRequestDecoder {
                public static final byte EVENT_KIND = 43;
                public int requestID;
                public long thread;
                public JdwpTaggedobjectID.TaggedObjectIDPacket object;
                public JdwpLocation.LocationPacket location;

                @Override
                public EventRequestDecoder decode(byte[] bytes, int[] starts) throws JdwpRuntimeException {
                    int start = starts[0];
                    MonitorContendedEnterEvent monitorContendedEnterEvent = new MonitorContendedEnterEvent();
                    monitorContendedEnterEvent.requestID = JdwpInt.decode(bytes, start);
                    monitorContendedEnterEvent.thread = JDWP.this.mThreadID.decode(bytes, start += JdwpInt.getSize());
                    monitorContendedEnterEvent.object = JDWP.this.mTaggedobjectID.decode(bytes, start += JDWP.this.mThreadID.getSize());
                    monitorContendedEnterEvent.location = JDWP.this.mLocation.decode(bytes, start += JDWP.this.mTaggedobjectID.getSize());
                    starts[0] = start += JDWP.this.mLocation.getSize();
                    return monitorContendedEnterEvent;
                }

                @Override
                public int getRequestID() {
                    return this.requestID;
                }
            }

            public class MethodExitWithReturnValueEvent
            implements EventRequestDecoder {
                public static final byte EVENT_KIND = 42;
                public int requestID;
                public long thread;
                public JdwpLocation.LocationPacket location;
                public ValuePacket value;

                @Override
                public EventRequestDecoder decode(byte[] bytes, int[] starts) throws JdwpRuntimeException {
                    int start = starts[0];
                    MethodExitWithReturnValueEvent methodExitWithReturnValueEvent = new MethodExitWithReturnValueEvent();
                    methodExitWithReturnValueEvent.requestID = JdwpInt.decode(bytes, start);
                    methodExitWithReturnValueEvent.thread = JDWP.this.mThreadID.decode(bytes, start += JdwpInt.getSize());
                    methodExitWithReturnValueEvent.location = JDWP.this.mLocation.decode(bytes, start += JDWP.this.mThreadID.getSize());
                    methodExitWithReturnValueEvent.value = JDWP.this.mValue.decode(bytes, start += JDWP.this.mLocation.getSize());
                    starts[0] = start += JDWP.this.mValue.getSize(methodExitWithReturnValueEvent.value.tag);
                    return methodExitWithReturnValueEvent;
                }

                @Override
                public int getRequestID() {
                    return this.requestID;
                }
            }

            public class MethodExitEvent
            implements EventRequestDecoder {
                public static final byte EVENT_KIND = 41;
                public int requestID;
                public long thread;
                public JdwpLocation.LocationPacket location;

                @Override
                public EventRequestDecoder decode(byte[] bytes, int[] starts) throws JdwpRuntimeException {
                    int start = starts[0];
                    MethodExitEvent methodExitEvent = new MethodExitEvent();
                    methodExitEvent.requestID = JdwpInt.decode(bytes, start);
                    methodExitEvent.thread = JDWP.this.mThreadID.decode(bytes, start += JdwpInt.getSize());
                    methodExitEvent.location = JDWP.this.mLocation.decode(bytes, start += JDWP.this.mThreadID.getSize());
                    starts[0] = start += JDWP.this.mLocation.getSize();
                    return methodExitEvent;
                }

                @Override
                public int getRequestID() {
                    return this.requestID;
                }
            }

            public class MethodEntryEvent
            implements EventRequestDecoder {
                public static final byte EVENT_KIND = 40;
                public int requestID;
                public long thread;
                public JdwpLocation.LocationPacket location;

                @Override
                public EventRequestDecoder decode(byte[] bytes, int[] starts) throws JdwpRuntimeException {
                    int start = starts[0];
                    MethodEntryEvent methodEntryEvent = new MethodEntryEvent();
                    methodEntryEvent.requestID = JdwpInt.decode(bytes, start);
                    methodEntryEvent.thread = JDWP.this.mThreadID.decode(bytes, start += JdwpInt.getSize());
                    methodEntryEvent.location = JDWP.this.mLocation.decode(bytes, start += JDWP.this.mThreadID.getSize());
                    starts[0] = start += JDWP.this.mLocation.getSize();
                    return methodEntryEvent;
                }

                @Override
                public int getRequestID() {
                    return this.requestID;
                }
            }

            public class BreakpointEvent
            implements EventRequestDecoder {
                public static final byte EVENT_KIND = 2;
                public int requestID;
                public long thread;
                public JdwpLocation.LocationPacket location;

                @Override
                public EventRequestDecoder decode(byte[] bytes, int[] starts) throws JdwpRuntimeException {
                    int start = starts[0];
                    BreakpointEvent breakpointEvent = new BreakpointEvent();
                    breakpointEvent.requestID = JdwpInt.decode(bytes, start);
                    breakpointEvent.thread = JDWP.this.mThreadID.decode(bytes, start += JdwpInt.getSize());
                    breakpointEvent.location = JDWP.this.mLocation.decode(bytes, start += JDWP.this.mThreadID.getSize());
                    starts[0] = start += JDWP.this.mLocation.getSize();
                    return breakpointEvent;
                }

                @Override
                public int getRequestID() {
                    return this.requestID;
                }
            }

            public class SingleStepEvent
            implements EventRequestDecoder {
                public static final byte EVENT_KIND = 1;
                public int requestID;
                public long thread;
                public JdwpLocation.LocationPacket location;

                @Override
                public EventRequestDecoder decode(byte[] bytes, int[] starts) throws JdwpRuntimeException {
                    int start = starts[0];
                    SingleStepEvent singleStepEvent = new SingleStepEvent();
                    singleStepEvent.requestID = JdwpInt.decode(bytes, start);
                    singleStepEvent.thread = JDWP.this.mThreadID.decode(bytes, start += JdwpInt.getSize());
                    singleStepEvent.location = JDWP.this.mLocation.decode(bytes, start += JDWP.this.mThreadID.getSize());
                    starts[0] = start += JDWP.this.mLocation.getSize();
                    return singleStepEvent;
                }

                @Override
                public int getRequestID() {
                    return this.requestID;
                }
            }

            public class VMStartEvent
            implements EventRequestDecoder {
                public static final byte EVENT_KIND = 90;
                public int requestID;
                public long thread;

                @Override
                public EventRequestDecoder decode(byte[] bytes, int[] starts) throws JdwpRuntimeException {
                    int start = starts[0];
                    VMStartEvent vMStartEvent = new VMStartEvent();
                    vMStartEvent.requestID = JdwpInt.decode(bytes, start);
                    vMStartEvent.thread = JDWP.this.mThreadID.decode(bytes, start += JdwpInt.getSize());
                    starts[0] = start += JDWP.this.mThreadID.getSize();
                    return vMStartEvent;
                }

                @Override
                public int getRequestID() {
                    return this.requestID;
                }
            }

            public class EventData {
                public byte suspendPolicy;
                public List<EventRequestDecoder> events;
            }
        }
    }

    public class ClassObjectReference {
        private final ReflectedType cmdReflectedType = new ReflectedType();

        public ReflectedType cmdReflectedType() {
            return this.cmdReflectedType;
        }

        private ClassObjectReference() {
        }

        public class ReflectedType {
            public ByteBuffer encode(long classObject) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(17, 1);
                JDWP.this.mClassObjectID.encode(classObject, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public ReflectedTypeReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                ReflectedTypeReplyData reflectedTypeReplyData = new ReflectedTypeReplyData();
                reflectedTypeReplyData.refTypeTag = JdwpByte.decode(bytes, start);
                reflectedTypeReplyData.typeID = JDWP.this.mReferenceTypeID.decode(bytes, start += JdwpByte.getSize());
                start += JDWP.this.mReferenceTypeID.getSize();
                return reflectedTypeReplyData;
            }

            public class ReflectedTypeReplyData {
                public byte refTypeTag;
                public long typeID;
            }
        }
    }

    public class StackFrame {
        private final GetValues cmdGetValues = new GetValues();
        private final SetValues cmdSetValues = new SetValues();
        private final ThisObject cmdThisObject = new ThisObject();
        private final PopFrames cmdPopFrames = new PopFrames();

        public GetValues cmdGetValues() {
            return this.cmdGetValues;
        }

        public SetValues cmdSetValues() {
            return this.cmdSetValues;
        }

        public ThisObject cmdThisObject() {
            return this.cmdThisObject;
        }

        public PopFrames cmdPopFrames() {
            return this.cmdPopFrames;
        }

        private StackFrame() {
        }

        public class PopFrames {
            public ByteBuffer encode(long thread, long frame) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(16, 4);
                JDWP.this.mThreadID.encode(thread, bytes);
                JDWP.this.mFrameID.encode(frame, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public boolean decode(byte[] bytes, int start) throws JdwpRuntimeException {
                return bytes.length == 11;
            }
        }

        public class ThisObject {
            public ByteBuffer encode(long thread, long frame) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(16, 3);
                JDWP.this.mThreadID.encode(thread, bytes);
                JDWP.this.mFrameID.encode(frame, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public ThisObjectReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                ThisObjectReplyData thisObjectReplyData = new ThisObjectReplyData();
                thisObjectReplyData.objectThis = JDWP.this.mTaggedobjectID.decode(bytes, start);
                start += JDWP.this.mTaggedobjectID.getSize();
                return thisObjectReplyData;
            }

            public class ThisObjectReplyData {
                public JdwpTaggedobjectID.TaggedObjectIDPacket objectThis;
            }
        }

        public class SetValues {
            public ByteBuffer encode(long thread, long frame, List<SlotValueSetter> slotValues) throws JdwpRuntimeException {
                ByteBuffer bytes = JDWP.encodeCommandPacket(16, 2);
                JDWP.this.mThreadID.encode(thread, bytes);
                JDWP.this.mFrameID.encode(frame, bytes);
                JdwpInt.encode(slotValues.size(), bytes);
                for (int i = 0; i < slotValues.size(); ++i) {
                    SlotValueSetter setValuesSlotValues = slotValues.get(i);
                    JdwpInt.encode(setValuesSlotValues.slot, bytes);
                    JDWP.this.mValue.encode(setValuesSlotValues.slotValue, bytes);
                }
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public boolean decode(byte[] bytes, int start) throws JdwpRuntimeException {
                return bytes.length == 11;
            }

            public class SlotValueSetter {
                public int slot;
                public ValuePacket slotValue;
            }
        }

        public class GetValues {
            public GetValuesSlots newValuesSlots() {
                return new GetValuesSlots();
            }

            public ByteBuffer encode(long thread, long frame, List<GetValuesSlots> slots) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(16, 1);
                JDWP.this.mThreadID.encode(thread, bytes);
                JDWP.this.mFrameID.encode(frame, bytes);
                JdwpInt.encode(slots.size(), bytes);
                for (int i = 0; i < slots.size(); ++i) {
                    GetValuesSlots getValuesSlots = slots.get(i);
                    JdwpInt.encode(getValuesSlots.slot, bytes);
                    JdwpByte.encode(getValuesSlots.sigbyte, bytes);
                }
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public GetValuesReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                GetValuesReplyData getValuesReplyData = new GetValuesReplyData();
                int valuesSize = JdwpInt.decode(bytes, start);
                start += JdwpInt.getSize();
                getValuesReplyData.values = new ArrayList<GetValuesReplyDataValues>(valuesSize);
                for (int i = 0; i < valuesSize; ++i) {
                    GetValuesReplyDataValues getValuesReplyDataValues = new GetValuesReplyDataValues();
                    getValuesReplyDataValues.slotValue = JDWP.this.mValue.decode(bytes, start);
                    start += JDWP.this.mValue.getSize(getValuesReplyDataValues.slotValue.tag);
                    getValuesReplyData.values.add(getValuesReplyDataValues);
                }
                return getValuesReplyData;
            }

            public class GetValuesReplyDataValues {
                public ValuePacket slotValue;
            }

            public class GetValuesReplyData {
                public List<GetValuesReplyDataValues> values;
            }

            public class GetValuesSlots {
                public int slot;
                public byte sigbyte;
            }
        }
    }

    public static interface EventRequestEncoder {
        public void encode(ByteBuffer var1);
    }

    public class EventRequest {
        private final Set cmdSet = new Set();
        private final Clear cmdClear = new Clear();
        private final ClearAllBreakpoints cmdClearAllBreakpoints = new ClearAllBreakpoints();

        public Set cmdSet() {
            return this.cmdSet;
        }

        public Clear cmdClear() {
            return this.cmdClear;
        }

        public ClearAllBreakpoints cmdClearAllBreakpoints() {
            return this.cmdClearAllBreakpoints;
        }

        private EventRequest() {
        }

        public class ClearAllBreakpoints {
            public ByteBuffer encode() {
                ByteBuffer bytes = JDWP.encodeCommandPacket(15, 3);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public boolean decode(byte[] bytes, int start) throws JdwpRuntimeException {
                return bytes.length == 11;
            }
        }

        public class Clear {
            public ByteBuffer encode(byte eventKind, int requestID) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(15, 2);
                JdwpByte.encode(eventKind, bytes);
                JdwpInt.encode(requestID, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public boolean decode(byte[] bytes, int start) throws JdwpRuntimeException {
                return bytes.length == 11;
            }
        }

        public class Set {
            public int decodeRequestID(byte[] bytes, int start) throws JdwpRuntimeException {
                return JDWP.decodeInt(bytes, start);
            }

            public ByteBuffer encode(byte eventKind, byte suspendPolicy, List<EventRequestEncoder> requestModifiers) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(15, 1);
                JdwpByte.encode(eventKind, bytes);
                JdwpByte.encode(suspendPolicy, bytes);
                JdwpInt.encode(requestModifiers.size(), bytes);
                for (EventRequestEncoder modifier : requestModifiers) {
                    modifier.encode(bytes);
                }
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public ByteBuffer newCountRequest(byte eventKind, byte suspendPolicy, int count) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(15, 1);
                JdwpByte.encode(eventKind, bytes);
                JdwpByte.encode(suspendPolicy, bytes);
                JdwpInt.encode(1, bytes);
                bytes.add((byte)1);
                JdwpInt.encode(count, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public ByteBuffer newConditionalRequest(byte eventKind, byte suspendPolicy, int exprID) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(15, 1);
                JdwpByte.encode(eventKind, bytes);
                JdwpByte.encode(suspendPolicy, bytes);
                JdwpInt.encode(1, bytes);
                bytes.add((byte)2);
                JdwpInt.encode(exprID, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public ByteBuffer newThreadOnlyRequest(byte eventKind, byte suspendPolicy, long thread) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(15, 1);
                JdwpByte.encode(eventKind, bytes);
                JdwpByte.encode(suspendPolicy, bytes);
                JdwpInt.encode(1, bytes);
                bytes.add((byte)3);
                JDWP.this.mThreadID.encode(thread, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public ByteBuffer newClassOnlyRequest(byte eventKind, byte suspendPolicy, long clazz) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(15, 1);
                JdwpByte.encode(eventKind, bytes);
                JdwpByte.encode(suspendPolicy, bytes);
                JdwpInt.encode(1, bytes);
                bytes.add((byte)4);
                JDWP.this.mReferenceTypeID.encode(clazz, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public ByteBuffer newClassMatchRequest(byte eventKind, byte suspendPolicy, String classPattern) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(15, 1);
                JdwpByte.encode(eventKind, bytes);
                JdwpByte.encode(suspendPolicy, bytes);
                JdwpInt.encode(1, bytes);
                bytes.add((byte)5);
                JdwpString.encode(classPattern, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public ByteBuffer newClassExcludeRequest(byte eventKind, byte suspendPolicy, String classPattern) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(15, 1);
                JdwpByte.encode(eventKind, bytes);
                JdwpByte.encode(suspendPolicy, bytes);
                JdwpInt.encode(1, bytes);
                bytes.add((byte)6);
                JdwpString.encode(classPattern, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public ByteBuffer newLocationOnlyRequest(byte eventKind, byte suspendPolicy, JdwpLocation.LocationPacket loc) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(15, 1);
                JdwpByte.encode(eventKind, bytes);
                JdwpByte.encode(suspendPolicy, bytes);
                JdwpInt.encode(1, bytes);
                bytes.add((byte)7);
                JDWP.this.mLocation.encode(loc, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public ByteBuffer newExceptionOnlyRequest(byte eventKind, byte suspendPolicy, long exceptionOrNull, boolean caught, boolean uncaught) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(15, 1);
                JdwpByte.encode(eventKind, bytes);
                JdwpByte.encode(suspendPolicy, bytes);
                JdwpInt.encode(1, bytes);
                bytes.add((byte)8);
                JDWP.this.mReferenceTypeID.encode(exceptionOrNull, bytes);
                JdwpBoolean.encode(caught, bytes);
                JdwpBoolean.encode(uncaught, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public ByteBuffer newFieldOnlyRequest(byte eventKind, byte suspendPolicy, long declaring, long fieldID) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(15, 1);
                JdwpByte.encode(eventKind, bytes);
                JdwpByte.encode(suspendPolicy, bytes);
                JdwpInt.encode(1, bytes);
                bytes.add((byte)9);
                JDWP.this.mReferenceTypeID.encode(declaring, bytes);
                JDWP.this.mFieldID.encode(fieldID, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public ByteBuffer newStepRequest(byte eventKind, byte suspendPolicy, long thread, int size, int depth) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(15, 1);
                JdwpByte.encode(eventKind, bytes);
                JdwpByte.encode(suspendPolicy, bytes);
                JdwpInt.encode(1, bytes);
                bytes.add((byte)10);
                JDWP.this.mThreadID.encode(thread, bytes);
                JdwpInt.encode(size, bytes);
                JdwpInt.encode(depth, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public ByteBuffer newInstanceOnlyRequest(byte eventKind, byte suspendPolicy, long instance) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(15, 1);
                JdwpByte.encode(eventKind, bytes);
                JdwpByte.encode(suspendPolicy, bytes);
                JdwpInt.encode(1, bytes);
                bytes.add((byte)11);
                JDWP.this.mObjectID.encode(instance, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public ByteBuffer newSourceNameMatchRequest(byte eventKind, byte suspendPolicy, String sourceNamePattern) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(15, 1);
                JdwpByte.encode(eventKind, bytes);
                JdwpByte.encode(suspendPolicy, bytes);
                JdwpInt.encode(1, bytes);
                bytes.add((byte)12);
                JdwpString.encode(sourceNamePattern, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public CountRequest newCountRequest() {
                return new CountRequest();
            }

            public ConditionalRequest newConditionalRequest() {
                return new ConditionalRequest();
            }

            public ThreadOnlyRequest newThreadOnlyRequest() {
                return new ThreadOnlyRequest();
            }

            public ClassOnlyRequest newClassOnlyRequest() {
                return new ClassOnlyRequest();
            }

            public ClassMatchRequest newClassMatchRequest() {
                return new ClassMatchRequest();
            }

            public ClassExcludeRequest newClassExcludeRequest() {
                return new ClassExcludeRequest();
            }

            public LocationOnlyRequest newLocationOnlyRequest() {
                return new LocationOnlyRequest();
            }

            public ExceptionOnlyRequest newExceptionOnlyRequest() {
                return new ExceptionOnlyRequest();
            }

            public FieldOnlyRequest newFieldOnlyRequest() {
                return new FieldOnlyRequest();
            }

            public StepRequest newStepRequest() {
                return new StepRequest();
            }

            public InstanceOnlyRequest newInstanceOnlyRequest() {
                return new InstanceOnlyRequest();
            }

            public SourceNameMatchRequest newSourceNameMatchRequest() {
                return new SourceNameMatchRequest();
            }

            public class SourceNameMatchRequest
            implements EventRequestEncoder {
                public static final byte MOD_KIND = 12;
                public String sourceNamePattern;

                @Override
                public void encode(ByteBuffer bytes) {
                    bytes.add((byte)12);
                    JdwpString.encode(this.sourceNamePattern, bytes);
                }
            }

            public class InstanceOnlyRequest
            implements EventRequestEncoder {
                public static final byte MOD_KIND = 11;
                public long instance;

                @Override
                public void encode(ByteBuffer bytes) {
                    bytes.add((byte)11);
                    JDWP.this.mObjectID.encode(this.instance, bytes);
                }
            }

            public class StepRequest
            implements EventRequestEncoder {
                public static final byte MOD_KIND = 10;
                public long thread;
                public int size;
                public int depth;

                @Override
                public void encode(ByteBuffer bytes) {
                    bytes.add((byte)10);
                    JDWP.this.mThreadID.encode(this.thread, bytes);
                    JdwpInt.encode(this.size, bytes);
                    JdwpInt.encode(this.depth, bytes);
                }
            }

            public class FieldOnlyRequest
            implements EventRequestEncoder {
                public static final byte MOD_KIND = 9;
                public long declaring;
                public long fieldID;

                @Override
                public void encode(ByteBuffer bytes) {
                    bytes.add((byte)9);
                    JDWP.this.mReferenceTypeID.encode(this.declaring, bytes);
                    JDWP.this.mFieldID.encode(this.fieldID, bytes);
                }
            }

            public class ExceptionOnlyRequest
            implements EventRequestEncoder {
                public static final byte MOD_KIND = 8;
                public long exceptionOrNull;
                public boolean caught;
                public boolean uncaught;

                @Override
                public void encode(ByteBuffer bytes) {
                    bytes.add((byte)8);
                    JDWP.this.mReferenceTypeID.encode(this.exceptionOrNull, bytes);
                    JdwpBoolean.encode(this.caught, bytes);
                    JdwpBoolean.encode(this.uncaught, bytes);
                }
            }

            public class LocationOnlyRequest
            implements EventRequestEncoder {
                public static final byte MOD_KIND = 7;
                public JdwpLocation.LocationPacket loc = new JdwpLocation.LocationPacket();

                @Override
                public void encode(ByteBuffer bytes) {
                    bytes.add((byte)7);
                    JDWP.this.mLocation.encode(this.loc, bytes);
                }
            }

            public class ClassExcludeRequest
            implements EventRequestEncoder {
                public static final byte MOD_KIND = 6;
                public String classPattern;

                @Override
                public void encode(ByteBuffer bytes) {
                    bytes.add((byte)6);
                    JdwpString.encode(this.classPattern, bytes);
                }
            }

            public class ClassMatchRequest
            implements EventRequestEncoder {
                public static final byte MOD_KIND = 5;
                public String classPattern;

                @Override
                public void encode(ByteBuffer bytes) {
                    bytes.add((byte)5);
                    JdwpString.encode(this.classPattern, bytes);
                }
            }

            public class ClassOnlyRequest
            implements EventRequestEncoder {
                public static final byte MOD_KIND = 4;
                public long clazz;

                @Override
                public void encode(ByteBuffer bytes) {
                    bytes.add((byte)4);
                    JDWP.this.mReferenceTypeID.encode(this.clazz, bytes);
                }
            }

            public class ThreadOnlyRequest
            implements EventRequestEncoder {
                public static final byte MOD_KIND = 3;
                public long thread;

                @Override
                public void encode(ByteBuffer bytes) {
                    bytes.add((byte)3);
                    JDWP.this.mThreadID.encode(this.thread, bytes);
                }
            }

            public class ConditionalRequest
            implements EventRequestEncoder {
                public static final byte MOD_KIND = 2;
                public int exprID;

                @Override
                public void encode(ByteBuffer bytes) {
                    bytes.add((byte)2);
                    JdwpInt.encode(this.exprID, bytes);
                }
            }

            public class CountRequest
            implements EventRequestEncoder {
                public static final byte MOD_KIND = 1;
                public int count;

                @Override
                public void encode(ByteBuffer bytes) {
                    bytes.add((byte)1);
                    JdwpInt.encode(this.count, bytes);
                }
            }
        }
    }

    public class ClassLoaderReference {
        private final VisibleClasses cmdVisibleClasses = new VisibleClasses();

        public VisibleClasses cmdVisibleClasses() {
            return this.cmdVisibleClasses;
        }

        private ClassLoaderReference() {
        }

        public class VisibleClasses {
            public ByteBuffer encode(long classLoaderObject) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(14, 1);
                JDWP.this.mClassLoaderID.encode(classLoaderObject, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public VisibleClassesReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                VisibleClassesReplyData visibleClassesReplyData = new VisibleClassesReplyData();
                int classesSize = JdwpInt.decode(bytes, start);
                start += JdwpInt.getSize();
                visibleClassesReplyData.classes = new ArrayList<VisibleClassesReplyDataClasses>(classesSize);
                for (int i = 0; i < classesSize; ++i) {
                    VisibleClassesReplyDataClasses visibleClassesReplyDataClasses = new VisibleClassesReplyDataClasses();
                    visibleClassesReplyDataClasses.refTypeTag = JdwpByte.decode(bytes, start);
                    visibleClassesReplyDataClasses.typeID = JDWP.this.mReferenceTypeID.decode(bytes, start += JdwpByte.getSize());
                    start += JDWP.this.mReferenceTypeID.getSize();
                    visibleClassesReplyData.classes.add(visibleClassesReplyDataClasses);
                }
                return visibleClassesReplyData;
            }

            public class VisibleClassesReplyDataClasses {
                public byte refTypeTag;
                public long typeID;
            }

            public class VisibleClassesReplyData {
                public List<VisibleClassesReplyDataClasses> classes;
            }
        }
    }

    public class ArrayReference {
        private final Length cmdLength = new Length();
        private final GetValues cmdGetValues = new GetValues();
        private final SetValues cmdSetValues = new SetValues();

        public Length cmdLength() {
            return this.cmdLength;
        }

        public GetValues cmdGetValues() {
            return this.cmdGetValues;
        }

        public SetValues cmdSetValues() {
            return this.cmdSetValues;
        }

        private ArrayReference() {
        }

        public class SetValues {
            public ByteBuffer encode(long arrayObject, int firstIndex, List<SetValuesValues> values) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(13, 3);
                JDWP.this.mArrayID.encode(arrayObject, bytes);
                JdwpInt.encode(firstIndex, bytes);
                JdwpInt.encode(values.size(), bytes);
                for (int i = 0; i < values.size(); ++i) {
                    SetValuesValues setValuesValues = values.get(i);
                    JDWP.this.mUntaggedvalue.encode(setValuesValues.value, bytes);
                }
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public boolean decode(byte[] bytes, int start) throws JdwpRuntimeException {
                return bytes.length == 11;
            }

            public class SetValuesValues {
                public UntaggedValuePacket value;
            }
        }

        public class GetValues {
            public ByteBuffer encode(long arrayObject, int firstIndex, int length) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(13, 2);
                JDWP.this.mArrayID.encode(arrayObject, bytes);
                JdwpInt.encode(firstIndex, bytes);
                JdwpInt.encode(length, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public GetValuesReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                GetValuesReplyData getValuesReplyData = new GetValuesReplyData();
                getValuesReplyData.values = JDWP.this.mArrayregion.decode(bytes, start);
                start += JDWP.this.mArrayregion.getSize(getValuesReplyData.values.arrayLen, getValuesReplyData.values.tag);
                return getValuesReplyData;
            }

            public class GetValuesReplyData {
                public JdwpArrayregion.ArrayRegionPacket values;
            }
        }

        public class Length {
            public ByteBuffer encode(long arrayObject) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(13, 1);
                JDWP.this.mArrayID.encode(arrayObject, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public LengthReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                LengthReplyData lengthReplyData = new LengthReplyData();
                lengthReplyData.arrayLength = JdwpInt.decode(bytes, start);
                start += JdwpInt.getSize();
                return lengthReplyData;
            }

            public class LengthReplyData {
                public int arrayLength;
            }
        }
    }

    public class ThreadGroupReference {
        private final Name cmdName = new Name();
        private final Parent cmdParent = new Parent();
        private final Children cmdChildren = new Children();

        public Name cmdName() {
            return this.cmdName;
        }

        public Parent cmdParent() {
            return this.cmdParent;
        }

        public Children cmdChildren() {
            return this.cmdChildren;
        }

        private ThreadGroupReference() {
        }

        public class Children {
            public ByteBuffer encode(long group) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(12, 3);
                JDWP.this.mThreadGroupID.encode(group, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public ChildrenReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                ChildrenReplyData childrenReplyData = new ChildrenReplyData();
                int childThreadsSize = JdwpInt.decode(bytes, start);
                start += JdwpInt.getSize();
                childrenReplyData.childThreads = new ArrayList<ChildrenReplyDataChildThreads>(childThreadsSize);
                for (int i = 0; i < childThreadsSize; ++i) {
                    ChildrenReplyDataChildThreads childrenReplyDataChildThreads = new ChildrenReplyDataChildThreads();
                    childrenReplyDataChildThreads.childThread = JDWP.this.mThreadID.decode(bytes, start);
                    int childGroupsSize = JdwpInt.decode(bytes, start += JDWP.this.mThreadID.getSize());
                    start += JdwpInt.getSize();
                    childrenReplyDataChildThreads.childGroups = new ArrayList<ChildrenReplyDataChildGroups>(childGroupsSize);
                    for (int ii = 0; ii < childGroupsSize; ++ii) {
                        ChildrenReplyDataChildGroups childrenReplyDataChildGroups = new ChildrenReplyDataChildGroups();
                        childrenReplyDataChildGroups.childGroup = JDWP.this.mThreadGroupID.decode(bytes, start);
                        start += JDWP.this.mThreadGroupID.getSize();
                        childrenReplyDataChildThreads.childGroups.add(childrenReplyDataChildGroups);
                    }
                    childrenReplyData.childThreads.add(childrenReplyDataChildThreads);
                }
                return childrenReplyData;
            }

            public class ChildrenReplyDataChildGroups {
                public long childGroup;
            }

            public class ChildrenReplyDataChildThreads {
                public long childThread;
                public List<ChildrenReplyDataChildGroups> childGroups;
            }

            public class ChildrenReplyData {
                public List<ChildrenReplyDataChildThreads> childThreads;
            }
        }

        public class Parent {
            public ByteBuffer encode(long group) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(12, 2);
                JDWP.this.mThreadGroupID.encode(group, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public ParentReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                ParentReplyData parentReplyData = new ParentReplyData();
                parentReplyData.parentGroup = JDWP.this.mThreadGroupID.decode(bytes, start);
                start += JDWP.this.mThreadGroupID.getSize();
                return parentReplyData;
            }

            public class ParentReplyData {
                public long parentGroup;
            }
        }

        public class Name {
            public ByteBuffer encode(long group) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(12, 1);
                JDWP.this.mThreadGroupID.encode(group, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public NameReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                NameReplyData nameReplyData = new NameReplyData();
                nameReplyData.groupName = JdwpString.decode(bytes, start);
                start += JdwpString.getSize(nameReplyData.groupName);
                return nameReplyData;
            }

            public class NameReplyData {
                public String groupName;
            }
        }
    }

    public class ThreadReference {
        private final Name cmdName = new Name();
        private final Suspend cmdSuspend = new Suspend();
        private final Resume cmdResume = new Resume();
        private final Status cmdStatus = new Status();
        private final ThreadGroup cmdThreadGroup = new ThreadGroup();
        private final Frames cmdFrames = new Frames();
        private final FrameCount cmdFrameCount = new FrameCount();
        private final OwnedMonitors cmdOwnedMonitors = new OwnedMonitors();
        private final CurrentContendedMonitor cmdCurrentContendedMonitor = new CurrentContendedMonitor();
        private final Stop cmdStop = new Stop();
        private final Interrupt cmdInterrupt = new Interrupt();
        private final SuspendCount cmdSuspendCount = new SuspendCount();
        private final OwnedMonitorsStackDepthInfo cmdOwnedMonitorsStackDepthInfo = new OwnedMonitorsStackDepthInfo();
        private final ForceEarlyReturn cmdForceEarlyReturn = new ForceEarlyReturn();

        public Name cmdName() {
            return this.cmdName;
        }

        public Suspend cmdSuspend() {
            return this.cmdSuspend;
        }

        public Resume cmdResume() {
            return this.cmdResume;
        }

        public Status cmdStatus() {
            return this.cmdStatus;
        }

        public ThreadGroup cmdThreadGroup() {
            return this.cmdThreadGroup;
        }

        public Frames cmdFrames() {
            return this.cmdFrames;
        }

        public FrameCount cmdFrameCount() {
            return this.cmdFrameCount;
        }

        public OwnedMonitors cmdOwnedMonitors() {
            return this.cmdOwnedMonitors;
        }

        public CurrentContendedMonitor cmdCurrentContendedMonitor() {
            return this.cmdCurrentContendedMonitor;
        }

        public Stop cmdStop() {
            return this.cmdStop;
        }

        public Interrupt cmdInterrupt() {
            return this.cmdInterrupt;
        }

        public SuspendCount cmdSuspendCount() {
            return this.cmdSuspendCount;
        }

        public OwnedMonitorsStackDepthInfo cmdOwnedMonitorsStackDepthInfo() {
            return this.cmdOwnedMonitorsStackDepthInfo;
        }

        public ForceEarlyReturn cmdForceEarlyReturn() {
            return this.cmdForceEarlyReturn;
        }

        private ThreadReference() {
        }

        public class ForceEarlyReturn {
            public ByteBuffer encode(long thread, ValuePacket value) throws JdwpRuntimeException {
                ByteBuffer bytes = JDWP.encodeCommandPacket(11, 14);
                JDWP.this.mThreadID.encode(thread, bytes);
                JDWP.this.mValue.encode(value, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public boolean decode(byte[] bytes, int start) throws JdwpRuntimeException {
                return bytes.length == 11;
            }
        }

        public class OwnedMonitorsStackDepthInfo {
            public ByteBuffer encode(long thread) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(11, 13);
                JDWP.this.mThreadID.encode(thread, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public OwnedMonitorsStackDepthInfoReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                OwnedMonitorsStackDepthInfoReplyData ownedMonitorsStackDepthInfoReplyData = new OwnedMonitorsStackDepthInfoReplyData();
                int ownedSize = JdwpInt.decode(bytes, start);
                start += JdwpInt.getSize();
                ownedMonitorsStackDepthInfoReplyData.owned = new ArrayList<OwnedMonitorsStackDepthInfoReplyDataOwned>(ownedSize);
                for (int i = 0; i < ownedSize; ++i) {
                    OwnedMonitorsStackDepthInfoReplyDataOwned ownedMonitorsStackDepthInfoReplyDataOwned = new OwnedMonitorsStackDepthInfoReplyDataOwned();
                    ownedMonitorsStackDepthInfoReplyDataOwned.monitor = JDWP.this.mTaggedobjectID.decode(bytes, start);
                    ownedMonitorsStackDepthInfoReplyDataOwned.stackDepth = JdwpInt.decode(bytes, start += JDWP.this.mTaggedobjectID.getSize());
                    start += JdwpInt.getSize();
                    ownedMonitorsStackDepthInfoReplyData.owned.add(ownedMonitorsStackDepthInfoReplyDataOwned);
                }
                return ownedMonitorsStackDepthInfoReplyData;
            }

            public class OwnedMonitorsStackDepthInfoReplyDataOwned {
                public JdwpTaggedobjectID.TaggedObjectIDPacket monitor;
                public int stackDepth;
            }

            public class OwnedMonitorsStackDepthInfoReplyData {
                public List<OwnedMonitorsStackDepthInfoReplyDataOwned> owned;
            }
        }

        public class SuspendCount {
            public ByteBuffer encode(long thread) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(11, 12);
                JDWP.this.mThreadID.encode(thread, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public SuspendCountReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                SuspendCountReplyData suspendCountReplyData = new SuspendCountReplyData();
                suspendCountReplyData.suspendCount = JdwpInt.decode(bytes, start);
                start += JdwpInt.getSize();
                return suspendCountReplyData;
            }

            public class SuspendCountReplyData {
                public int suspendCount;
            }
        }

        public class Interrupt {
            public ByteBuffer encode(long thread) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(11, 11);
                JDWP.this.mThreadID.encode(thread, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public boolean decode(byte[] bytes, int start) throws JdwpRuntimeException {
                return bytes.length == 11;
            }
        }

        public class Stop {
            public ByteBuffer encode(long thread, long throwable) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(11, 10);
                JDWP.this.mThreadID.encode(thread, bytes);
                JDWP.this.mObjectID.encode(throwable, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public boolean decode(byte[] bytes, int start) throws JdwpRuntimeException {
                return bytes.length == 11;
            }
        }

        public class CurrentContendedMonitor {
            public ByteBuffer encode(long thread) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(11, 9);
                JDWP.this.mThreadID.encode(thread, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public CurrentContendedMonitorReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                CurrentContendedMonitorReplyData currentContendedMonitorReplyData = new CurrentContendedMonitorReplyData();
                currentContendedMonitorReplyData.monitor = JDWP.this.mTaggedobjectID.decode(bytes, start);
                start += JDWP.this.mTaggedobjectID.getSize();
                return currentContendedMonitorReplyData;
            }

            public class CurrentContendedMonitorReplyData {
                public JdwpTaggedobjectID.TaggedObjectIDPacket monitor;
            }
        }

        public class OwnedMonitors {
            public ByteBuffer encode(long thread) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(11, 8);
                JDWP.this.mThreadID.encode(thread, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public OwnedMonitorsReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                OwnedMonitorsReplyData ownedMonitorsReplyData = new OwnedMonitorsReplyData();
                int ownedSize = JdwpInt.decode(bytes, start);
                start += JdwpInt.getSize();
                ownedMonitorsReplyData.owned = new ArrayList<OwnedMonitorsReplyDataOwned>(ownedSize);
                for (int i = 0; i < ownedSize; ++i) {
                    OwnedMonitorsReplyDataOwned ownedMonitorsReplyDataOwned = new OwnedMonitorsReplyDataOwned();
                    ownedMonitorsReplyDataOwned.monitor = JDWP.this.mTaggedobjectID.decode(bytes, start);
                    start += JDWP.this.mTaggedobjectID.getSize();
                    ownedMonitorsReplyData.owned.add(ownedMonitorsReplyDataOwned);
                }
                return ownedMonitorsReplyData;
            }

            public class OwnedMonitorsReplyDataOwned {
                public JdwpTaggedobjectID.TaggedObjectIDPacket monitor;
            }

            public class OwnedMonitorsReplyData {
                public List<OwnedMonitorsReplyDataOwned> owned;
            }
        }

        public class FrameCount {
            public ByteBuffer encode(long thread) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(11, 7);
                JDWP.this.mThreadID.encode(thread, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public FrameCountReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                FrameCountReplyData frameCountReplyData = new FrameCountReplyData();
                frameCountReplyData.frameCount = JdwpInt.decode(bytes, start);
                start += JdwpInt.getSize();
                return frameCountReplyData;
            }

            public class FrameCountReplyData {
                public int frameCount;
            }
        }

        public class Frames {
            public ByteBuffer encode(long thread, int startFrame, int length) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(11, 6);
                JDWP.this.mThreadID.encode(thread, bytes);
                JdwpInt.encode(startFrame, bytes);
                JdwpInt.encode(length, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public FramesReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                FramesReplyData framesReplyData = new FramesReplyData();
                int framesSize = JdwpInt.decode(bytes, start);
                start += JdwpInt.getSize();
                framesReplyData.frames = new ArrayList<FramesReplyDataFrames>(framesSize);
                for (int i = 0; i < framesSize; ++i) {
                    FramesReplyDataFrames framesReplyDataFrames = new FramesReplyDataFrames();
                    framesReplyDataFrames.frameID = JDWP.this.mFrameID.decode(bytes, start);
                    framesReplyDataFrames.location = JDWP.this.mLocation.decode(bytes, start += JDWP.this.mFrameID.getSize());
                    start += JDWP.this.mLocation.getSize();
                    framesReplyData.frames.add(framesReplyDataFrames);
                }
                return framesReplyData;
            }

            public class FramesReplyDataFrames {
                public long frameID;
                public JdwpLocation.LocationPacket location;
            }

            public class FramesReplyData {
                public List<FramesReplyDataFrames> frames;
            }
        }

        public class ThreadGroup {
            public ByteBuffer encode(long thread) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(11, 5);
                JDWP.this.mThreadID.encode(thread, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public ThreadGroupReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                ThreadGroupReplyData threadGroupReplyData = new ThreadGroupReplyData();
                threadGroupReplyData.group = JDWP.this.mThreadGroupID.decode(bytes, start);
                start += JDWP.this.mThreadGroupID.getSize();
                return threadGroupReplyData;
            }

            public class ThreadGroupReplyData {
                public long group;
            }
        }

        public class Status {
            public ByteBuffer encode(long thread) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(11, 4);
                JDWP.this.mThreadID.encode(thread, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public StatusReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                StatusReplyData statusReplyData = new StatusReplyData();
                statusReplyData.threadStatus = JdwpInt.decode(bytes, start);
                statusReplyData.suspendStatus = JdwpInt.decode(bytes, start += JdwpInt.getSize());
                start += JdwpInt.getSize();
                return statusReplyData;
            }

            public class StatusReplyData {
                public int threadStatus;
                public int suspendStatus;
            }
        }

        public class Resume {
            public ByteBuffer encode(long thread) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(11, 3);
                JDWP.this.mThreadID.encode(thread, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public boolean decode(byte[] bytes, int start) throws JdwpRuntimeException {
                return bytes.length == 11;
            }
        }

        public class Suspend {
            public ByteBuffer encode(long thread) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(11, 2);
                JDWP.this.mThreadID.encode(thread, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public boolean decode(byte[] bytes, int start) throws JdwpRuntimeException {
                return bytes.length == 11;
            }
        }

        public class Name {
            public ByteBuffer encode(long thread) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(11, 1);
                JDWP.this.mThreadID.encode(thread, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public NameReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                NameReplyData nameReplyData = new NameReplyData();
                nameReplyData.threadName = JdwpString.decode(bytes, start);
                start += JdwpString.getSize(nameReplyData.threadName);
                return nameReplyData;
            }

            public class NameReplyData {
                public String threadName;
            }
        }
    }

    public class StringReference {
        private final Value cmdValue = new Value();

        public Value cmdValue() {
            return this.cmdValue;
        }

        private StringReference() {
        }

        public class Value {
            public ByteBuffer encode(long stringObject) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(10, 1);
                JDWP.this.mObjectID.encode(stringObject, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public ValueReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                ValueReplyData valueReplyData = new ValueReplyData();
                valueReplyData.stringValue = JdwpString.decode(bytes, start);
                start += JdwpString.getSize(valueReplyData.stringValue);
                return valueReplyData;
            }

            public class ValueReplyData {
                public String stringValue;
            }
        }
    }

    public class ObjectReference {
        private final ReferenceType cmdReferenceType = new ReferenceType();
        private final GetValues cmdGetValues = new GetValues();
        private final SetValues cmdSetValues = new SetValues();
        private final MonitorInfo cmdMonitorInfo = new MonitorInfo();
        private final InvokeMethod cmdInvokeMethod = new InvokeMethod();
        private final DisableCollection cmdDisableCollection = new DisableCollection();
        private final EnableCollection cmdEnableCollection = new EnableCollection();
        private final IsCollected cmdIsCollected = new IsCollected();
        private final ReferringObjects cmdReferringObjects = new ReferringObjects();

        public ReferenceType cmdReferenceType() {
            return this.cmdReferenceType;
        }

        public GetValues cmdGetValues() {
            return this.cmdGetValues;
        }

        public SetValues cmdSetValues() {
            return this.cmdSetValues;
        }

        public MonitorInfo cmdMonitorInfo() {
            return this.cmdMonitorInfo;
        }

        public InvokeMethod cmdInvokeMethod() {
            return this.cmdInvokeMethod;
        }

        public DisableCollection cmdDisableCollection() {
            return this.cmdDisableCollection;
        }

        public EnableCollection cmdEnableCollection() {
            return this.cmdEnableCollection;
        }

        public IsCollected cmdIsCollected() {
            return this.cmdIsCollected;
        }

        public ReferringObjects cmdReferringObjects() {
            return this.cmdReferringObjects;
        }

        private ObjectReference() {
        }

        public class ReferringObjects {
            public ByteBuffer encode(long object, int maxReferrers) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(9, 10);
                JDWP.this.mObjectID.encode(object, bytes);
                JdwpInt.encode(maxReferrers, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public ReferringObjectsReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                ReferringObjectsReplyData referringObjectsReplyData = new ReferringObjectsReplyData();
                int referringObjectsSize = JdwpInt.decode(bytes, start);
                start += JdwpInt.getSize();
                referringObjectsReplyData.referringObjects = new ArrayList<ReferringObjectsReplyDataReferringObjects>(referringObjectsSize);
                for (int i = 0; i < referringObjectsSize; ++i) {
                    ReferringObjectsReplyDataReferringObjects referringObjectsReplyDataReferringObjects = new ReferringObjectsReplyDataReferringObjects();
                    referringObjectsReplyDataReferringObjects.instance = JDWP.this.mTaggedobjectID.decode(bytes, start);
                    start += JDWP.this.mTaggedobjectID.getSize();
                    referringObjectsReplyData.referringObjects.add(referringObjectsReplyDataReferringObjects);
                }
                return referringObjectsReplyData;
            }

            public class ReferringObjectsReplyDataReferringObjects {
                public JdwpTaggedobjectID.TaggedObjectIDPacket instance;
            }

            public class ReferringObjectsReplyData {
                public List<ReferringObjectsReplyDataReferringObjects> referringObjects;
            }
        }

        public class IsCollected {
            public ByteBuffer encode(long object) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(9, 9);
                JDWP.this.mObjectID.encode(object, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public IsCollectedReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                IsCollectedReplyData isCollectedReplyData = new IsCollectedReplyData();
                isCollectedReplyData.isCollected = JdwpBoolean.decode(bytes, start);
                start += JdwpBoolean.getSize();
                return isCollectedReplyData;
            }

            public class IsCollectedReplyData {
                public boolean isCollected;
            }
        }

        public class EnableCollection {
            public ByteBuffer encode(long object) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(9, 8);
                JDWP.this.mObjectID.encode(object, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public boolean decode(byte[] bytes, int start) throws JdwpRuntimeException {
                return bytes.length == 11;
            }
        }

        public class DisableCollection {
            public ByteBuffer encode(long object) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(9, 7);
                JDWP.this.mObjectID.encode(object, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public boolean decode(byte[] bytes, int start) throws JdwpRuntimeException {
                return bytes.length == 11;
            }
        }

        public class InvokeMethod {
            public ByteBuffer encode(long object, long thread, long clazz, long methodID, List<InvokeMethodArguments> arguments, int options) throws JdwpRuntimeException {
                ByteBuffer bytes = JDWP.encodeCommandPacket(9, 6);
                JDWP.this.mObjectID.encode(object, bytes);
                JDWP.this.mThreadID.encode(thread, bytes);
                JDWP.this.mClassID.encode(clazz, bytes);
                JDWP.this.mMethodID.encode(methodID, bytes);
                JdwpInt.encode(arguments.size(), bytes);
                for (int i = 0; i < arguments.size(); ++i) {
                    InvokeMethodArguments invokeMethodArguments = arguments.get(i);
                    JDWP.this.mValue.encode(invokeMethodArguments.arg, bytes);
                }
                JdwpInt.encode(options, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public InvokeMethodReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                InvokeMethodReplyData invokeMethodReplyData = new InvokeMethodReplyData();
                invokeMethodReplyData.returnValue = JDWP.this.mValue.decode(bytes, start);
                invokeMethodReplyData.exception = JDWP.this.mTaggedobjectID.decode(bytes, start += JDWP.this.mValue.getSize(invokeMethodReplyData.returnValue.tag));
                start += JDWP.this.mTaggedobjectID.getSize();
                return invokeMethodReplyData;
            }

            public class InvokeMethodReplyData {
                public ValuePacket returnValue;
                public JdwpTaggedobjectID.TaggedObjectIDPacket exception;
            }

            public class InvokeMethodArguments {
                public ValuePacket arg;
            }
        }

        public class MonitorInfo {
            public ByteBuffer encode(long object) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(9, 5);
                JDWP.this.mObjectID.encode(object, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public MonitorInfoReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                MonitorInfoReplyData monitorInfoReplyData = new MonitorInfoReplyData();
                monitorInfoReplyData.owner = JDWP.this.mThreadID.decode(bytes, start);
                monitorInfoReplyData.entryCount = JdwpInt.decode(bytes, start += JDWP.this.mThreadID.getSize());
                int waitersSize = JdwpInt.decode(bytes, start += JdwpInt.getSize());
                start += JdwpInt.getSize();
                monitorInfoReplyData.waiters = new ArrayList<MonitorInfoReplyDataWaiters>(waitersSize);
                for (int i = 0; i < waitersSize; ++i) {
                    MonitorInfoReplyDataWaiters monitorInfoReplyDataWaiters = new MonitorInfoReplyDataWaiters();
                    monitorInfoReplyDataWaiters.thread = JDWP.this.mThreadID.decode(bytes, start);
                    start += JDWP.this.mThreadID.getSize();
                    monitorInfoReplyData.waiters.add(monitorInfoReplyDataWaiters);
                }
                return monitorInfoReplyData;
            }

            public class MonitorInfoReplyDataWaiters {
                public long thread;
            }

            public class MonitorInfoReplyData {
                public long owner;
                public int entryCount;
                public List<MonitorInfoReplyDataWaiters> waiters;
            }
        }

        public class SetValues {
            public ByteBuffer encode(long object, List<FieldValueSetter> values) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(9, 3);
                JDWP.this.mObjectID.encode(object, bytes);
                JdwpInt.encode(values.size(), bytes);
                for (int i = 0; i < values.size(); ++i) {
                    FieldValueSetter setValuesValues = values.get(i);
                    JDWP.this.mFieldID.encode(setValuesValues.fieldID, bytes);
                    JDWP.this.mUntaggedvalue.encode(setValuesValues.value, bytes);
                }
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public boolean decode(byte[] bytes, int start) throws JdwpRuntimeException {
                return bytes.length == 11;
            }

            public class FieldValueSetter {
                public long fieldID;
                public UntaggedValuePacket value;
            }
        }

        public class GetValues {
            public ByteBuffer encode(long object, List<Long> fields) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(9, 2);
                JDWP.this.mObjectID.encode(object, bytes);
                JdwpInt.encode(fields.size(), bytes);
                for (int i = 0; i < fields.size(); ++i) {
                    Long id = fields.get(i);
                    JDWP.this.mFieldID.encode(id, bytes);
                }
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public GetValuesReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                GetValuesReplyData getValuesReplyData = new GetValuesReplyData();
                int valuesSize = JdwpInt.decode(bytes, start);
                start += JdwpInt.getSize();
                getValuesReplyData.values = new ArrayList<GetValuesReplyDataValues>(valuesSize);
                for (int i = 0; i < valuesSize; ++i) {
                    GetValuesReplyDataValues getValuesReplyDataValues = new GetValuesReplyDataValues();
                    getValuesReplyDataValues.value = JDWP.this.mValue.decode(bytes, start);
                    start += JDWP.this.mValue.getSize(getValuesReplyDataValues.value.tag);
                    getValuesReplyData.values.add(getValuesReplyDataValues);
                }
                return getValuesReplyData;
            }

            public class GetValuesReplyDataValues {
                public ValuePacket value;
            }

            public class GetValuesReplyData {
                public List<GetValuesReplyDataValues> values;
            }

            public class GetValuesFields {
                public long fieldID;
            }
        }

        public class ReferenceType {
            public ByteBuffer encode(long object) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(9, 1);
                JDWP.this.mObjectID.encode(object, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public ReferenceTypeReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                ReferenceTypeReplyData referenceTypeReplyData = new ReferenceTypeReplyData();
                referenceTypeReplyData.refTypeTag = JdwpByte.decode(bytes, start);
                referenceTypeReplyData.typeID = JDWP.this.mReferenceTypeID.decode(bytes, start += JdwpByte.getSize());
                start += JDWP.this.mReferenceTypeID.getSize();
                return referenceTypeReplyData;
            }

            public class ReferenceTypeReplyData {
                public byte refTypeTag;
                public long typeID;
            }
        }
    }

    public class Field {
        private Field() {
        }
    }

    public class Method {
        public final LineTable cmdLineTable = new LineTable();
        public final VariableTable cmdVariableTable = new VariableTable();
        public final Bytecodes cmdBytecodes = new Bytecodes();
        public final IsObsolete cmdIsObsolete = new IsObsolete();
        public final VariableTableWithGeneric cmdVariableTableWithGeneric = new VariableTableWithGeneric();

        public LineTable cmdLineTable() {
            return this.cmdLineTable;
        }

        public VariableTable cmdVariableTable() {
            return this.cmdVariableTable;
        }

        public Bytecodes cmdBytecodes() {
            return this.cmdBytecodes;
        }

        public IsObsolete cmdIsObsolete() {
            return this.cmdIsObsolete;
        }

        public VariableTableWithGeneric cmdVariableTableWithGeneric() {
            return this.cmdVariableTableWithGeneric;
        }

        private Method() {
        }

        public class VariableTableWithGeneric {
            public ByteBuffer encode(long refType, long methodID) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(6, 5);
                JDWP.this.mReferenceTypeID.encode(refType, bytes);
                JDWP.this.mMethodID.encode(methodID, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public VarTableWithGenericData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                VarTableWithGenericData variableTableWithGenericReplyData = new VarTableWithGenericData();
                variableTableWithGenericReplyData.argCnt = JdwpInt.decode(bytes, start);
                int slotsSize = JdwpInt.decode(bytes, start += JdwpInt.getSize());
                start += JdwpInt.getSize();
                variableTableWithGenericReplyData.slots = new ArrayList<VarWithGenericSlot>(slotsSize);
                for (int i = 0; i < slotsSize; ++i) {
                    VarWithGenericSlot variableTableWithGenericReplyDataSlots = new VarWithGenericSlot();
                    variableTableWithGenericReplyDataSlots.codeIndex = JdwpLong.decode(bytes, start);
                    variableTableWithGenericReplyDataSlots.name = JdwpString.decode(bytes, start += JdwpLong.getSize());
                    variableTableWithGenericReplyDataSlots.signature = JdwpString.decode(bytes, start += JdwpString.getSize(variableTableWithGenericReplyDataSlots.name));
                    variableTableWithGenericReplyDataSlots.genericSignature = JdwpString.decode(bytes, start += JdwpString.getSize(variableTableWithGenericReplyDataSlots.signature));
                    variableTableWithGenericReplyDataSlots.length = JdwpInt.decode(bytes, start += JdwpString.getSize(variableTableWithGenericReplyDataSlots.genericSignature));
                    variableTableWithGenericReplyDataSlots.slot = JdwpInt.decode(bytes, start += JdwpInt.getSize());
                    start += JdwpInt.getSize();
                    variableTableWithGenericReplyData.slots.add(variableTableWithGenericReplyDataSlots);
                }
                return variableTableWithGenericReplyData;
            }

            public class VarWithGenericSlot {
                public long codeIndex;
                public String name;
                public String signature;
                public String genericSignature;
                public int length;
                public int slot;
            }

            public class VarTableWithGenericData {
                public int argCnt;
                public List<VarWithGenericSlot> slots;
            }
        }

        public class IsObsolete {
            public ByteBuffer encode(long refType, long methodID) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(6, 4);
                JDWP.this.mReferenceTypeID.encode(refType, bytes);
                JDWP.this.mMethodID.encode(methodID, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public IsObsoleteReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                IsObsoleteReplyData isObsoleteReplyData = new IsObsoleteReplyData();
                isObsoleteReplyData.isObsolete = JdwpBoolean.decode(bytes, start);
                start += JdwpBoolean.getSize();
                return isObsoleteReplyData;
            }

            public class IsObsoleteReplyData {
                public boolean isObsolete;
            }
        }

        public class Bytecodes {
            public ByteBuffer encode(long refType, long methodID) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(6, 3);
                JDWP.this.mReferenceTypeID.encode(refType, bytes);
                JDWP.this.mMethodID.encode(methodID, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public BytecodesReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                BytecodesReplyData bytecodesReplyData = new BytecodesReplyData();
                int bytesSize = JdwpInt.decode(bytes, start);
                start += JdwpInt.getSize();
                bytecodesReplyData.bytes = new ArrayList<BytecodesReplyDataBytes>(bytesSize);
                for (int i = 0; i < bytesSize; ++i) {
                    BytecodesReplyDataBytes bytecodesReplyDataBytes = new BytecodesReplyDataBytes();
                    bytecodesReplyDataBytes.bytecode = JdwpByte.decode(bytes, start);
                    start += JdwpByte.getSize();
                    bytecodesReplyData.bytes.add(bytecodesReplyDataBytes);
                }
                return bytecodesReplyData;
            }

            public class BytecodesReplyDataBytes {
                public byte bytecode;
            }

            public class BytecodesReplyData {
                public List<BytecodesReplyDataBytes> bytes;
            }
        }

        public class VariableTable {
            public ByteBuffer encode(long refType, long methodID) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(6, 2);
                JDWP.this.mReferenceTypeID.encode(refType, bytes);
                JDWP.this.mMethodID.encode(methodID, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public VariableTableReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                VariableTableReplyData variableTableReplyData = new VariableTableReplyData();
                variableTableReplyData.argCnt = JdwpInt.decode(bytes, start);
                int slotsSize = JdwpInt.decode(bytes, start += JdwpInt.getSize());
                start += JdwpInt.getSize();
                variableTableReplyData.slots = new ArrayList<VariableTableReplyDataSlots>(slotsSize);
                for (int i = 0; i < slotsSize; ++i) {
                    VariableTableReplyDataSlots variableTableReplyDataSlots = new VariableTableReplyDataSlots();
                    variableTableReplyDataSlots.codeIndex = JdwpLong.decode(bytes, start);
                    variableTableReplyDataSlots.name = JdwpString.decode(bytes, start += JdwpLong.getSize());
                    variableTableReplyDataSlots.signature = JdwpString.decode(bytes, start += JdwpString.getSize(variableTableReplyDataSlots.name));
                    variableTableReplyDataSlots.length = JdwpInt.decode(bytes, start += JdwpString.getSize(variableTableReplyDataSlots.signature));
                    variableTableReplyDataSlots.slot = JdwpInt.decode(bytes, start += JdwpInt.getSize());
                    start += JdwpInt.getSize();
                    variableTableReplyData.slots.add(variableTableReplyDataSlots);
                }
                return variableTableReplyData;
            }

            public class VariableTableReplyDataSlots {
                public long codeIndex;
                public String name;
                public String signature;
                public int length;
                public int slot;
            }

            public class VariableTableReplyData {
                public int argCnt;
                public List<VariableTableReplyDataSlots> slots;
            }
        }

        public class LineTable {
            public ByteBuffer encode(long refType, long methodID) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(6, 1);
                JDWP.this.mReferenceTypeID.encode(refType, bytes);
                JDWP.this.mMethodID.encode(methodID, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public LineTableReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                LineTableReplyData lineTableReplyData = new LineTableReplyData();
                lineTableReplyData.start = JdwpLong.decode(bytes, start);
                lineTableReplyData.end = JdwpLong.decode(bytes, start += JdwpLong.getSize());
                int linesSize = JdwpInt.decode(bytes, start += JdwpLong.getSize());
                start += JdwpInt.getSize();
                lineTableReplyData.lines = new ArrayList<LineTableReplyDataLines>(linesSize);
                for (int i = 0; i < linesSize; ++i) {
                    LineTableReplyDataLines lineTableReplyDataLines = new LineTableReplyDataLines();
                    lineTableReplyDataLines.lineCodeIndex = JdwpLong.decode(bytes, start);
                    lineTableReplyDataLines.lineNumber = JdwpInt.decode(bytes, start += JdwpLong.getSize());
                    start += JdwpInt.getSize();
                    lineTableReplyData.lines.add(lineTableReplyDataLines);
                }
                return lineTableReplyData;
            }

            public class LineTableReplyDataLines {
                public long lineCodeIndex;
                public int lineNumber;
            }

            public class LineTableReplyData {
                public long start;
                public long end;
                public List<LineTableReplyDataLines> lines;
            }
        }
    }

    public class InterfaceType {
        private InterfaceType() {
        }
    }

    public class ArrayType {
        private final NewInstance cmdNewInstance = new NewInstance();

        public NewInstance cmdNewInstance() {
            return this.cmdNewInstance;
        }

        private ArrayType() {
        }

        public class NewInstance {
            public ByteBuffer encode(long arrType, int length) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(4, 1);
                JDWP.this.mArrayTypeID.encode(arrType, bytes);
                JdwpInt.encode(length, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public NewInstanceReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                NewInstanceReplyData newInstanceReplyData = new NewInstanceReplyData();
                newInstanceReplyData.newArray = JDWP.this.mTaggedobjectID.decode(bytes, start);
                start += JDWP.this.mTaggedobjectID.getSize();
                return newInstanceReplyData;
            }

            public class NewInstanceReplyData {
                public JdwpTaggedobjectID.TaggedObjectIDPacket newArray;
            }
        }
    }

    public class ClassType {
        private final Superclass cmdSuperclass = new Superclass();
        private final SetValues cmdSetValues = new SetValues();
        private final InvokeMethod cmdInvokeMethod = new InvokeMethod();
        private final NewInstance cmdNewInstance = new NewInstance();

        public Superclass cmdSuperclass() {
            return this.cmdSuperclass;
        }

        public SetValues cmdSetValues() {
            return this.cmdSetValues;
        }

        public InvokeMethod cmdInvokeMethod() {
            return this.cmdInvokeMethod;
        }

        public NewInstance cmdNewInstance() {
            return this.cmdNewInstance;
        }

        private ClassType() {
        }

        public class NewInstance {
            public ByteBuffer encode(long clazz, long thread, long methodID, List<NewInstanceArguments> arguments, int options) throws JdwpRuntimeException {
                ByteBuffer bytes = JDWP.encodeCommandPacket(3, 4);
                JDWP.this.mClassID.encode(clazz, bytes);
                JDWP.this.mThreadID.encode(thread, bytes);
                JDWP.this.mMethodID.encode(methodID, bytes);
                JdwpInt.encode(arguments.size(), bytes);
                for (int i = 0; i < arguments.size(); ++i) {
                    NewInstanceArguments newInstanceArguments = arguments.get(i);
                    JDWP.this.mValue.encode(newInstanceArguments.arg, bytes);
                }
                JdwpInt.encode(options, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public NewInstanceReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                NewInstanceReplyData newInstanceReplyData = new NewInstanceReplyData();
                newInstanceReplyData.newObject = JDWP.this.mTaggedobjectID.decode(bytes, start);
                newInstanceReplyData.exception = JDWP.this.mTaggedobjectID.decode(bytes, start += JDWP.this.mTaggedobjectID.getSize());
                start += JDWP.this.mTaggedobjectID.getSize();
                return newInstanceReplyData;
            }

            public class NewInstanceReplyData {
                public JdwpTaggedobjectID.TaggedObjectIDPacket newObject;
                public JdwpTaggedobjectID.TaggedObjectIDPacket exception;
            }

            public class NewInstanceArguments {
                public ValuePacket arg;
            }
        }

        public class InvokeMethod {
            public ByteBuffer encode(long clazz, long thread, long methodID, List<InvokeMethodArguments> arguments, int options) throws JdwpRuntimeException {
                ByteBuffer bytes = JDWP.encodeCommandPacket(3, 3);
                JDWP.this.mClassID.encode(clazz, bytes);
                JDWP.this.mThreadID.encode(thread, bytes);
                JDWP.this.mMethodID.encode(methodID, bytes);
                JdwpInt.encode(arguments.size(), bytes);
                for (int i = 0; i < arguments.size(); ++i) {
                    InvokeMethodArguments invokeMethodArguments = arguments.get(i);
                    JDWP.this.mValue.encode(invokeMethodArguments.arg, bytes);
                }
                JdwpInt.encode(options, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public InvokeMethodReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                InvokeMethodReplyData invokeMethodReplyData = new InvokeMethodReplyData();
                invokeMethodReplyData.returnValue = JDWP.this.mValue.decode(bytes, start);
                invokeMethodReplyData.exception = JDWP.this.mTaggedobjectID.decode(bytes, start += JDWP.this.mValue.getSize(invokeMethodReplyData.returnValue.tag));
                start += JDWP.this.mTaggedobjectID.getSize();
                return invokeMethodReplyData;
            }

            public class InvokeMethodReplyData {
                public ValuePacket returnValue;
                public JdwpTaggedobjectID.TaggedObjectIDPacket exception;
            }

            public class InvokeMethodArguments {
                public ValuePacket arg;
            }
        }

        public class SetValues {
            public ByteBuffer encode(long clazz, List<SetValuesValues> values) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(3, 2);
                JDWP.this.mClassID.encode(clazz, bytes);
                JdwpInt.encode(values.size(), bytes);
                for (int i = 0; i < values.size(); ++i) {
                    SetValuesValues setValuesValues = values.get(i);
                    JDWP.this.mFieldID.encode(setValuesValues.fieldID, bytes);
                    JDWP.this.mUntaggedvalue.encode(setValuesValues.value, bytes);
                }
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public boolean decode(byte[] bytes, int start) throws JdwpRuntimeException {
                return bytes.length == 11;
            }

            public class SetValuesValues {
                public long fieldID;
                public UntaggedValuePacket value;
            }
        }

        public class Superclass {
            public ByteBuffer encode(long clazz) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(3, 1);
                JDWP.this.mClassID.encode(clazz, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public SuperclassReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                SuperclassReplyData superclassReplyData = new SuperclassReplyData();
                superclassReplyData.superclass = JDWP.this.mClassID.decode(bytes, start);
                start += JDWP.this.mClassID.getSize();
                return superclassReplyData;
            }

            public class SuperclassReplyData {
                public long superclass;
            }
        }
    }

    public class ReferenceType {
        private final Signature cmdSignature = new Signature();
        private final ClassLoader cmdClassLoader = new ClassLoader();
        private final Modifiers cmdModifiers = new Modifiers();
        private final Fields cmdFields = new Fields();
        private final Methods cmdMethods = new Methods();
        private final GetValues cmdGetValues = new GetValues();
        private final SourceFile cmdSourceFile = new SourceFile();
        private final NestedTypes cmdNestedTypes = new NestedTypes();
        private final Status cmdStatus = new Status();
        private final Interfaces cmdInterfaces = new Interfaces();
        private final ClassObject cmdClassObject = new ClassObject();
        private final SourceDebugExtension cmdSourceDebugExtension = new SourceDebugExtension();
        private final SignatureWithGeneric cmdSignatureWithGeneric = new SignatureWithGeneric();
        private final FieldsWithGeneric cmdFieldsWithGeneric = new FieldsWithGeneric();
        private final MethodsWithGeneric cmdMethodsWithGeneric = new MethodsWithGeneric();
        private final Instances cmdInstances = new Instances();
        private final ClassFileVersion cmdClassFileVersion = new ClassFileVersion();
        private final ConstantPool cmdConstantPool = new ConstantPool();

        public Signature cmdSignature() {
            return this.cmdSignature;
        }

        public ClassLoader cmdClassLoader() {
            return this.cmdClassLoader;
        }

        public Modifiers cmdModifiers() {
            return this.cmdModifiers;
        }

        public Fields cmdFields() {
            return this.cmdFields;
        }

        public Methods cmdMethods() {
            return this.cmdMethods;
        }

        public GetValues cmdGetValues() {
            return this.cmdGetValues;
        }

        public SourceFile cmdSourceFile() {
            return this.cmdSourceFile;
        }

        public NestedTypes cmdNestedTypes() {
            return this.cmdNestedTypes;
        }

        public Status cmdStatus() {
            return this.cmdStatus;
        }

        public Interfaces cmdInterfaces() {
            return this.cmdInterfaces;
        }

        public ClassObject cmdClassObject() {
            return this.cmdClassObject;
        }

        public SourceDebugExtension cmdSourceDebugExtension() {
            return this.cmdSourceDebugExtension;
        }

        public SignatureWithGeneric cmdSignatureWithGeneric() {
            return this.cmdSignatureWithGeneric;
        }

        public FieldsWithGeneric cmdFieldsWithGeneric() {
            return this.cmdFieldsWithGeneric;
        }

        public MethodsWithGeneric cmdMethodsWithGeneric() {
            return this.cmdMethodsWithGeneric;
        }

        public Instances cmdInstances() {
            return this.cmdInstances;
        }

        public ClassFileVersion cmdClassFileVersion() {
            return this.cmdClassFileVersion;
        }

        public ConstantPool cmdConstantPool() {
            return this.cmdConstantPool;
        }

        private ReferenceType() {
        }

        public class ConstantPool {
            public ByteBuffer encode(long refType) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(2, 18);
                JDWP.this.mReferenceTypeID.encode(refType, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public ConstantPoolReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                ConstantPoolReplyData constantPoolReplyData = new ConstantPoolReplyData();
                constantPoolReplyData.count = JdwpInt.decode(bytes, start);
                int bytesSize = JdwpInt.decode(bytes, start += JdwpInt.getSize());
                start += JdwpInt.getSize();
                constantPoolReplyData.bytes = new ArrayList<ConstantPoolReplyDataBytes>(bytesSize);
                for (int i = 0; i < bytesSize; ++i) {
                    ConstantPoolReplyDataBytes constantPoolReplyDataBytes = new ConstantPoolReplyDataBytes();
                    constantPoolReplyDataBytes.cpbytes = JdwpByte.decode(bytes, start);
                    start += JdwpByte.getSize();
                    constantPoolReplyData.bytes.add(constantPoolReplyDataBytes);
                }
                return constantPoolReplyData;
            }

            public class ConstantPoolReplyDataBytes {
                public byte cpbytes;
            }

            public class ConstantPoolReplyData {
                public int count;
                public List<ConstantPoolReplyDataBytes> bytes;
            }
        }

        public class ClassFileVersion {
            public ByteBuffer encode(long refType) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(2, 17);
                JDWP.this.mReferenceTypeID.encode(refType, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public ClassFileVersionReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                ClassFileVersionReplyData classFileVersionReplyData = new ClassFileVersionReplyData();
                classFileVersionReplyData.majorVersion = JdwpInt.decode(bytes, start);
                classFileVersionReplyData.minorVersion = JdwpInt.decode(bytes, start += JdwpInt.getSize());
                start += JdwpInt.getSize();
                return classFileVersionReplyData;
            }

            public class ClassFileVersionReplyData {
                public int majorVersion;
                public int minorVersion;
            }
        }

        public class Instances {
            public ByteBuffer encode(long refType, int maxInstances) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(2, 16);
                JDWP.this.mReferenceTypeID.encode(refType, bytes);
                JdwpInt.encode(maxInstances, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public InstancesReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                InstancesReplyData instancesReplyData = new InstancesReplyData();
                int instancesSize = JdwpInt.decode(bytes, start);
                start += JdwpInt.getSize();
                instancesReplyData.instances = new ArrayList<InstancesReplyDataInstances>(instancesSize);
                for (int i = 0; i < instancesSize; ++i) {
                    InstancesReplyDataInstances instancesReplyDataInstances = new InstancesReplyDataInstances();
                    instancesReplyDataInstances.instance = JDWP.this.mTaggedobjectID.decode(bytes, start);
                    start += JDWP.this.mTaggedobjectID.getSize();
                    instancesReplyData.instances.add(instancesReplyDataInstances);
                }
                return instancesReplyData;
            }

            public class InstancesReplyDataInstances {
                public JdwpTaggedobjectID.TaggedObjectIDPacket instance;
            }

            public class InstancesReplyData {
                public List<InstancesReplyDataInstances> instances;
            }
        }

        public class MethodsWithGeneric {
            public ByteBuffer encode(long refType) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(2, 15);
                JDWP.this.mReferenceTypeID.encode(refType, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public MethodsWithGenericReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                MethodsWithGenericReplyData methodsWithGenericReplyData = new MethodsWithGenericReplyData();
                int declaredSize = JdwpInt.decode(bytes, start);
                start += JdwpInt.getSize();
                methodsWithGenericReplyData.declared = new ArrayList<MethodsWithGenericData>(declaredSize);
                for (int i = 0; i < declaredSize; ++i) {
                    MethodsWithGenericData methodsWithGenericReplyDataDeclared = new MethodsWithGenericData();
                    methodsWithGenericReplyDataDeclared.methodID = JDWP.this.mMethodID.decode(bytes, start);
                    methodsWithGenericReplyDataDeclared.name = JdwpString.decode(bytes, start += JDWP.this.mMethodID.getSize());
                    methodsWithGenericReplyDataDeclared.signature = JdwpString.decode(bytes, start += JdwpString.getSize(methodsWithGenericReplyDataDeclared.name));
                    methodsWithGenericReplyDataDeclared.genericSignature = JdwpString.decode(bytes, start += JdwpString.getSize(methodsWithGenericReplyDataDeclared.signature));
                    methodsWithGenericReplyDataDeclared.modBits = JdwpInt.decode(bytes, start += JdwpString.getSize(methodsWithGenericReplyDataDeclared.genericSignature));
                    start += JdwpInt.getSize();
                    methodsWithGenericReplyData.declared.add(methodsWithGenericReplyDataDeclared);
                }
                return methodsWithGenericReplyData;
            }

            public class MethodsWithGenericData {
                public long methodID;
                public String name;
                public String signature;
                public String genericSignature;
                public int modBits;
            }

            public class MethodsWithGenericReplyData {
                public List<MethodsWithGenericData> declared;
            }
        }

        public class FieldsWithGeneric {
            public ByteBuffer encode(long refType) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(2, 14);
                JDWP.this.mReferenceTypeID.encode(refType, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public FieldsWithGenericReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                FieldsWithGenericReplyData fieldsWithGenericReplyData = new FieldsWithGenericReplyData();
                int declaredSize = JdwpInt.decode(bytes, start);
                start += JdwpInt.getSize();
                fieldsWithGenericReplyData.declared = new ArrayList<FieldsWithGenericData>(declaredSize);
                for (int i = 0; i < declaredSize; ++i) {
                    FieldsWithGenericData fieldsWithGenericReplyDataDeclared = new FieldsWithGenericData();
                    fieldsWithGenericReplyDataDeclared.fieldID = JDWP.this.mFieldID.decode(bytes, start);
                    fieldsWithGenericReplyDataDeclared.name = JdwpString.decode(bytes, start += JDWP.this.mFieldID.getSize());
                    fieldsWithGenericReplyDataDeclared.signature = JdwpString.decode(bytes, start += JdwpString.getSize(fieldsWithGenericReplyDataDeclared.name));
                    fieldsWithGenericReplyDataDeclared.genericSignature = JdwpString.decode(bytes, start += JdwpString.getSize(fieldsWithGenericReplyDataDeclared.signature));
                    fieldsWithGenericReplyDataDeclared.modBits = JdwpInt.decode(bytes, start += JdwpString.getSize(fieldsWithGenericReplyDataDeclared.genericSignature));
                    start += JdwpInt.getSize();
                    fieldsWithGenericReplyData.declared.add(fieldsWithGenericReplyDataDeclared);
                }
                return fieldsWithGenericReplyData;
            }

            public class FieldsWithGenericData {
                public long fieldID;
                public String name;
                public String signature;
                public String genericSignature;
                public int modBits;
            }

            public class FieldsWithGenericReplyData {
                public List<FieldsWithGenericData> declared;
            }
        }

        public class SignatureWithGeneric {
            public ByteBuffer encode(long refType) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(2, 13);
                JDWP.this.mReferenceTypeID.encode(refType, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public SignatureWithGenericReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                SignatureWithGenericReplyData signatureWithGenericReplyData = new SignatureWithGenericReplyData();
                signatureWithGenericReplyData.signature = JdwpString.decode(bytes, start);
                signatureWithGenericReplyData.genericSignature = JdwpString.decode(bytes, start += JdwpString.getSize(signatureWithGenericReplyData.signature));
                start += JdwpString.getSize(signatureWithGenericReplyData.genericSignature);
                return signatureWithGenericReplyData;
            }

            public class SignatureWithGenericReplyData {
                public String signature;
                public String genericSignature;
            }
        }

        public class SourceDebugExtension {
            public ByteBuffer encode(long refType) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(2, 12);
                JDWP.this.mReferenceTypeID.encode(refType, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public SourceDebugExtensionReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                SourceDebugExtensionReplyData sourceDebugExtensionReplyData = new SourceDebugExtensionReplyData();
                sourceDebugExtensionReplyData.extension = JdwpString.decode(bytes, start);
                start += JdwpString.getSize(sourceDebugExtensionReplyData.extension);
                return sourceDebugExtensionReplyData;
            }

            public class SourceDebugExtensionReplyData {
                public String extension;
            }
        }

        public class ClassObject {
            public ByteBuffer encode(long refType) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(2, 11);
                JDWP.this.mReferenceTypeID.encode(refType, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public ClassObjectReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                ClassObjectReplyData classObjectReplyData = new ClassObjectReplyData();
                classObjectReplyData.classObject = JDWP.this.mClassObjectID.decode(bytes, start);
                start += JDWP.this.mClassObjectID.getSize();
                return classObjectReplyData;
            }

            public class ClassObjectReplyData {
                public long classObject;
            }
        }

        public class Interfaces {
            public ByteBuffer encode(long refType) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(2, 10);
                JDWP.this.mReferenceTypeID.encode(refType, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public InterfacesReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                InterfacesReplyData interfacesReplyData = new InterfacesReplyData();
                int interfacesSize = JdwpInt.decode(bytes, start);
                start += JdwpInt.getSize();
                interfacesReplyData.interfaces = new ArrayList<InterfacesReplyDataInterfaces>(interfacesSize);
                for (int i = 0; i < interfacesSize; ++i) {
                    InterfacesReplyDataInterfaces interfacesReplyDataInterfaces = new InterfacesReplyDataInterfaces();
                    interfacesReplyDataInterfaces.interfaceType = JDWP.this.mInterfaceID.decode(bytes, start);
                    start += JDWP.this.mInterfaceID.getSize();
                    interfacesReplyData.interfaces.add(interfacesReplyDataInterfaces);
                }
                return interfacesReplyData;
            }

            public class InterfacesReplyDataInterfaces {
                public long interfaceType;
            }

            public class InterfacesReplyData {
                public List<InterfacesReplyDataInterfaces> interfaces;
            }
        }

        public class Status {
            public ByteBuffer encode(long refType) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(2, 9);
                JDWP.this.mReferenceTypeID.encode(refType, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public StatusReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                StatusReplyData statusReplyData = new StatusReplyData();
                statusReplyData.status = JdwpInt.decode(bytes, start);
                start += JdwpInt.getSize();
                return statusReplyData;
            }

            public class StatusReplyData {
                public int status;
            }
        }

        public class NestedTypes {
            public ByteBuffer encode(long refType) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(2, 8);
                JDWP.this.mReferenceTypeID.encode(refType, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public NestedTypesReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                NestedTypesReplyData nestedTypesReplyData = new NestedTypesReplyData();
                int classesSize = JdwpInt.decode(bytes, start);
                start += JdwpInt.getSize();
                nestedTypesReplyData.classes = new ArrayList<NestedTypesReplyDataClasses>(classesSize);
                for (int i = 0; i < classesSize; ++i) {
                    NestedTypesReplyDataClasses nestedTypesReplyDataClasses = new NestedTypesReplyDataClasses();
                    nestedTypesReplyDataClasses.refTypeTag = JdwpByte.decode(bytes, start);
                    nestedTypesReplyDataClasses.typeID = JDWP.this.mReferenceTypeID.decode(bytes, start += JdwpByte.getSize());
                    start += JDWP.this.mReferenceTypeID.getSize();
                    nestedTypesReplyData.classes.add(nestedTypesReplyDataClasses);
                }
                return nestedTypesReplyData;
            }

            public class NestedTypesReplyDataClasses {
                public byte refTypeTag;
                public long typeID;
            }

            public class NestedTypesReplyData {
                public List<NestedTypesReplyDataClasses> classes;
            }
        }

        public class SourceFile {
            public ByteBuffer encode(long refType) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(2, 7);
                JDWP.this.mReferenceTypeID.encode(refType, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public SourceFileReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                SourceFileReplyData sourceFileReplyData = new SourceFileReplyData();
                sourceFileReplyData.sourceFile = JdwpString.decode(bytes, start);
                start += JdwpString.getSize(sourceFileReplyData.sourceFile);
                return sourceFileReplyData;
            }

            public class SourceFileReplyData {
                public String sourceFile;
            }
        }

        public class GetValues {
            public ByteBuffer encode(long refType, List<Long> fields) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(2, 6);
                JDWP.this.mReferenceTypeID.encode(refType, bytes);
                JdwpInt.encode(fields.size(), bytes);
                for (int i = 0; i < fields.size(); ++i) {
                    JDWP.this.mFieldID.encode(fields.get(i), bytes);
                }
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public GetValuesReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                GetValuesReplyData getValuesReplyData = new GetValuesReplyData();
                int valuesSize = JdwpInt.decode(bytes, start);
                start += JdwpInt.getSize();
                getValuesReplyData.values = new ArrayList<GetValuesReplyDataValues>(valuesSize);
                for (int i = 0; i < valuesSize; ++i) {
                    GetValuesReplyDataValues getValuesReplyDataValues = new GetValuesReplyDataValues();
                    getValuesReplyDataValues.value = JDWP.this.mValue.decode(bytes, start);
                    start += JDWP.this.mValue.getSize(getValuesReplyDataValues.value.tag);
                    getValuesReplyData.values.add(getValuesReplyDataValues);
                }
                return getValuesReplyData;
            }

            public class GetValuesReplyDataValues {
                public ValuePacket value;
            }

            public class GetValuesReplyData {
                public List<GetValuesReplyDataValues> values;
            }
        }

        public class Methods {
            public ByteBuffer encode(long refType) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(2, 5);
                JDWP.this.mReferenceTypeID.encode(refType, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public MethodsReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                MethodsReplyData methodsReplyData = new MethodsReplyData();
                int declaredSize = JdwpInt.decode(bytes, start);
                start += JdwpInt.getSize();
                methodsReplyData.declared = new ArrayList<MethodsReplyDataDeclared>(declaredSize);
                for (int i = 0; i < declaredSize; ++i) {
                    MethodsReplyDataDeclared methodsReplyDataDeclared = new MethodsReplyDataDeclared();
                    methodsReplyDataDeclared.methodID = JDWP.this.mMethodID.decode(bytes, start);
                    methodsReplyDataDeclared.name = JdwpString.decode(bytes, start += JDWP.this.mMethodID.getSize());
                    methodsReplyDataDeclared.signature = JdwpString.decode(bytes, start += JdwpString.getSize(methodsReplyDataDeclared.name));
                    methodsReplyDataDeclared.modBits = JdwpInt.decode(bytes, start += JdwpString.getSize(methodsReplyDataDeclared.signature));
                    start += JdwpInt.getSize();
                    methodsReplyData.declared.add(methodsReplyDataDeclared);
                }
                return methodsReplyData;
            }

            public class MethodsReplyDataDeclared {
                public long methodID;
                public String name;
                public String signature;
                public int modBits;
            }

            public class MethodsReplyData {
                public List<MethodsReplyDataDeclared> declared;
            }
        }

        public class Fields {
            public ByteBuffer encode(long refType) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(2, 4);
                JDWP.this.mReferenceTypeID.encode(refType, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public FieldsReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                FieldsReplyData fieldsReplyData = new FieldsReplyData();
                int declaredSize = JdwpInt.decode(bytes, start);
                start += JdwpInt.getSize();
                fieldsReplyData.declared = new ArrayList<FieldsReplyDataDeclared>(declaredSize);
                for (int i = 0; i < declaredSize; ++i) {
                    FieldsReplyDataDeclared fieldsReplyDataDeclared = new FieldsReplyDataDeclared();
                    fieldsReplyDataDeclared.fieldID = JDWP.this.mFieldID.decode(bytes, start);
                    fieldsReplyDataDeclared.name = JdwpString.decode(bytes, start += JDWP.this.mFieldID.getSize());
                    fieldsReplyDataDeclared.signature = JdwpString.decode(bytes, start += JdwpString.getSize(fieldsReplyDataDeclared.name));
                    fieldsReplyDataDeclared.modBits = JdwpInt.decode(bytes, start += JdwpString.getSize(fieldsReplyDataDeclared.signature));
                    start += JdwpInt.getSize();
                    fieldsReplyData.declared.add(fieldsReplyDataDeclared);
                }
                return fieldsReplyData;
            }

            public class FieldsReplyDataDeclared {
                public long fieldID;
                public String name;
                public String signature;
                public int modBits;
            }

            public class FieldsReplyData {
                public List<FieldsReplyDataDeclared> declared;
            }
        }

        public class Modifiers {
            public ByteBuffer encode(long refType) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(2, 3);
                JDWP.this.mReferenceTypeID.encode(refType, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public ModifiersReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                ModifiersReplyData modifiersReplyData = new ModifiersReplyData();
                modifiersReplyData.modBits = JdwpInt.decode(bytes, start);
                start += JdwpInt.getSize();
                return modifiersReplyData;
            }

            public class ModifiersReplyData {
                public int modBits;
            }
        }

        public class ClassLoader {
            public ByteBuffer encode(long refType) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(2, 2);
                JDWP.this.mReferenceTypeID.encode(refType, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public ClassLoaderReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                ClassLoaderReplyData classLoaderReplyData = new ClassLoaderReplyData();
                classLoaderReplyData.classLoader = JDWP.this.mClassLoaderID.decode(bytes, start);
                start += JDWP.this.mClassLoaderID.getSize();
                return classLoaderReplyData;
            }

            public class ClassLoaderReplyData {
                public long classLoader;
            }
        }

        public class Signature {
            public ByteBuffer encode(long refType) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(2, 1);
                JDWP.this.mReferenceTypeID.encode(refType, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public SignatureReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                SignatureReplyData signatureReplyData = new SignatureReplyData();
                signatureReplyData.signature = JdwpString.decode(bytes, start);
                start += JdwpString.getSize(signatureReplyData.signature);
                return signatureReplyData;
            }

            public class SignatureReplyData {
                public String signature;
            }
        }
    }

    public class VirtualMachine {
        private final Version cmdVersion = new Version();
        private final ClassesBySignature cmdClassesBySignature = new ClassesBySignature();
        private final AllClasses cmdAllClasses = new AllClasses();
        private final AllThreads cmdAllThreads = new AllThreads();
        private final TopLevelThreadGroups cmdTopLevelThreadGroups = new TopLevelThreadGroups();
        private final Dispose cmdDispose = new Dispose();
        private final Exit cmdExit = new Exit();
        private final CreateString cmdCreateString = new CreateString();
        private final Capabilities cmdCapabilities = new Capabilities();
        private final ClassPaths cmdClassPaths = new ClassPaths();
        private final DisposeObjects cmdDisposeObjects = new DisposeObjects();
        private final HoldEvents cmdHoldEvents = new HoldEvents();
        private final ReleaseEvents cmdReleaseEvents = new ReleaseEvents();
        private final CapabilitiesNew cmdCapabilitiesNew = new CapabilitiesNew();
        private final RedefineClasses cmdRedefineClasses = new RedefineClasses();
        private final SetDefaultStratum cmdSetDefaultStratum = new SetDefaultStratum();
        private final AllClassesWithGeneric cmdAllClassesWithGeneric = new AllClassesWithGeneric();
        private final InstanceCounts cmdInstanceCounts = new InstanceCounts();

        public Version cmdVersion() {
            return this.cmdVersion;
        }

        public ClassesBySignature cmdClassesBySignature() {
            return this.cmdClassesBySignature;
        }

        public AllClasses cmdAllClasses() {
            return this.cmdAllClasses;
        }

        public AllThreads cmdAllThreads() {
            return this.cmdAllThreads;
        }

        public TopLevelThreadGroups cmdTopLevelThreadGroups() {
            return this.cmdTopLevelThreadGroups;
        }

        public Dispose cmdDispose() {
            return this.cmdDispose;
        }

        public Exit cmdExit() {
            return this.cmdExit;
        }

        public CreateString cmdCreateString() {
            return this.cmdCreateString;
        }

        public Capabilities cmdCapabilities() {
            return this.cmdCapabilities;
        }

        public ClassPaths cmdClassPaths() {
            return this.cmdClassPaths;
        }

        public DisposeObjects cmdDisposeObjects() {
            return this.cmdDisposeObjects;
        }

        public HoldEvents cmdHoldEvents() {
            return this.cmdHoldEvents;
        }

        public ReleaseEvents cmdReleaseEvents() {
            return this.cmdReleaseEvents;
        }

        public CapabilitiesNew cmdCapabilitiesNew() {
            return this.cmdCapabilitiesNew;
        }

        public RedefineClasses cmdRedefineClasses() {
            return this.cmdRedefineClasses;
        }

        public SetDefaultStratum cmdSetDefaultStratum() {
            return this.cmdSetDefaultStratum;
        }

        public AllClassesWithGeneric cmdAllClassesWithGeneric() {
            return this.cmdAllClassesWithGeneric;
        }

        public InstanceCounts cmdInstanceCounts() {
            return this.cmdInstanceCounts;
        }

        private VirtualMachine() {
        }

        public class InstanceCounts {
            public ByteBuffer encode(List<InstanceCountsRefTypesCount> refTypesCount) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(1, 21);
                JdwpInt.encode(refTypesCount.size(), bytes);
                for (int i = 0; i < refTypesCount.size(); ++i) {
                    InstanceCountsRefTypesCount instanceCountsRefTypesCount = refTypesCount.get(i);
                    JDWP.this.mReferenceTypeID.encode(instanceCountsRefTypesCount.refType, bytes);
                }
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public InstanceCountsReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                InstanceCountsReplyData instanceCountsReplyData = new InstanceCountsReplyData();
                int countsSize = JdwpInt.decode(bytes, start);
                start += JdwpInt.getSize();
                instanceCountsReplyData.counts = new ArrayList<InstanceCountsReplyDataCounts>(countsSize);
                for (int i = 0; i < countsSize; ++i) {
                    InstanceCountsReplyDataCounts instanceCountsReplyDataCounts = new InstanceCountsReplyDataCounts();
                    instanceCountsReplyDataCounts.instanceCount = JdwpLong.decode(bytes, start);
                    start += JdwpLong.getSize();
                    instanceCountsReplyData.counts.add(instanceCountsReplyDataCounts);
                }
                return instanceCountsReplyData;
            }

            public class InstanceCountsReplyDataCounts {
                public long instanceCount;
            }

            public class InstanceCountsReplyData {
                public List<InstanceCountsReplyDataCounts> counts;
            }

            public class InstanceCountsRefTypesCount {
                public long refType;
            }
        }

        public class AllClassesWithGeneric {
            public ByteBuffer encode() {
                ByteBuffer bytes = JDWP.encodeCommandPacket(1, 20);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public AllClassesWithGenericReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                AllClassesWithGenericReplyData allClassesWithGenericReplyData = new AllClassesWithGenericReplyData();
                int classesSize = JdwpInt.decode(bytes, start);
                start += JdwpInt.getSize();
                allClassesWithGenericReplyData.classes = new ArrayList<AllClassesWithGenericData>(classesSize);
                for (int i = 0; i < classesSize; ++i) {
                    AllClassesWithGenericData allClassesWithGenericReplyDataClasses = new AllClassesWithGenericData();
                    allClassesWithGenericReplyDataClasses.refTypeTag = JdwpByte.decode(bytes, start);
                    allClassesWithGenericReplyDataClasses.typeID = JDWP.this.mReferenceTypeID.decode(bytes, start += JdwpByte.getSize());
                    allClassesWithGenericReplyDataClasses.signature = JdwpString.decode(bytes, start += JDWP.this.mReferenceTypeID.getSize());
                    allClassesWithGenericReplyDataClasses.genericSignature = JdwpString.decode(bytes, start += JdwpString.getSize(allClassesWithGenericReplyDataClasses.signature));
                    allClassesWithGenericReplyDataClasses.status = JdwpInt.decode(bytes, start += JdwpString.getSize(allClassesWithGenericReplyDataClasses.genericSignature));
                    start += JdwpInt.getSize();
                    allClassesWithGenericReplyData.classes.add(allClassesWithGenericReplyDataClasses);
                }
                return allClassesWithGenericReplyData;
            }

            public class AllClassesWithGenericData {
                public byte refTypeTag;
                public long typeID;
                public String signature;
                public String genericSignature;
                public int status;
            }

            public class AllClassesWithGenericReplyData {
                public List<AllClassesWithGenericData> classes;
            }
        }

        public class SetDefaultStratum {
            public ByteBuffer encode(String stratumID) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(1, 19);
                JdwpString.encode(stratumID, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public boolean decode(byte[] bytes, int start) throws JdwpRuntimeException {
                return bytes.length == 11;
            }
        }

        public class RedefineClasses {
            public ByteBuffer encode(List<RedefineClassesClasses> classes) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(1, 18);
                JdwpInt.encode(classes.size(), bytes);
                for (int i = 0; i < classes.size(); ++i) {
                    RedefineClassesClasses redefineClassesClasses = classes.get(i);
                    JDWP.this.mReferenceTypeID.encode(redefineClassesClasses.refType, bytes);
                    for (int ii = 0; ii < redefineClassesClasses.classfile.size(); ++ii) {
                        RedefineClassesClassfile redefineClassesClassfile = redefineClassesClasses.classfile.get(ii);
                        JdwpByte.encode(redefineClassesClassfile.classbyte, bytes);
                    }
                }
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public boolean decode(byte[] bytes, int start) throws JdwpRuntimeException {
                return bytes.length == 11;
            }

            public class RedefineClassesClassfile {
                public byte classbyte;
            }

            public class RedefineClassesClasses {
                public long refType;
                public List<RedefineClassesClassfile> classfile;
            }
        }

        public class CapabilitiesNew {
            public ByteBuffer encode() {
                ByteBuffer bytes = JDWP.encodeCommandPacket(1, 17);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public CapabilitiesNewReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                CapabilitiesNewReplyData capabilitiesNewReplyData = new CapabilitiesNewReplyData();
                capabilitiesNewReplyData.canWatchFieldModification = JdwpBoolean.decode(bytes, start);
                capabilitiesNewReplyData.canWatchFieldAccess = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesNewReplyData.canGetBytecodes = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesNewReplyData.canGetSyntheticAttribute = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesNewReplyData.canGetOwnedMonitorInfo = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesNewReplyData.canGetCurrentContendedMonitor = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesNewReplyData.canGetMonitorInfo = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesNewReplyData.canRedefineClasses = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesNewReplyData.canAddMethod = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesNewReplyData.canUnrestrictedlyRedefineClasses = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesNewReplyData.canPopFrames = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesNewReplyData.canUseInstanceFilters = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesNewReplyData.canGetSourceDebugExtension = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesNewReplyData.canRequestVMDeathEvent = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesNewReplyData.canSetDefaultStratum = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesNewReplyData.canGetInstanceInfo = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesNewReplyData.canRequestMonitorEvents = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesNewReplyData.canGetMonitorFrameInfo = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesNewReplyData.canUseSourceNameFilters = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesNewReplyData.canGetConstantPool = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesNewReplyData.canForceEarlyReturn = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesNewReplyData.reserved22 = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesNewReplyData.reserved23 = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesNewReplyData.reserved24 = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesNewReplyData.reserved25 = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesNewReplyData.reserved26 = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesNewReplyData.reserved27 = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesNewReplyData.reserved28 = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesNewReplyData.reserved29 = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesNewReplyData.reserved30 = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesNewReplyData.reserved31 = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesNewReplyData.reserved32 = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                start += JdwpBoolean.getSize();
                return capabilitiesNewReplyData;
            }

            public class CapabilitiesNewReplyData {
                public boolean canWatchFieldModification;
                public boolean canWatchFieldAccess;
                public boolean canGetBytecodes;
                public boolean canGetSyntheticAttribute;
                public boolean canGetOwnedMonitorInfo;
                public boolean canGetCurrentContendedMonitor;
                public boolean canGetMonitorInfo;
                public boolean canRedefineClasses;
                public boolean canAddMethod;
                public boolean canUnrestrictedlyRedefineClasses;
                public boolean canPopFrames;
                public boolean canUseInstanceFilters;
                public boolean canGetSourceDebugExtension;
                public boolean canRequestVMDeathEvent;
                public boolean canSetDefaultStratum;
                public boolean canGetInstanceInfo;
                public boolean canRequestMonitorEvents;
                public boolean canGetMonitorFrameInfo;
                public boolean canUseSourceNameFilters;
                public boolean canGetConstantPool;
                public boolean canForceEarlyReturn;
                public boolean reserved22;
                public boolean reserved23;
                public boolean reserved24;
                public boolean reserved25;
                public boolean reserved26;
                public boolean reserved27;
                public boolean reserved28;
                public boolean reserved29;
                public boolean reserved30;
                public boolean reserved31;
                public boolean reserved32;
            }
        }

        public class ReleaseEvents {
            public ByteBuffer encode() {
                ByteBuffer bytes = JDWP.encodeCommandPacket(1, 16);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public boolean decode(byte[] bytes, int start) throws JdwpRuntimeException {
                return bytes.length == 11;
            }
        }

        public class HoldEvents {
            public ByteBuffer encode() {
                ByteBuffer bytes = JDWP.encodeCommandPacket(1, 15);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public boolean decode(byte[] bytes, int start) throws JdwpRuntimeException {
                return bytes.length == 11;
            }
        }

        public class DisposeObjects {
            public ByteBuffer encode(List<DisposeObjectsRequests> requests) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(1, 14);
                JdwpInt.encode(requests.size(), bytes);
                for (int i = 0; i < requests.size(); ++i) {
                    DisposeObjectsRequests disposeObjectsRequests = requests.get(i);
                    JDWP.this.mObjectID.encode(disposeObjectsRequests.object, bytes);
                    JdwpInt.encode(disposeObjectsRequests.refCnt, bytes);
                }
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public boolean decode(byte[] bytes, int start) throws JdwpRuntimeException {
                return bytes.length == 11;
            }

            public class DisposeObjectsRequests {
                public long object;
                public int refCnt;
            }
        }

        public class ClassPaths {
            public ByteBuffer encode() {
                ByteBuffer bytes = JDWP.encodeCommandPacket(1, 13);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public ClassPathsReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                ClassPathsReplyData classPathsReplyData = new ClassPathsReplyData();
                classPathsReplyData.baseDir = JdwpString.decode(bytes, start);
                int classpathsSize = JdwpInt.decode(bytes, start += JdwpString.getSize(classPathsReplyData.baseDir));
                start += JdwpInt.getSize();
                classPathsReplyData.classpaths = new ArrayList<ClassPathsReplyDataClasspaths>(classpathsSize);
                for (int i = 0; i < classpathsSize; ++i) {
                    ClassPathsReplyDataClasspaths classPathsReplyDataClasspaths = new ClassPathsReplyDataClasspaths();
                    classPathsReplyDataClasspaths.path = JdwpString.decode(bytes, start);
                    int bootclasspathsSize = JdwpInt.decode(bytes, start += JdwpString.getSize(classPathsReplyDataClasspaths.path));
                    start += JdwpInt.getSize();
                    classPathsReplyDataClasspaths.bootclasspaths = new ArrayList<ClassPathsReplyDataBootclasspaths>(bootclasspathsSize);
                    for (int ii = 0; ii < bootclasspathsSize; ++ii) {
                        ClassPathsReplyDataBootclasspaths classPathsReplyDataBootclasspaths = new ClassPathsReplyDataBootclasspaths();
                        classPathsReplyDataBootclasspaths.path = JdwpString.decode(bytes, start);
                        start += JdwpString.getSize(classPathsReplyDataBootclasspaths.path);
                        classPathsReplyDataClasspaths.bootclasspaths.add(classPathsReplyDataBootclasspaths);
                    }
                    classPathsReplyData.classpaths.add(classPathsReplyDataClasspaths);
                }
                return classPathsReplyData;
            }

            public class ClassPathsReplyDataBootclasspaths {
                public String path;
            }

            public class ClassPathsReplyDataClasspaths {
                public String path;
                public List<ClassPathsReplyDataBootclasspaths> bootclasspaths;
            }

            public class ClassPathsReplyData {
                public String baseDir;
                public List<ClassPathsReplyDataClasspaths> classpaths;
            }
        }

        public class Capabilities {
            public ByteBuffer encode() {
                ByteBuffer bytes = JDWP.encodeCommandPacket(1, 12);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public CapabilitiesReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                CapabilitiesReplyData capabilitiesReplyData = new CapabilitiesReplyData();
                capabilitiesReplyData.canWatchFieldModification = JdwpBoolean.decode(bytes, start);
                capabilitiesReplyData.canWatchFieldAccess = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesReplyData.canGetBytecodes = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesReplyData.canGetSyntheticAttribute = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesReplyData.canGetOwnedMonitorInfo = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesReplyData.canGetCurrentContendedMonitor = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                capabilitiesReplyData.canGetMonitorInfo = JdwpBoolean.decode(bytes, start += JdwpBoolean.getSize());
                start += JdwpBoolean.getSize();
                return capabilitiesReplyData;
            }

            public class CapabilitiesReplyData {
                public boolean canWatchFieldModification;
                public boolean canWatchFieldAccess;
                public boolean canGetBytecodes;
                public boolean canGetSyntheticAttribute;
                public boolean canGetOwnedMonitorInfo;
                public boolean canGetCurrentContendedMonitor;
                public boolean canGetMonitorInfo;
            }
        }

        public class CreateString {
            public ByteBuffer encode(String utf) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(1, 11);
                JdwpString.encode(utf, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public CreateStringReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                CreateStringReplyData createStringReplyData = new CreateStringReplyData();
                createStringReplyData.stringObject = JDWP.this.mStringID.decode(bytes, start);
                start += JDWP.this.mStringID.getSize();
                return createStringReplyData;
            }

            public class CreateStringReplyData {
                public long stringObject;
            }
        }

        public class Exit {
            public ByteBuffer encode(int exitCode) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(1, 10);
                JdwpInt.encode(exitCode, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public boolean decode(byte[] bytes, int start) throws JdwpRuntimeException {
                return bytes.length == 11;
            }
        }

        public class Dispose {
            public ByteBuffer encode() {
                ByteBuffer bytes = JDWP.encodeCommandPacket(1, 6);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public boolean decode(byte[] bytes, int start) throws JdwpRuntimeException {
                return bytes.length == 11;
            }
        }

        public class TopLevelThreadGroups {
            public ByteBuffer encode() {
                ByteBuffer bytes = JDWP.encodeCommandPacket(1, 5);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public TopLevelThreadGroupsReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                TopLevelThreadGroupsReplyData topLevelThreadGroupsReplyData = new TopLevelThreadGroupsReplyData();
                int groupsSize = JdwpInt.decode(bytes, start);
                start += JdwpInt.getSize();
                topLevelThreadGroupsReplyData.groups = new ArrayList<TopLevelThreadGroupsReplyDataGroups>(groupsSize);
                for (int i = 0; i < groupsSize; ++i) {
                    TopLevelThreadGroupsReplyDataGroups topLevelThreadGroupsReplyDataGroups = new TopLevelThreadGroupsReplyDataGroups();
                    topLevelThreadGroupsReplyDataGroups.group = JDWP.this.mThreadGroupID.decode(bytes, start);
                    start += JDWP.this.mThreadGroupID.getSize();
                    topLevelThreadGroupsReplyData.groups.add(topLevelThreadGroupsReplyDataGroups);
                }
                return topLevelThreadGroupsReplyData;
            }

            public class TopLevelThreadGroupsReplyDataGroups {
                public long group;
            }

            public class TopLevelThreadGroupsReplyData {
                public List<TopLevelThreadGroupsReplyDataGroups> groups;
            }
        }

        public class AllThreads {
            public ByteBuffer encode() {
                ByteBuffer bytes = JDWP.encodeCommandPacket(1, 4);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public AllThreadsReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                AllThreadsReplyData allThreadsReplyData = new AllThreadsReplyData();
                int threadsSize = JdwpInt.decode(bytes, start);
                start += JdwpInt.getSize();
                allThreadsReplyData.threads = new ArrayList<AllThreadsReplyDataThreads>(threadsSize);
                for (int i = 0; i < threadsSize; ++i) {
                    AllThreadsReplyDataThreads allThreadsReplyDataThreads = new AllThreadsReplyDataThreads();
                    allThreadsReplyDataThreads.thread = JDWP.this.mThreadID.decode(bytes, start);
                    start += JDWP.this.mThreadID.getSize();
                    allThreadsReplyData.threads.add(allThreadsReplyDataThreads);
                }
                return allThreadsReplyData;
            }

            public class AllThreadsReplyDataThreads {
                public long thread;
            }

            public class AllThreadsReplyData {
                public List<AllThreadsReplyDataThreads> threads;
            }
        }

        public class AllClasses {
            public ByteBuffer encode() {
                ByteBuffer bytes = JDWP.encodeCommandPacket(1, 3);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public AllClassesReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                AllClassesReplyData allClassesReplyData = new AllClassesReplyData();
                int classesSize = JdwpInt.decode(bytes, start);
                start += JdwpInt.getSize();
                allClassesReplyData.classes = new ArrayList<AllClassesReplyDataClasses>(classesSize);
                for (int i = 0; i < classesSize; ++i) {
                    AllClassesReplyDataClasses allClassesReplyDataClasses = new AllClassesReplyDataClasses();
                    allClassesReplyDataClasses.refTypeTag = JdwpByte.decode(bytes, start);
                    allClassesReplyDataClasses.typeID = JDWP.this.mReferenceTypeID.decode(bytes, start += JdwpByte.getSize());
                    allClassesReplyDataClasses.signature = JdwpString.decode(bytes, start += JDWP.this.mReferenceTypeID.getSize());
                    allClassesReplyDataClasses.status = JdwpInt.decode(bytes, start += JdwpString.getSize(allClassesReplyDataClasses.signature));
                    start += JdwpInt.getSize();
                    allClassesReplyData.classes.add(allClassesReplyDataClasses);
                }
                return allClassesReplyData;
            }

            public class AllClassesReplyDataClasses {
                public byte refTypeTag;
                public long typeID;
                public String signature;
                public int status;
            }

            public class AllClassesReplyData {
                public List<AllClassesReplyDataClasses> classes;
            }
        }

        public class ClassesBySignature {
            public ByteBuffer encode(String signature) {
                ByteBuffer bytes = JDWP.encodeCommandPacket(1, 2);
                JdwpString.encode(signature, bytes);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public ClassesBySignatureReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                ClassesBySignatureReplyData classesBySignatureReplyData = new ClassesBySignatureReplyData();
                int classesSize = JdwpInt.decode(bytes, start);
                start += JdwpInt.getSize();
                classesBySignatureReplyData.classes = new ArrayList<ClassesBySignatureReplyDataClasses>(classesSize);
                for (int i = 0; i < classesSize; ++i) {
                    ClassesBySignatureReplyDataClasses classesBySignatureReplyDataClasses = new ClassesBySignatureReplyDataClasses();
                    classesBySignatureReplyDataClasses.refTypeTag = JdwpByte.decode(bytes, start);
                    classesBySignatureReplyDataClasses.typeID = JDWP.this.mReferenceTypeID.decode(bytes, start += JdwpByte.getSize());
                    classesBySignatureReplyDataClasses.status = JdwpInt.decode(bytes, start += JDWP.this.mReferenceTypeID.getSize());
                    start += JdwpInt.getSize();
                    classesBySignatureReplyData.classes.add(classesBySignatureReplyDataClasses);
                }
                return classesBySignatureReplyData;
            }

            public class ClassesBySignatureReplyDataClasses {
                public byte refTypeTag;
                public long typeID;
                public int status;
            }

            public class ClassesBySignatureReplyData {
                public List<ClassesBySignatureReplyDataClasses> classes;
            }
        }

        public class Version {
            public ByteBuffer encode() {
                ByteBuffer bytes = JDWP.encodeCommandPacket(1, 1);
                JDWP.setPacketLen(bytes);
                return bytes;
            }

            public VersionReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
                VersionReplyData versionReplyData = new VersionReplyData();
                versionReplyData.description = JdwpString.decode(bytes, start);
                versionReplyData.jdwpMajor = JdwpInt.decode(bytes, start += JdwpString.getSize(versionReplyData.description));
                versionReplyData.jdwpMinor = JdwpInt.decode(bytes, start += JdwpInt.getSize());
                versionReplyData.vmVersion = JdwpString.decode(bytes, start += JdwpInt.getSize());
                versionReplyData.vmName = JdwpString.decode(bytes, start += JdwpString.getSize(versionReplyData.vmVersion));
                start += JdwpString.getSize(versionReplyData.vmName);
                return versionReplyData;
            }

            public class VersionReplyData {
                public String description;
                public int jdwpMajor;
                public int jdwpMinor;
                public String vmVersion;
                public String vmName;
            }
        }
    }

    public static class Packet {
        private byte[] buf;

        public static Packet make(byte[] bytes) {
            Packet header = new Packet();
            header.buf = bytes;
            return header;
        }

        public int getID() throws JdwpRuntimeException {
            return JDWP.getPacketID(this.buf, 0);
        }

        public int getCommandSetID() throws JdwpRuntimeException {
            return JDWP.getPacketCommandSetID(this.buf, 0);
        }

        public int getCommandID() throws JdwpRuntimeException {
            return JDWP.getPacketCommandID(this.buf, 0);
        }

        public byte getFlags() throws JdwpRuntimeException {
            return JDWP.getPacketFlags(this.buf, 0);
        }

        public short getErrorCode() throws JdwpRuntimeException {
            return JDWP.getPacketErrorCode(this.buf, 0);
        }

        public boolean isReplyPacket() throws JdwpRuntimeException {
            return (this.getFlags() & 0xFF) == 128;
        }

        public boolean isError() throws JdwpRuntimeException {
            return this.getErrorCode() != 0;
        }

        public String getErrorText() throws JdwpRuntimeException {
            return Error.getErrorText(this.getErrorCode());
        }

        public int getLength() {
            return this.buf.length;
        }

        public byte[] getBuf() {
            return this.buf;
        }
    }

    public static class Resume {
        public static ByteBuffer encode() {
            ByteBuffer bytes = JDWP.encodeCommandPacket(1, 9);
            JDWP.setPacketLen(bytes);
            return bytes;
        }

        public static boolean decode(byte[] bytes, int start) throws JdwpRuntimeException {
            return bytes.length == 11;
        }
    }

    public static class Suspend {
        public static ByteBuffer encode() {
            ByteBuffer bytes = JDWP.encodeCommandPacket(1, 8);
            JDWP.setPacketLen(bytes);
            return bytes;
        }

        public static boolean decode(byte[] bytes, int start) throws JdwpRuntimeException {
            return bytes.length == 11;
        }
    }

    public static class IDSizes {
        public static ByteBuffer encode() {
            ByteBuffer bytes = JDWP.encodeCommandPacket(1, 7);
            JDWP.setPacketLen(bytes);
            return bytes;
        }

        public static IDSizesReplyData decode(byte[] bytes, int start) throws JdwpRuntimeException {
            IDSizesReplyData iDSizesReplyData = new IDSizesReplyData();
            iDSizesReplyData.fieldIDSize = JdwpInt.decode(bytes, start);
            iDSizesReplyData.methodIDSize = JdwpInt.decode(bytes, start += JdwpInt.getSize());
            iDSizesReplyData.objectIDSize = JdwpInt.decode(bytes, start += JdwpInt.getSize());
            iDSizesReplyData.referenceTypeIDSize = JdwpInt.decode(bytes, start += JdwpInt.getSize());
            iDSizesReplyData.frameIDSize = JdwpInt.decode(bytes, start += JdwpInt.getSize());
            start += JdwpInt.getSize();
            return iDSizesReplyData;
        }

        public static class IDSizesReplyData {
            public int fieldIDSize;
            public int methodIDSize;
            public int objectIDSize;
            public int referenceTypeIDSize;
            public int frameIDSize;
        }
    }
}

