/*
 * Decompiled with CFR 0.152.
 */
package org.eolang;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eolang.EObool;
import org.eolang.EOint;
import org.eolang.EOtuple;
import org.eolang.core.EOObject;
import org.paukov.combinatorics3.Generator;

public class EOarray
extends EOObject {
    private final List<EOObject> _array;

    public EOarray() {
        this._array = Collections.emptyList();
    }

    public EOarray(EOObject ... objects) {
        this._array = Collections.unmodifiableList(Arrays.asList(objects));
    }

    public EOarray EOappend(EOObject obj) {
        EOObject[] newArray = new EOObject[this._array.size() + 1];
        System.arraycopy(this._array.toArray(new EOObject[0]), 0, newArray, 0, this._array.size());
        newArray[this._array.size()] = obj;
        return new EOarray(newArray);
    }

    public EOarray EOappendAll(EOObject obj) {
        try {
            int array2Size = obj._getAttribute("EOlength", new EOObject[0])._getData().toInt().intValue();
            if (array2Size > 0) {
                EOObject[] newArray = new EOObject[this._array.size() + array2Size];
                System.arraycopy(this._array.toArray(new EOObject[0]), 0, newArray, 0, this._array.size());
                for (int i = this._array.size(); i < newArray.length; ++i) {
                    newArray[i] = obj._getAttribute("EOget", new EOint(i - this._array.size()));
                }
                return new EOarray(newArray);
            }
            return this;
        }
        catch (Exception e) {
            return this.EOappend(obj);
        }
    }

    public EObool EOeach(EOObject evaluatorObject) {
        for (EOObject current : this._array) {
            evaluatorObject._getAttribute("EOeach", current)._getData();
        }
        return new EObool(true);
    }

    public EOint EOfind(EOObject from, EOObject validator) {
        int index = from._getData().toInt().intValue();
        if (index > this._array.size() || index < 0) {
            return new EOint(-1L);
        }
        for (int i = index; i < this._array.size(); ++i) {
            try {
                if (!validator._getAttribute("EOvalidator", this._array.get(i))._getDecoratedObject()._getData().toBoolean().booleanValue()) continue;
                return new EOint(i);
            }
            catch (Exception e) {
                return new EOint(-1L);
            }
        }
        return new EOint(-1L);
    }

    public EOObject EOget(EOObject i) {
        int position = i._getData().toInt().intValue();
        if (position >= this._array.size() || position < 0) {
            throw new IndexOutOfBoundsException(String.format("Cannot retrieve the element at the position %d of the following array: %s. The index is out of bounds.", position, this));
        }
        return this._array.get(position);
    }

    public EOarray EOinsert(EOObject obj, EOObject i) {
        int index = i._getData().toInt().intValue();
        if (index > this._array.size() || index < 0) {
            throw new IndexOutOfBoundsException(String.format("Cannot insert the object at the position %d of the following array: %s. The index is out of bounds.", index, this));
        }
        EOObject[] newArray = new EOObject[this._array.size() + 1];
        if (index > 0) {
            System.arraycopy(this._array.toArray(new EOObject[0]), 0, newArray, 0, index);
        }
        newArray[index] = obj;
        if (index < this._array.size()) {
            System.arraycopy(this._array.toArray(new EOObject[0]), index, newArray, index + 1, this._array.size() - index);
        }
        return new EOarray(newArray);
    }

    public EObool EOisEmpty() {
        return new EObool(this._array.isEmpty());
    }

    public EOint EOlength() {
        return new EOint(this._array.size());
    }

    public EOarray EOmap(EOObject mapperObject) {
        int length = this._array.size();
        EOObject[] mappedArray = new EOObject[length];
        for (int i = 0; i < length; ++i) {
            mappedArray[i] = mapperObject._getAttribute("EOmap", this._array.get(i))._getDecoratedObject();
        }
        return new EOarray(mappedArray);
    }

    public EOarray EOmapi(EOObject mapperObject) {
        int length = this._array.size();
        EOObject[] mappedArray = new EOObject[length];
        for (int i = 0; i < length; ++i) {
            mappedArray[i] = mapperObject._getAttribute("EOmapi", this._array.get(i), new EOint(i))._getDecoratedObject();
        }
        return new EOarray(mappedArray);
    }

    public EOint EOmin(EOObject comparator) {
        if (this._array.isEmpty()) {
            return new EOint(-1L);
        }
        if (this._array.size() == 1) {
            return new EOint(0L);
        }
        int currentMinIndex = 0;
        EOObject currentMin = this._array.get(currentMinIndex);
        boolean allEqual = true;
        for (int i = 1; i < this._array.size(); ++i) {
            EOObject comparison = comparator._getAttribute("EOcomparator", currentMin, new EOint(currentMinIndex), this._array.get(i), new EOint(i))._getDecoratedObject();
            long comparisonResult = comparison._getData().toInt();
            if (comparisonResult != 0L) {
                allEqual = false;
            }
            if (comparisonResult != 1L) continue;
            currentMinIndex = i;
            currentMin = this._array.get(currentMinIndex);
        }
        if (allEqual) {
            return new EOint(-1L);
        }
        return new EOint(currentMinIndex);
    }

    public EOarray EOpairs() {
        return new EOarray((EOObject[])Generator.combination(this._array.toArray(new EOObject[0])).simple(2).stream().map(pair -> new EOtuple((EOObject)pair.get(0), (EOObject)pair.get(1))).toArray(EOObject[]::new));
    }

    public EOObject EOreduce(EOObject accumulator, EOObject reducerObject) {
        EOObject out = accumulator;
        for (EOObject eoObject : this._array) {
            out = reducerObject._getAttribute("EOreduce", out, eoObject)._getDecoratedObject();
        }
        return out;
    }

    public EOObject EOreducei(EOObject accumulator, EOObject reducerObject) {
        EOObject out = accumulator;
        int length = this._array.size();
        for (int i = 0; i < length; ++i) {
            out = reducerObject._getAttribute("EOreducei", out, this._array.get(i), new EOint(i))._getDecoratedObject();
        }
        return out;
    }

    public EOarray EOremove(EOObject i) {
        int position = i._getData().toInt().intValue();
        if (position >= this._array.size() || position < 0) {
            throw new IndexOutOfBoundsException(String.format("Cannot remove the element at the position %d of the following array: %s. The index is out of bounds.", position, this));
        }
        EOObject[] newArray = new EOObject[this._array.size() - 1];
        if (position > 0) {
            System.arraycopy(this._array.toArray(new EOObject[0]), 0, newArray, 0, position);
        }
        if (position < this._array.size() - 1) {
            System.arraycopy(this._array.toArray(new EOObject[0]), position + 1, newArray, position, this._array.size() - position - 1);
        }
        return new EOarray(newArray);
    }

    public EOarray EOreplace(EOObject i, EOObject newValue) {
        int position = i._getData().toInt().intValue();
        if (position >= this._array.size() || position < 0) {
            throw new IndexOutOfBoundsException(String.format("Cannot replace the element at the position %d of the following array: %s with the new value %s. The index is out of bounds.", position, this, newValue));
        }
        EOObject[] newArray = new EOObject[this._array.size()];
        System.arraycopy(this._array.toArray(new EOObject[0]), 0, newArray, 0, this._array.size());
        newArray[position] = newValue;
        return new EOarray(newArray);
    }

    public EOarray EOreverse() {
        EOObject[] newArray = new EOObject[this._array.size()];
        for (int i = this._array.size() - 1; i >= 0; --i) {
            newArray[this._array.size() - 1 - i] = this._array.get(i);
        }
        return new EOarray(newArray);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EOarray eOarray = (EOarray)o;
        return this._array.equals(eOarray._array);
    }

    public int hashCode() {
        return Objects.hash(this._array);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("array([");
        for (EOObject o : this._array) {
            sb.append(o.toString()).append(", ");
        }
        if (this._array.size() > 0) {
            sb.delete(sb.length() - 2, sb.length());
        }
        sb.append("])");
        return sb.toString();
    }
}

