/*
 * Decompiled with CFR 0.152.
 */
package org.eolang;

import org.eolang.EObool;
import org.eolang.core.EOObject;
import org.eolang.core.data.EOData;

public class EOfloat
extends EOObject {
    private final double value;

    public EOfloat(double value) {
        this.value = value;
    }

    @Override
    public EOData _getData() {
        return new EOData(this.value);
    }

    public EOfloat EOadd(EOObject rightAddend) {
        return new EOfloat(this.value + rightAddend._getData().toFloat());
    }

    public EOfloat EOsub(EOObject subtrahend) {
        return new EOfloat(this.value - subtrahend._getData().toFloat());
    }

    public EOfloat EOdiv(EOObject divisor) {
        if (divisor._getData().toFloat() == 0.0) {
            throw new ArithmeticException("Division by zero not possible");
        }
        return new EOfloat(this.value / divisor._getData().toFloat());
    }

    public EOfloat EOmul(EOObject multiplier) {
        return new EOfloat(this.value * multiplier._getData().toFloat());
    }

    public EObool EOeq(EOObject rightFloat) {
        return new EObool(this.value == rightFloat._getData().toFloat());
    }

    public EObool EOneq(EOObject rightFloat) {
        return new EObool(this.value != rightFloat._getData().toFloat());
    }

    public EObool EOless(EOObject rightFloat) {
        return new EObool(this.value < rightFloat._getData().toFloat());
    }

    public EObool EOleq(EOObject rightFloat) {
        return new EObool(this.value <= rightFloat._getData().toFloat());
    }

    public EObool EOgreater(EOObject rightFloat) {
        return new EObool(this.value > rightFloat._getData().toFloat());
    }

    public EObool EOgeq(EOObject rightFloat) {
        return new EObool(this.value >= rightFloat._getData().toFloat());
    }

    public EOfloat EOneg() {
        return new EOfloat(-this.value);
    }

    public EOfloat EOabs() {
        return new EOfloat(Math.abs(this.value));
    }

    public EOfloat EOsignum() {
        return new EOfloat(Math.signum(this.value));
    }

    public EOfloat EOpow(EOObject exponent) {
        return new EOfloat(Math.pow(this.value, exponent._getData().toFloat()));
    }
}

