/*
 * Decompiled with CFR 0.152.
 */
package org.eolang;

import java.util.Objects;
import org.eolang.EObool;
import org.eolang.EOfloat;
import org.eolang.core.EOObject;
import org.eolang.core.data.EOData;

public class EOint
extends EOObject {
    private final long value;

    public EOint(long value) {
        this.value = value;
    }

    @Override
    public EOData _getData() {
        return new EOData(this.value);
    }

    public EOint EOadd(EOObject rightAddend) {
        return new EOint(this.value + rightAddend._getData().toInt());
    }

    public EOint EOsub(EOObject subtrahend) {
        return new EOint(this.value - subtrahend._getData().toInt());
    }

    public EOint EOdiv(EOObject divisor) {
        if (divisor._getData().toInt() == 0L) {
            throw new ArithmeticException("Division by zero not possible");
        }
        return new EOint(Math.floorDiv(this.value, divisor._getData().toInt()));
    }

    public EOint EOmul(EOObject rightFactor) {
        return new EOint(this.value * rightFactor._getData().toInt());
    }

    public EObool EOeq(EOObject rightInt) {
        try {
            return new EObool(this.value == rightInt._getData().toInt());
        }
        catch (Exception e) {
            return new EObool(false);
        }
    }

    public EObool EOneq(EOObject rightInt) {
        return new EObool(this.value != rightInt._getData().toInt());
    }

    public EObool EOless(EOObject rightInt) {
        return new EObool(this.value < rightInt._getData().toInt());
    }

    public EObool EOleq(EOObject rightInt) {
        return new EObool(this.value <= rightInt._getData().toInt());
    }

    public EObool EOgreater(EOObject rightInt) {
        return new EObool(this.value > rightInt._getData().toInt());
    }

    public EObool EOgeq(EOObject rightInt) {
        return new EObool(this.value >= rightInt._getData().toInt());
    }

    public EOint EOneg() {
        return new EOint(-this.value);
    }

    public EOint EOabs() {
        return new EOint(Math.abs(this.value));
    }

    public EOint EOsignum() {
        return new EOint((long)Math.signum(this.value));
    }

    public EOint EOpow(EOObject exponent) {
        return new EOint((long)Math.pow(this.value, exponent._getData().toInt().longValue()));
    }

    public EOint EOmod(EOObject divisor) {
        return new EOint(Math.floorMod(this.value, divisor._getData().toInt()));
    }

    public EOfloat EOtoFloat() {
        return new EOfloat(this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof EOObject)) {
            return false;
        }
        EOObject eoObject = (EOObject)o;
        return this.EOeq(eoObject)._getData().toBoolean();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("int(");
        sb.append(this.value);
        sb.append(')');
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

