/*
 * Decompiled with CFR 0.152.
 */
package org.eolang;

import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Objects;
import org.eolang.EOarray;
import org.eolang.EObool;
import org.eolang.EOfloat;
import org.eolang.EOint;
import org.eolang.core.EOObject;
import org.eolang.core.data.EOData;

public class EOstring
extends EOObject {
    private final String stringValue;

    public EOstring() {
        this.stringValue = "";
    }

    public EOstring(String stringValue) {
        this.stringValue = stringValue;
    }

    @Override
    public EOData _getData() {
        return new EOData(this.stringValue);
    }

    public EOstring EOappend(EOObject ... rightStrings) {
        StringBuilder sb = new StringBuilder(this.stringValue);
        try {
            for (EOObject str : rightStrings) {
                sb.append(str._getData().toString());
            }
        }
        catch (Exception e) {
            throw new InvalidParameterException();
        }
        return new EOstring(sb.toString());
    }

    public EOstring EOsubstring(EOObject begin, EOObject end) {
        try {
            return new EOstring(this.stringValue.substring(begin._getData().toInt().intValue(), end._getData().toInt().intValue()));
        }
        catch (IndexOutOfBoundsException e) {
            throw new IndexOutOfBoundsException();
        }
        catch (Exception e) {
            throw new InvalidParameterException();
        }
    }

    public EOstring EOtrim() {
        return new EOstring(this.stringValue.trim());
    }

    public EOarray EOsplit(EOObject separator) {
        int j;
        ArrayList<EOstring> strList = new ArrayList<EOstring>();
        int i = 0;
        while ((j = this.stringValue.indexOf(separator._getData().toString(), i)) >= 0) {
            if (j > 0) {
                strList.add(new EOstring(this.stringValue.substring(i, j)));
            }
            i = j + 1;
        }
        String last = this.stringValue.substring(i);
        if (last.length() > 0) {
            strList.add(new EOstring(last));
        }
        return new EOarray(strList.toArray(new EOstring[strList.size()]));
    }

    public EOint EOtoInt() {
        return new EOint(Long.parseLong(this.stringValue));
    }

    public EOfloat EOtoFloat() {
        return new EOfloat(Double.parseDouble(this.stringValue));
    }

    public EObool EOeq(EOObject rightString) {
        return new EObool(this.stringValue.equals(rightString._getData().toString()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof EOObject)) {
            return false;
        }
        EOObject eoObject = (EOObject)o;
        return this.EOeq(eoObject)._getData().toBoolean();
    }

    public String toString() {
        return "\"" + this.stringValue + "\"";
    }

    public int hashCode() {
        return Objects.hash(this.stringValue);
    }
}

