/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.core;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eolang.core.data.EOData;

public abstract class EOObject
implements Cloneable {
    protected EOObject _decoratee() {
        return null;
    }

    protected EOObject _parent() {
        return null;
    }

    public EOObject _getDecoratedObject() {
        EOObject decoratee = this._decoratee();
        if (decoratee == null) {
            throw new RuntimeException(String.format("Can't access the decoratee object of the %s object: the @ attribute is not bound.", this.getClass().getTypeName()));
        }
        return decoratee;
    }

    public EOObject _getParentObject() {
        EOObject parent = this._parent();
        if (parent == null) {
            throw new RuntimeException(String.format("Can't access the parent object of the %s object.", this.getClass().getTypeName()));
        }
        return parent;
    }

    public EOData _getData() {
        EOObject decoratedObject = this._decoratee();
        if (decoratedObject == null) {
            throw new RuntimeException(String.format("Object %s cannot be dataized: it has nor data behind it, neither a decoratee to rely on.", this.getClass().getTypeName()));
        }
        return decoratedObject._getData();
    }

    public EOObject _getAttribute(String name, EOObject ... arguments) {
        try {
            Method method = Arrays.stream(this.getClass().getMethods()).filter(mthd -> mthd.getName().equals(name)).findFirst().get();
            Parameter[] methodParams = method.getParameters();
            method.setAccessible(true);
            return (EOObject)method.invoke((Object)this, this._prepareFreeAtt(methodParams, arguments));
        }
        catch (Exception e) {
            if (this._decoratee() != null && this._decoratee() != this) {
                return this._decoratee()._getAttribute(name, arguments);
            }
            e.printStackTrace();
            throw new RuntimeException(String.format("Can't access the %s attribute of the %s object", name, this.getClass().getTypeName()));
        }
    }

    private Object[] _prepareFreeAtt(Parameter[] methodParams, EOObject ... arguments) {
        ArrayList<Object> methodValues = new ArrayList<Object>();
        for (int i = 0; i < methodParams.length; ++i) {
            if (methodParams[i].getType().getCanonicalName().endsWith("[]")) {
                List<EOObject> objs = Arrays.stream(arguments).skip(i).collect(Collectors.toList());
                methodValues.add(objs.toArray(new EOObject[0]));
                break;
            }
            methodValues.add(arguments[i]);
        }
        return methodValues.toArray();
    }
}

