/*
 * Decompiled with CFR 0.152.
 */
package org.eolang.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eolang.EOstring;
import org.eolang.core.EOObject;
import org.eolang.core.data.EODataObject;

public class Main {
    private final PrintStream stdout;

    public Main(PrintStream out) {
        this.stdout = out;
    }

    public static void main(String ... args) throws Exception {
        new Main(System.out).exec(args);
    }

    public void exec(String ... args) throws Exception {
        if (args.length == 0 || "--version".equals(args[0])) {
            this.version();
            return;
        }
        String path = args[0].replaceAll("([^.]+)$", "EO$1");
        Constructor<?> appConstructor = Arrays.stream(Class.forName(path).getConstructors()).findFirst().get();
        Parameter[] appParams = appConstructor.getParameters();
        ArrayList<Object> appValues = new ArrayList<Object>();
        for (int i = 0; i < appParams.length; ++i) {
            if (appParams[i].getType().getCanonicalName().endsWith("[]")) {
                List<EOstring> objs = Arrays.stream(args).skip(i + 1).map(EOstring::new).collect(Collectors.toList());
                appValues.add(objs.toArray(new EOstring[0]));
                break;
            }
            EODataObject obj = new EODataObject(args[i + 1]);
            appValues.add(obj);
        }
        EOObject app = (EOObject)appConstructor.newInstance(appValues.toArray());
        System.out.print(String.format("%s", app._getData().toString()));
    }

    private void version() throws IOException {
        try (BufferedReader input = new BufferedReader(new InputStreamReader(Objects.requireNonNull(Main.class.getResourceAsStream("version.txt")), StandardCharsets.UTF_8));){
            if (input.lines().findFirst().isPresent()) {
                this.stdout.printf("Eolang Runtime v.%s", input.lines().findFirst().get());
            }
        }
    }
}

