/*
 * Decompiled with CFR 0.152.
 */
package org.paukov.combinatorics3;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.paukov.combinatorics3.PermutationWithRepetitionGenerator;

class PermutationWithRepetitionIterator<T>
implements Iterator<List<T>> {
    final PermutationWithRepetitionGenerator<T> generator;
    private final int originalVectorSize;
    private final int permutationLength;
    private final List<T> currentPermutation;
    private long currentIndex;
    private final int[] bitVector;

    PermutationWithRepetitionIterator(PermutationWithRepetitionGenerator<T> generator) {
        this.generator = generator;
        this.originalVectorSize = generator.originalVector.size();
        this.permutationLength = generator.permutationLength;
        ArrayList list = new ArrayList(this.permutationLength);
        Object defaultValue = generator.originalVector.get(0);
        for (int i = 0; i < this.permutationLength; ++i) {
            list.add(defaultValue);
        }
        this.currentPermutation = new ArrayList<T>(list);
        this.bitVector = new int[this.permutationLength + 2];
        this.currentIndex = 0L;
    }

    @Override
    public boolean hasNext() {
        return this.bitVector[this.permutationLength] != 1;
    }

    @Override
    public List<T> next() {
        ++this.currentIndex;
        for (int j = this.permutationLength - 1; j >= 0; --j) {
            this.currentPermutation.set(j, this.generator.originalVector.get(this.bitVector[j]));
        }
        int i = 0;
        while (this.bitVector[i] == this.originalVectorSize - 1) {
            if (i >= this.permutationLength + 1) {
                this.bitVector[this.permutationLength] = 1;
                return new ArrayList<T>(this.currentPermutation);
            }
            this.bitVector[i] = 0;
            ++i;
        }
        int n = i;
        this.bitVector[n] = this.bitVector[n] + 1;
        return new ArrayList<T>(this.currentPermutation);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "PermutationWithRepetitionIterator=[#" + this.currentIndex + ", " + this.currentPermutation + "]";
    }
}

