/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.lts.producer.internals;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.huaweicloud.lts.producer.internals.SendProducerBatchTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class IOThreadPool {
    private static final String IO_THREAD_SUFFIX_FORMAT = "-io-thread-%d";
    private final ExecutorService ioThreadPool;

    public IOThreadPool(int ioThreadCount, String prefix) {
        this.ioThreadPool = Executors.newFixedThreadPool(ioThreadCount, new ThreadFactoryBuilder().setDaemon(true).setNameFormat(prefix + IO_THREAD_SUFFIX_FORMAT).build());
    }

    public void submit(SendProducerBatchTask task) {
        this.ioThreadPool.execute(task);
    }

    public void shutdown() {
        this.ioThreadPool.shutdown();
    }

    public boolean isTerminated() {
        return this.ioThreadPool.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.ioThreadPool.awaitTermination(timeout, unit);
    }
}

