/*
 * Decompiled with CFR 0.152.
 */
package com.huiaong.base64.multipartfile.starter.multipart;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.huiaong.base64.multipartfile.starter.multipart.Base64MultipartFileSerializer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import org.springframework.web.multipart.MultipartFile;

@JsonDeserialize(using=Base64MultipartFileSerializer.class)
public class Base64MultipartFile
implements MultipartFile {
    private final byte[] imgContent;
    private final String name;
    private final String contentType;

    public Base64MultipartFile(byte[] imgContent, String contentType, String suffix) {
        this.imgContent = imgContent;
        this.name = UUID.randomUUID().toString().replace("-", "") + suffix;
        this.contentType = contentType;
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalFilename() {
        return this.name;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isEmpty() {
        return this.imgContent == null || this.imgContent.length == 0;
    }

    public long getSize() {
        return this.imgContent.length;
    }

    public byte[] getBytes() {
        return this.imgContent;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.imgContent);
    }

    public void transferTo(File dest) throws IOException, IllegalStateException {
        new FileOutputStream(dest).write(this.imgContent);
    }
}

