/*
 * Decompiled with CFR 0.152.
 */
package com.huiaong.base64.multipartfile.starter.multipart;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.huiaong.base64.multipartfile.starter.multipart.Base64MultipartFile;
import com.huiaong.base64.multipartfile.starter.multipart.Suffix;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import sun.misc.BASE64Decoder;

public class Base64MultipartFileSerializer
extends JsonDeserializer<Base64MultipartFile> {
    private final Pattern BASE64_PATTERN = Pattern.compile("data:(.*/.*);base64,");

    public Base64MultipartFile deserialize(JsonParser jsonParser, DeserializationContext context) throws IOException {
        String base64 = jsonParser.getText();
        if (base64 == null || "".equals(base64)) {
            return null;
        }
        Matcher matcher = this.BASE64_PATTERN.matcher(base64);
        if (!matcher.lookingAt()) {
            return null;
        }
        byte[] b = new BASE64Decoder().decodeBuffer(this.BASE64_PATTERN.split(base64)[1]);
        for (int i = 0; i < b.length; ++i) {
            if (b[i] >= 0) continue;
            int n = i;
            b[n] = (byte)(b[n] + 256);
        }
        String contentType = matcher.group(1);
        return new Base64MultipartFile(b, contentType, Suffix.getSuffix(contentType));
    }
}

