/*
 * Decompiled with CFR 0.152.
 */
package test;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Bean;
import test.AppProperties;
import test.util.RedisClient;

@SpringBootApplication(scanBasePackages={"test"})
public class MarketingApiTestApp {
    private static final Logger log = LoggerFactory.getLogger(MarketingApiTestApp.class);

    public static void main(String[] args) {
        SpringApplication.run(MarketingApiTestApp.class, (String[])args);
    }

    @Bean(destroyMethod="close")
    public RedisClient redisClient(AppProperties appProp) {
        AppProperties.RedisClientProperties redisProp = appProp.getRedisClient();
        RedisClient redisClient = new RedisClient(redisProp);
        log.info("Connected to redis {}", (Object)redisProp);
        return redisClient;
    }
}

