/*
 * Decompiled with CFR 0.152.
 */
package test.auth.bean;

import java.util.Objects;

public class Result<T> {
    public static final int CODE_SUCCESS = 0;
    public static final int CODE_FAIL = -1;
    private final int code;
    private final T data;
    private final String cause;

    private Result(int code, T data, String cause) {
        this.code = code;
        this.data = data;
        this.cause = cause == null ? "" : cause;
    }

    public static <T> Result<T> ofSuccessful() {
        return new Result<Object>(0, null, null);
    }

    public static <T> Result<T> ofSuccessful(T data) {
        return new Result<T>(0, data, null);
    }

    public static <T> Result<T> ofFail() {
        return new Result<Object>(-1, null, null);
    }

    public static <T> Result<T> ofFail(String cause) {
        return new Result<Object>(-1, null, cause);
    }

    public static <T> Result<T> ofFail(Result<?> result) {
        return new Result<Object>(result.code, null, result.cause);
    }

    public static <T> Result<T> ofFail(int code, String cause) {
        return new Result<Object>(code, null, cause);
    }

    public boolean successful() {
        return this.code == 0;
    }

    public int code() {
        return this.code;
    }

    public T data() {
        return this.data;
    }

    public String cause() {
        return this.cause;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Result result = (Result)o;
        return this.code == result.code && Objects.equals(this.data, result.data) && Objects.equals(this.cause, result.cause);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.data, this.cause);
    }

    public String toString() {
        return "Result(code=" + this.code + ", data=" + this.data + ", cause='" + this.cause + '\'' + ')';
    }
}

