/*
 * Decompiled with CFR 0.152.
 */
package test.auth.oceanengine;

import com.hyq0719.mktapi.common.exception.ApiException;
import com.hyq0719.mktapi.oceanengine.bean.common.OceanResponse;
import com.hyq0719.mktapi.oceanengine.bean.token.AccessTokenRequest;
import com.hyq0719.mktapi.oceanengine.bean.token.AccessTokenResponseData;
import com.hyq0719.mktapi.oceanengine.bean.token.RefreshTokenRequest;
import com.hyq0719.mktapi.oceanengine.bean.token.RefreshTokenResponseData;
import com.hyq0719.mktapi.oceanengine.service.OceanSdkService;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import test.AppProperties;
import test.auth.TokenAuthorizer;
import test.auth.bean.AuthToken;
import test.auth.bean.Result;
import test.auth.oceanengine.OceanProperties;
import test.util.Util;

@Component
public class OceanAuthorizer
implements TokenAuthorizer {
    private final OceanProperties oceanProperties;
    @Resource
    private OceanSdkService oceanSdkService;
    @Resource
    private AppProperties appProperties;

    public OceanAuthorizer(OceanProperties oceanProperties) {
        this.oceanProperties = oceanProperties;
    }

    @Override
    public String channel() {
        return "ocean_engine";
    }

    @Override
    public Result<String> parseAuthCode(Map<String, String> params) {
        String authCode = params.get("auth_code");
        if (StringUtils.isEmpty((CharSequence)authCode)) {
            return Result.ofFail();
        }
        return Result.ofSuccessful(authCode);
    }

    @Override
    public Result<AuthToken> authorize(String advertiserId, String authCode) {
        OceanProperties.OceanOAuth2Config config = this.oceanProperties.getConfigs().get(advertiserId);
        if (config == null) {
            return Result.ofFail();
        }
        if (this.isDebugMode()) {
            return Util.authorizeForTest(advertiserId, authCode, this.channel());
        }
        AccessTokenRequest request = new AccessTokenRequest();
        request.appId(Long.valueOf(config.getClientId())).secret(config.getSecret()).grantType("auth_code").authCode(authCode);
        try {
            OceanResponse response = (OceanResponse)this.oceanSdkService.getTokenApi().accessToken().execute((Object)request);
            if (!response.isSuccessful()) {
                return Result.ofFail();
            }
            AccessTokenResponseData data = (AccessTokenResponseData)response.getData();
            AuthToken authToken = new AuthToken();
            authToken.setChannel(this.channel());
            authToken.setAdvertiserId(advertiserId);
            authToken.setAccessToken(data.getAccessToken());
            authToken.setRefreshToken(data.getRefreshToken());
            long now = System.currentTimeMillis();
            authToken.setCreateTime(now);
            authToken.setRefreshTime(now);
            return Result.ofSuccessful(authToken);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Result<AuthToken> refresh(AuthToken authToken) {
        OceanProperties.OceanOAuth2Config config = this.oceanProperties.getConfigs().get(authToken.getAdvertiserId());
        if (config == null) {
            return Result.ofFail();
        }
        if (this.isDebugMode()) {
            return Util.refreshForTest(authToken);
        }
        RefreshTokenRequest request = new RefreshTokenRequest();
        request.appId(Long.valueOf(config.getClientId())).secret(config.getSecret()).refreshToken(authToken.getRefreshToken()).grantType("auth_code");
        try {
            OceanResponse response = (OceanResponse)this.oceanSdkService.getTokenApi().refreshToken().execute((Object)request);
            if (!response.isSuccessful()) {
                return Result.ofFail();
            }
            RefreshTokenResponseData data = (RefreshTokenResponseData)response.getData();
            AuthToken newAuthToken = authToken.newToken(data.getAccessToken(), data.getRefreshToken());
            return Result.ofSuccessful(newAuthToken);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.ofFail();
        }
    }

    @Override
    public boolean isDebugMode() {
        return this.appProperties.isDebugMode();
    }
}

