/*
 * Decompiled with CFR 0.152.
 */
package test.auth.repo;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;
import test.auth.bean.AuthToken;
import test.util.RedisClient;
import test.util.RedisKeys;

@Repository
public class RedisTokenRepo {
    private final RedisClient redis;

    public RedisTokenRepo(RedisClient redis) {
        this.redis = redis;
    }

    public boolean saveOrUpdate(AuthToken authToken) {
        Gson gson = new Gson();
        long save = this.redis.execute(jedis -> jedis.hset(RedisKeys.authToken(authToken.getChannel()), authToken.getAdvertiserId(), gson.toJson((Object)authToken)));
        return save == 1L;
    }

    public boolean delete(String channel, String advertiserId) {
        long delete = this.redis.execute(jedis -> jedis.hdel(RedisKeys.authToken(channel), new String[]{advertiserId}));
        return delete == 1L;
    }

    public boolean delete(AuthToken authToken) {
        return this.delete(authToken.getChannel(), authToken.getAdvertiserId());
    }

    public AuthToken get(String channel, String advertiserId) {
        String data = this.redis.execute(jedis -> jedis.hget(RedisKeys.authToken(channel), advertiserId));
        if (StringUtils.isEmpty((CharSequence)data)) {
            return null;
        }
        return (AuthToken)new Gson().fromJson(data, AuthToken.class);
    }

    public List<AuthToken> findByChannel(String channel) {
        List datas = this.redis.execute(jedis -> jedis.hvals(RedisKeys.authToken(channel)));
        ArrayList<AuthToken> tokens = new ArrayList<AuthToken>(datas.size());
        for (String data : datas) {
            tokens.add((AuthToken)new Gson().fromJson(data, AuthToken.class));
        }
        return tokens;
    }
}

