/*
 * Decompiled with CFR 0.152.
 */
package test.auth.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import test.auth.TokenAuthorizer;
import test.auth.bean.AuthToken;
import test.auth.bean.Result;
import test.auth.repo.RedisTokenRepo;

@Service
public class AuthService
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(AuthService.class);
    private final RedisTokenRepo repo;
    private final Map<String, TokenAuthorizer> authorizerMap = new HashMap<String, TokenAuthorizer>();

    public AuthService(RedisTokenRepo repo) {
        this.repo = repo;
    }

    public AuthToken getToken(String channel, String advertiserId) {
        return this.repo.get(channel, advertiserId);
    }

    public List<AuthToken> getTokenByChannel(String channel) {
        return this.repo.findByChannel(channel);
    }

    public Result<AuthToken> create(String channel, String advertiserId, Map<String, String> params) {
        TokenAuthorizer authorizer = this.authorizerMap.get(channel);
        if (authorizer == null) {
            log.error("create AuthToken fail, no TokenAuthorizer found. channel: {}", (Object)channel);
            return Result.ofFail();
        }
        Result<String> authCode = authorizer.parseAuthCode(params);
        if (!authCode.successful()) {
            return Result.ofFail();
        }
        Result<AuthToken> authToken = authorizer.authorize(advertiserId, authCode.data());
        if (!authToken.successful()) {
            log.error("authorize AuthToken fail: {}", (Object)authToken.data());
            return authToken;
        }
        this.repo.saveOrUpdate(authToken.data());
        log.info("create AuthToken finish. token: {}", (Object)authToken.data());
        return authToken;
    }

    public Map<AuthToken, Boolean> refreshForChannel(String channel) {
        HashMap<AuthToken, Boolean> refreshTokens = new HashMap<AuthToken, Boolean>();
        List<AuthToken> authTokens = this.repo.findByChannel(channel);
        if (CollectionUtils.isEmpty(authTokens)) {
            log.warn("refreshForChannel : no token found for {}", (Object)channel);
            return refreshTokens;
        }
        log.info("refreshForChannel for {}", (Object)channel);
        TokenAuthorizer authorizer = this.authorizerMap.get(channel);
        for (AuthToken authToken : authTokens) {
            Result<AuthToken> tokenResult = authorizer.refresh(authToken);
            if (tokenResult.successful()) {
                this.repo.saveOrUpdate(tokenResult.data());
            }
            refreshTokens.put(tokenResult.data(), tokenResult.successful());
        }
        return refreshTokens;
    }

    public Result<AuthToken> refreshForAdvertiser(String channel, String advertiserId) {
        List<AuthToken> authTokens = this.repo.findByChannel(channel);
        if (StringUtils.isEmpty((CharSequence)advertiserId)) {
            log.warn("refreshForAdvertiser : advertiserId null");
            return Result.ofFail();
        }
        AuthToken target = null;
        for (AuthToken authToken : authTokens) {
            if (!advertiserId.equals(authToken.getAdvertiserId())) continue;
            target = authToken;
        }
        if (Objects.isNull(target)) {
            log.warn("refreshForChannel : no token found for {} : {}", (Object)channel, (Object)advertiserId);
            return Result.ofFail();
        }
        TokenAuthorizer authorizer = this.authorizerMap.get(channel);
        Result<AuthToken> tokenResult = authorizer.refresh(target);
        if (tokenResult.successful()) {
            this.repo.saveOrUpdate(tokenResult.data());
            return tokenResult;
        }
        return Result.ofFail();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map authorizers = applicationContext.getBeansOfType(TokenAuthorizer.class);
        for (TokenAuthorizer authorizer : authorizers.values()) {
            this.authorizerMap.put(authorizer.channel(), authorizer);
            log.info("TokenAuthorizer registered {} {}", (Object)authorizer.channel(), (Object)authorizer.getClass().getName());
        }
    }
}

