/*
 * Decompiled with CFR 0.152.
 */
package test.auth.tencent;

import com.hyq0719.mktapi.common.util.DigestUtil;
import com.hyq0719.mktapi.tencent.bean.account.adAccount.BusinessManagerRelationsGetListStruct;
import com.hyq0719.mktapi.tencent.bean.common.PageResponseData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.springframework.stereotype.Service;
import test.auth.bean.Result;
import test.util.ResultConverter;

@Service
public class TencentAccountService {
    @Resource
    OkHttpClient httpClient;

    public List<String> getSubAccounts(String accessToken) {
        Result<PageResponseData<BusinessManagerRelationsGetListStruct>> result = this.businessManagerRelationsGet(accessToken, 1, 100);
        if (!result.successful()) {
            return new ArrayList<String>();
        }
        Long totalPage = result.data().getPageInfo().getTotalPage();
        List pageList = result.data().getList();
        ArrayList total = new ArrayList(pageList);
        for (int i = 2; i < totalPage.intValue(); ++i) {
            result = this.businessManagerRelationsGet(accessToken, i, 100);
            pageList = result.data().getList();
            total.addAll(pageList);
        }
        return total.stream().map(x -> String.valueOf(x.getAccountId())).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result<PageResponseData<BusinessManagerRelationsGetListStruct>> businessManagerRelationsGet(String accessToken, int page, int pageSize) {
        String url = String.format("https://api.e.qq.com/v1.3/business_manager_relations/get?access_token=%s&timestamp=%s&nonce=%s", accessToken, System.currentTimeMillis() / 1000L, DigestUtil.encrypt((String)UUID.randomUUID().toString()));
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)url)).newBuilder();
        urlBuilder.addQueryParameter("page", "" + page);
        urlBuilder.addQueryParameter("page_size", "" + pageSize);
        Request request = new Request.Builder().url(urlBuilder.build()).get().build();
        try (Response response = this.httpClient.newCall(request).execute();){
            if (!response.isSuccessful()) {
                Result<PageResponseData<BusinessManagerRelationsGetListStruct>> result2 = Result.ofFail(response.code(), response.message());
                return result2;
            }
            String strResult = Objects.requireNonNull(response.body()).string();
            Result<PageResponseData<BusinessManagerRelationsGetListStruct>> result = ResultConverter.parseTencentResult(strResult, BusinessManagerRelationsGetListStruct.class);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Result.ofFail();
        }
    }
}

