/*
 * Decompiled with CFR 0.152.
 */
package test.auth.tencent;

import com.hyq0719.mktapi.common.exception.ApiException;
import com.hyq0719.mktapi.tencent.bean.common.TencentResponse;
import com.hyq0719.mktapi.tencent.bean.oauth.OauthTokenRequest;
import com.hyq0719.mktapi.tencent.bean.oauth.OauthTokenResponseData;
import com.hyq0719.mktapi.tencent.service.TencentSdkService;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import test.AppProperties;
import test.auth.TokenAuthorizer;
import test.auth.bean.AuthToken;
import test.auth.bean.Result;
import test.auth.tencent.TencentProperties;
import test.util.Util;

@Component
public class TencentAuthorizer
implements TokenAuthorizer {
    private final TencentProperties tencentProperties;
    @Resource
    private TencentSdkService tencentSdkService;
    @Resource
    private AppProperties appProperties;

    public TencentAuthorizer(TencentProperties tencentProperties) {
        this.tencentProperties = tencentProperties;
    }

    @Override
    public String channel() {
        return "tencent";
    }

    @Override
    public Result<String> parseAuthCode(Map<String, String> params) {
        String authCode = params.get("authorization_code");
        if (StringUtils.isEmpty((CharSequence)authCode)) {
            return Result.ofFail();
        }
        return Result.ofSuccessful(authCode);
    }

    @Override
    public Result<AuthToken> authorize(String advertiserId, String authCode) {
        TencentProperties.TencentOAuth2Config config = this.tencentProperties.getConfigs().get(advertiserId);
        if (config == null) {
            return Result.ofFail();
        }
        if (this.isDebugMode()) {
            return Util.authorizeForTest(advertiserId, authCode, this.channel());
        }
        OauthTokenRequest request = new OauthTokenRequest();
        request.clientId(Integer.valueOf(config.getClientId())).clientSecret(config.getSecret()).grantType("authorization_code").authorizationCode(authCode).redirectUri(config.getCallbackUrl());
        try {
            TencentResponse response = (TencentResponse)this.tencentSdkService.getOauthApi().oauthToken().execute((Object)request);
            if (!response.isSuccessful()) {
                return Result.ofFail();
            }
            OauthTokenResponseData data = (OauthTokenResponseData)response.getData();
            AuthToken authToken = new AuthToken();
            authToken.setChannel(this.channel());
            authToken.setAdvertiserId(data.getAuthorizerInfo().getWechatAccountId());
            authToken.setAccessToken(data.getAccessToken());
            authToken.setRefreshToken(data.getRefreshToken());
            long now = System.currentTimeMillis();
            authToken.setCreateTime(now);
            authToken.setRefreshTime(now);
            return Result.ofSuccessful(authToken);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.ofFail();
        }
    }

    @Override
    public Result<AuthToken> refresh(AuthToken authToken) {
        TencentProperties.TencentOAuth2Config config = this.tencentProperties.getConfigs().get(authToken.getAdvertiserId());
        if (config == null) {
            return Result.ofFail();
        }
        if (this.isDebugMode()) {
            return Util.refreshForTest(authToken);
        }
        OauthTokenRequest request = new OauthTokenRequest();
        request.clientId(Integer.valueOf(config.getClientId())).clientSecret(config.getSecret()).grantType("refresh_token").refreshToken(authToken.getRefreshToken());
        try {
            TencentResponse response = (TencentResponse)this.tencentSdkService.getOauthApi().oauthToken().execute((Object)request);
            if (!response.isSuccessful()) {
                return Result.ofFail();
            }
            OauthTokenResponseData data = (OauthTokenResponseData)response.getData();
            AuthToken newAuthToken = authToken.newToken(data.getAccessToken(), data.getRefreshToken());
            return Result.ofSuccessful(newAuthToken);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.ofFail();
        }
    }

    @Override
    public boolean isDebugMode() {
        return this.appProperties.isDebugMode();
    }
}

