/*
 * Decompiled with CFR 0.152.
 */
package test.auth.tencent;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.params.SetParams;
import test.auth.RefreshCronService;
import test.auth.bean.AuthToken;
import test.auth.bean.Result;
import test.auth.repo.RedisTokenRepo;
import test.auth.tencent.TencentAuthorizer;
import test.auth.tencent.TencentProperties;
import test.util.RedisClient;
import test.util.RedisKeys;
import test.util.Util;

public class TencentRefreshCronService
implements RefreshCronService {
    private static final Logger log = LoggerFactory.getLogger(TencentRefreshCronService.class);
    private final TencentAuthorizer tencentAuthorizer;
    private final TencentProperties tencentProperties;
    private final RedisTokenRepo repo;
    private final RedisClient redis;

    public TencentRefreshCronService(TencentAuthorizer tencentAuthorizer, TencentProperties tencentProperties, RedisTokenRepo repo, RedisClient redis) {
        this.tencentAuthorizer = tencentAuthorizer;
        this.tencentProperties = tencentProperties;
        this.repo = repo;
        this.redis = redis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trigger() {
        try {
            String locked = this.redis.execute(jedis -> jedis.set(RedisKeys.refreshLock(this.channel()), Util.getLocalIp(), new SetParams().nx().ex(900L)));
            if (!"OK".equalsIgnoreCase(locked)) {
                log.info("channel: {} autoRefresh acquire lock fail, skip refresh", (Object)this.channel());
                return;
            }
            log.info("channel: {} start autoRefresh token", (Object)this.channel());
            List<AuthToken> authTokens = this.repo.findByChannel(this.channel());
            for (AuthToken authToken : authTokens) {
                Result<AuthToken> result = this.tencentAuthorizer.refresh(authToken);
                if (!result.successful()) continue;
                this.repo.saveOrUpdate(result.data());
            }
            log.info("channel: {} autoRefresh token finish", (Object)this.channel());
        }
        catch (Exception e) {
            log.error("channel: {} autoRefresh token unknown error", (Object)this.channel(), (Object)e);
        }
        finally {
            this.redis.execute(jedis -> jedis.del(RedisKeys.refreshLock(this.channel())));
        }
    }

    @Override
    public String cron() {
        return this.tencentProperties.getCron();
    }

    @Override
    public String channel() {
        return "tencent";
    }
}

