/*
 * Decompiled with CFR 0.152.
 */
package test.auth.vivo;

import com.hyq0719.mktapi.common.exception.ApiException;
import com.hyq0719.mktapi.vivo.bean.common.VivoResponse;
import com.hyq0719.mktapi.vivo.bean.token.Oauth2RefreshTokenRequest;
import com.hyq0719.mktapi.vivo.bean.token.Oauth2RefreshTokenResponseData;
import com.hyq0719.mktapi.vivo.bean.token.Oauth2TokenRequest;
import com.hyq0719.mktapi.vivo.bean.token.Oauth2TokenResponseData;
import com.hyq0719.mktapi.vivo.service.VivoSdkService;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import test.AppProperties;
import test.auth.TokenAuthorizer;
import test.auth.bean.AuthToken;
import test.auth.bean.Result;
import test.auth.vivo.VivoProperties;
import test.util.Util;

@Component
public class VivoAuthorizer
implements TokenAuthorizer {
    private final VivoProperties vivoProperties;
    @Resource
    private VivoSdkService vivoSdkService;
    @Resource
    private AppProperties appProperties;

    public VivoAuthorizer(VivoProperties vivoProperties) {
        this.vivoProperties = vivoProperties;
    }

    @Override
    public String channel() {
        return "vivo";
    }

    @Override
    public Result<String> parseAuthCode(Map<String, String> params) {
        String authCode = params.get("code");
        if (StringUtils.isEmpty((CharSequence)authCode)) {
            return Result.ofFail();
        }
        return Result.ofSuccessful(authCode);
    }

    @Override
    public Result<AuthToken> authorize(String advertiserId, String authCode) {
        VivoProperties.VivoOAuth2Config config = this.vivoProperties.getConfigs().get(advertiserId);
        if (config == null) {
            return Result.ofFail();
        }
        if (this.isDebugMode()) {
            return Util.authorizeForTest(advertiserId, authCode, this.channel());
        }
        Oauth2TokenRequest request = new Oauth2TokenRequest();
        request.clientId(Integer.valueOf(config.getClientId())).clientSecret(config.getSecret()).grantType("code").code(authCode);
        try {
            VivoResponse response = (VivoResponse)this.vivoSdkService.getTokenApi().oauth2Token().execute((Object)request);
            if (!response.isSuccessful()) {
                return Result.ofFail();
            }
            Oauth2TokenResponseData data = (Oauth2TokenResponseData)response.getData();
            AuthToken authToken = new AuthToken();
            authToken.setChannel(this.channel());
            authToken.setAdvertiserId(advertiserId);
            authToken.setAccessToken(data.getAccessToken());
            authToken.setRefreshToken(data.getRefreshToken());
            long now = System.currentTimeMillis();
            authToken.setCreateTime(now);
            authToken.setRefreshTime(now);
            return Result.ofSuccessful(authToken);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.ofFail();
        }
    }

    @Override
    public Result<AuthToken> refresh(AuthToken authToken) {
        VivoProperties.VivoOAuth2Config config = this.vivoProperties.getConfigs().get(authToken.getAdvertiserId());
        if (config == null) {
            return Result.ofFail();
        }
        if (this.isDebugMode()) {
            return Util.refreshForTest(authToken);
        }
        Oauth2RefreshTokenRequest request = new Oauth2RefreshTokenRequest();
        request.clientId(config.getClientId()).clientSecret(config.getSecret()).refreshToken(authToken.getRefreshToken());
        try {
            VivoResponse response = (VivoResponse)this.vivoSdkService.getTokenApi().oauth2RefreshToken().execute((Object)request);
            if (!response.isSuccessful()) {
                return Result.ofFail();
            }
            Oauth2RefreshTokenResponseData data = (Oauth2RefreshTokenResponseData)response.getData();
            AuthToken newAuthToken = authToken.newToken(data.getAccessToken(), data.getRefreshToken());
            return Result.ofSuccessful(newAuthToken);
        }
        catch (ApiException e) {
            e.printStackTrace();
            return Result.ofFail();
        }
    }

    @Override
    public boolean isDebugMode() {
        return this.appProperties.isDebugMode();
    }
}

