/*
 * Decompiled with CFR 0.152.
 */
package test.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import test.AppProperties;
import test.auth.bean.AuthToken;
import test.auth.bean.Result;
import test.auth.service.AuthService;

@RestController
@RequestMapping(value={"auth"})
@Api(tags={"---\u7edf\u4e00\u8ba4\u8bc1\u6388\u6743---"})
public class AuthWebController {
    private static final Logger log = LoggerFactory.getLogger(AuthWebController.class);
    @Resource
    private AuthService authService;
    @Resource
    private AppProperties appProperties;

    public boolean isSupportChannel(String channel) {
        return this.appProperties.getChannels().contains(channel);
    }

    @ApiOperation(value="\u83b7\u53d6\u5e7f\u544a\u4e3btoken")
    @GetMapping(value={"/getToken/{channel}/{advertiserId}"})
    public AuthToken getToken(@PathVariable(value="channel") String channel, @PathVariable(value="advertiserId") String advertiserId) {
        if (!this.isSupportChannel(channel)) {
            return null;
        }
        return this.authService.getToken(channel, advertiserId);
    }

    @ApiOperation(value="\u6279\u91cf\u83b7\u53d6\u6e20\u9053\u5e7f\u544a\u4e3b\u8d26\u53f7")
    @GetMapping(value={"/getTokenByChannel/{channel}"})
    public List<AuthToken> getTokenByChannel(@PathVariable(value="channel") String channel) {
        if (!this.isSupportChannel(channel)) {
            return new ArrayList<AuthToken>();
        }
        return this.authService.getTokenByChannel(channel);
    }

    @ApiOperation(value="\u6dfb\u52a0\u5e7f\u544a\u4e3b\u8d26\u53f7")
    @PostMapping(value={"/addAdvertiser/{channel}/{advertiserId}"})
    public Object findTokenByChannel(@PathVariable(value="channel") String channel, @PathVariable(value="advertiserId") String advertiserId, @RequestBody Map<String, String> params) {
        log.info("receive add advertiser request. channel: {} product: {} params: {}", new Object[]{channel, advertiserId, params});
        if (!this.isSupportChannel(channel)) {
            return "unsupported channel: " + channel;
        }
        Result<AuthToken> result = this.authService.create(channel, advertiserId, params);
        return result.successful() ? "Success" : "Fail";
    }

    @ApiOperation(value="\u624b\u52a8\u5237\u65b0\u5e7f\u544a\u4e3b\u6388\u6743")
    @GetMapping(value={"/refreshAuthToken/{channel}/{advertiserId}"})
    public Object refreshAuthToken(@PathVariable(value="channel") String channel, @PathVariable(value="advertiserId") String advertiserId) {
        log.info("receive refresh auth token request. channel: {}", (Object)channel);
        if (!this.isSupportChannel(channel)) {
            return "unsupported channel: " + channel;
        }
        Result<AuthToken> result = this.authService.refreshForAdvertiser(channel, advertiserId);
        return result.successful() ? "Success" : "Fail";
    }

    @ApiOperation(value="\u624b\u52a8\u5237\u65b0\u6388\u6743")
    @GetMapping(value={"/refreshAuthToken/{channel}"})
    public Object refreshAuthTokenByChannel(@PathVariable(value="channel") String channel) {
        log.info("receive refresh auth token request. channel: {}", (Object)channel);
        if (!this.isSupportChannel(channel)) {
            return "unsupported channel: " + channel;
        }
        return this.authService.refreshForChannel(channel);
    }
}

