/*
 * Decompiled with CFR 0.152.
 */
package test.controller;

import com.hyq0719.mktapi.common.exception.ApiException;
import com.hyq0719.mktapi.oceanengine.bean.common.OceanRequest;
import com.hyq0719.mktapi.oceanengine.bean.common.OceanResponse;
import com.hyq0719.mktapi.oceanengine.bean.material.FileImageAdGetRequest;
import com.hyq0719.mktapi.oceanengine.bean.material.FileImageAdRequest;
import com.hyq0719.mktapi.oceanengine.bean.material.FileVideoAdGetRequest;
import com.hyq0719.mktapi.oceanengine.bean.material.ToolsVideoCoverSuggestRequest;
import com.hyq0719.mktapi.oceanengine.bean.report.ReportRequest;
import com.hyq0719.mktapi.oceanengine.service.OceanSdkService;
import io.swagger.annotations.Api;
import java.io.File;
import java.util.Arrays;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import test.util.FileUtil;

@RestController
@RequestMapping(value={"ocean"})
@Api(tags={"\u5de8\u91cf\u5f15\u64ce"})
public class OceanEngineApiTest {
    private final Long advertiserId = 0L;
    private final Long testId = 0L;
    @Resource
    private OceanSdkService oceanSdkService;

    @GetMapping(value={"/report/advertiser/get"})
    public OceanResponse reportAdvertiserGet() throws ApiException {
        ReportRequest request = new ReportRequest().advertiserId(this.advertiserId).startDate("2022-02-10").endDate("2022-02-10");
        return (OceanResponse)this.oceanSdkService.getDataReportApi().reportAdvertiserGet().execute((Object)request);
    }

    @GetMapping(value={"/report/campaign/get"})
    public OceanResponse reportCampaignGet() throws ApiException {
        ReportRequest request = new ReportRequest().advertiserId(this.advertiserId).startDate("2022-02-10").endDate("2022-02-10").groupBy(Arrays.asList("STAT_GROUP_BY_FIELD_ID"));
        return (OceanResponse)this.oceanSdkService.getDataReportApi().reportCampaignGet().execute((Object)request);
    }

    @GetMapping(value={"/report/ad/get"})
    public OceanResponse reportAdGet() throws ApiException {
        ReportRequest request = new ReportRequest().advertiserId(this.advertiserId).startDate("2022-02-10").endDate("2022-02-10");
        return (OceanResponse)this.oceanSdkService.getDataReportApi().reportAdGet().execute((Object)request);
    }

    @GetMapping(value={"/report/creative/get"})
    public OceanResponse reportCreativeGet() throws ApiException {
        ReportRequest request = new ReportRequest().advertiserId(this.advertiserId).startDate("2022-02-10").endDate("2022-02-10");
        return (OceanResponse)this.oceanSdkService.getDataReportApi().reportCreativeGet().execute((Object)request);
    }

    @GetMapping(value={"/campaign/get/"})
    public OceanResponse campaignGet() throws ApiException {
        OceanRequest request = new OceanRequest().advertiserId(this.advertiserId).page(Long.valueOf(1L)).pageSize(Long.valueOf(100L));
        return (OceanResponse)this.oceanSdkService.getAdServingApi().campaignGet().execute((Object)request);
    }

    @GetMapping(value={"/file/image/get"})
    public OceanResponse fileImageGet() throws ApiException {
        OceanRequest request = new OceanRequest().advertiserId(this.testId).page(Long.valueOf(1L)).pageSize(Long.valueOf(100L));
        return (OceanResponse)this.oceanSdkService.getMaterialApi().fileImageGet().execute((Object)request);
    }

    @GetMapping(value={"/file/video/get"})
    public OceanResponse fileVideoGet() throws ApiException {
        OceanRequest request = new OceanRequest().advertiserId(this.testId).page(Long.valueOf(1L)).pageSize(Long.valueOf(100L));
        return (OceanResponse)this.oceanSdkService.getMaterialApi().fileVideoGet().execute((Object)request);
    }

    @GetMapping(value={"/tools/video_cover/suggest"})
    public OceanResponse toolsVideoCoverSuggest() throws ApiException {
        ToolsVideoCoverSuggestRequest request = new ToolsVideoCoverSuggestRequest().advertiserId(this.advertiserId).videoId("");
        return (OceanResponse)this.oceanSdkService.getMaterialApi().toolsVideoCoverSuggest().execute((Object)request);
    }

    @GetMapping(value={"/file/image/ad/get"})
    public OceanResponse fileImageAdGet() throws ApiException {
        FileImageAdGetRequest request = new FileImageAdGetRequest().advertiserId(this.testId).imageIds(Arrays.asList(""));
        return (OceanResponse)this.oceanSdkService.getMaterialApi().fileImageAdGet().execute((Object)request);
    }

    @GetMapping(value={"/file/video/ad/get"})
    public OceanResponse fileVideoAdGet() throws ApiException {
        FileVideoAdGetRequest request = new FileVideoAdGetRequest().advertiserId(this.testId).videoIds(Arrays.asList(""));
        return (OceanResponse)this.oceanSdkService.getMaterialApi().fileVideoAdGet().execute((Object)request);
    }

    @GetMapping(value={"/file/image/ad"})
    public OceanResponse fileImageAd() throws ApiException {
        File imageFile = new File("");
        FileImageAdRequest request = new FileImageAdRequest().advertiserId(this.testId).filename("").imageSignature(FileUtil.getFileMD5(imageFile)).imageFile(imageFile).uploadType("UPLOAD_BY_FILE");
        return (OceanResponse)this.oceanSdkService.getMaterialApi().fileImageAd().execute((Object)request);
    }
}

