/*
 * Decompiled with CFR 0.152.
 */
package test.token.service;

import com.hyq0719.mktapi.common.token.IToken;
import com.hyq0719.mktapi.oceanengine.token.OceanExternalTokenService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import test.auth.bean.AuthToken;
import test.auth.oceanengine.OceanAccountService;
import test.auth.service.AuthService;
import test.token.bean.OceanToken;

@Component
public class OceanEngineTokenService
extends OceanExternalTokenService {
    private static final Logger log = LoggerFactory.getLogger(OceanEngineTokenService.class);
    @Resource
    private AuthService authService;
    @Resource
    private OceanAccountService oceanAccountService;

    public List<IToken> refreshAllToken() {
        log.info("OceanEngineTokenService refreshAllToken");
        ArrayList<IToken> tokens = new ArrayList<IToken>();
        List<AuthToken> authTokenList = this.authService.getTokenByChannel("ocean_engine");
        if (CollectionUtils.isEmpty(authTokenList)) {
            return tokens;
        }
        for (AuthToken authToken : authTokenList) {
            String advertiserId = authToken.getAdvertiserId();
            String accessToken = authToken.getAccessToken();
            List<String> subAccounts = this.oceanAccountService.getOceanSubAccounts(advertiserId, accessToken);
            for (String subAccount : subAccounts) {
                tokens.add(new OceanToken(subAccount, accessToken));
            }
        }
        this.addTokenForTest(tokens);
        return tokens;
    }

    public IToken refreshToken(String tokenKey) {
        AuthToken authToken = this.authService.getToken("ocean_engine", tokenKey);
        return new OceanToken(authToken.getAdvertiserId(), authToken.getAccessToken());
    }

    private void addTokenForTest(List<IToken> tokens) {
        tokens.add(new OceanToken("0000000000", "0000000000"));
        tokens.add(new OceanToken("0000000000", "0000000000"));
    }
}

