/*
 * Decompiled with CFR 0.152.
 */
package test.token.service;

import com.hyq0719.mktapi.common.token.IToken;
import com.hyq0719.mktapi.tencent.token.TencentExternalTokenService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import test.auth.bean.AuthToken;
import test.auth.service.AuthService;
import test.auth.tencent.TencentAccountService;
import test.token.bean.TencentToken;
import test.token.bean.VivoToken;

@Component
public class TencentTokenService
extends TencentExternalTokenService {
    private static final Logger log = LoggerFactory.getLogger(TencentTokenService.class);
    @Resource
    private AuthService authService;
    @Resource
    private TencentAccountService tencentAccountService;

    public List<IToken> refreshAllToken() {
        log.info("TencentTokenService refreshAllToken");
        List<AuthToken> authTokenList = this.authService.getTokenByChannel("tencent");
        ArrayList<IToken> tokens = new ArrayList<IToken>();
        for (AuthToken authToken : authTokenList) {
            List<String> subAccounts = this.tencentAccountService.getSubAccounts(authToken.getAccessToken());
            if (CollectionUtils.isEmpty(subAccounts)) {
                tokens.add(new VivoToken(authToken.getAdvertiserId(), authToken.getAccessToken()));
                continue;
            }
            for (String subAccount : subAccounts) {
                tokens.add(new TencentToken(subAccount, authToken.getAccessToken()));
            }
        }
        this.addTokenForTest(tokens);
        return tokens;
    }

    public IToken refreshToken(String tokenKey) {
        AuthToken authToken = this.authService.getToken("tencent", tokenKey);
        return new TencentToken(authToken.getAdvertiserId(), authToken.getAccessToken());
    }

    private void addTokenForTest(List<IToken> tokens) {
        tokens.add(new TencentToken("0000000000", "0000000000"));
        tokens.add(new TencentToken("0000000000", "0000000000"));
    }
}

