/*
 * Decompiled with CFR 0.152.
 */
package test.token.service;

import com.hyq0719.mktapi.common.token.IToken;
import com.hyq0719.mktapi.vivo.token.VivoExternalTokenService;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import test.auth.bean.AuthToken;
import test.auth.service.AuthService;
import test.token.bean.VivoToken;

@Component
public class VivoTokenService
extends VivoExternalTokenService {
    private static final Logger log = LoggerFactory.getLogger(VivoTokenService.class);
    @Resource
    AuthService authService;

    public List<IToken> refreshAllToken() {
        log.info("VivoTokenService refreshAllToken");
        ArrayList<IToken> tokens = new ArrayList<IToken>();
        List<AuthToken> authTokenList = this.authService.getTokenByChannel("vivo");
        if (CollectionUtils.isEmpty(authTokenList)) {
            return tokens;
        }
        for (AuthToken authToken : authTokenList) {
            tokens.add(new VivoToken(authToken.getAdvertiserId(), authToken.getAccessToken()));
        }
        this.addTokenForTest(tokens);
        return tokens;
    }

    public IToken refreshToken(String tokenKey) {
        AuthToken authToken = this.authService.getToken("vivo", tokenKey);
        return new VivoToken(authToken.getAdvertiserId(), authToken.getAccessToken());
    }

    private void addTokenForTest(List<IToken> tokens) {
        tokens.add(new VivoToken("0000000000", "0000000000"));
        tokens.add(new VivoToken("0000000000", "0000000000"));
    }
}

