/*
 * Decompiled with CFR 0.152.
 */
package test.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.params.ScanParams;
import redis.clients.jedis.resps.ScanResult;
import test.AppProperties;

public class RedisClient
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(RedisClient.class);
    private final JedisPool pool;

    public RedisClient(AppProperties.RedisClientProperties redisProps) {
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        poolConfig.setMaxTotal(redisProps.getPoolMaxSize());
        poolConfig.setMaxIdle(redisProps.getPoolMaxIdle());
        poolConfig.setMaxWaitMillis((long)redisProps.getPoolMaxWaitMs());
        this.pool = new JedisPool((GenericObjectPoolConfig)poolConfig, redisProps.getHost(), redisProps.getPort(), redisProps.getConnectTimeoutMs(), redisProps.getPassword(), redisProps.getDb());
    }

    public static Map<String, Map<String, String>> parseInfo(String infoString) {
        if (StringUtils.isEmpty((CharSequence)infoString)) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Map<String, String>> infoData = new LinkedHashMap<String, Map<String, String>>();
        LinkedHashMap<String, String> sectionData = null;
        try (BufferedReader reader = new BufferedReader(new StringReader(infoString));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (StringUtils.isEmpty((CharSequence)(line = line.trim()))) continue;
                if (line.charAt(0) == '#') {
                    String sectionName = line.split(" ", 2)[1];
                    sectionData = new LinkedHashMap<String, String>();
                    infoData.put(sectionName, sectionData);
                    continue;
                }
                String[] fields = line.split(":", 2);
                if (fields.length != 2) {
                    sectionData.put(line, "parse fail");
                    continue;
                }
                sectionData.put(fields[0], fields[1]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return infoData;
    }

    public void pipeNoReturn(Consumer<Pipeline> action) {
        try (Jedis jedis = this.pool.getResource();){
            Pipeline pipe = jedis.pipelined();
            action.accept(pipe);
            pipe.sync();
        }
    }

    public List<Object> pipeWithReturn(Consumer<Pipeline> action) {
        try (Jedis jedis = this.pool.getResource();){
            Pipeline pipe = jedis.pipelined();
            action.accept(pipe);
            List list = pipe.syncAndReturnAll();
            return list;
        }
    }

    public Map<String, Map<String, String>> info() {
        String rawData = this.execute(Jedis::info);
        return RedisClient.parseInfo(rawData);
    }

    public Map<String, Map<String, String>> info(String sectionName) {
        String rawData = this.execute(jedis -> jedis.info(sectionName));
        return RedisClient.parseInfo(rawData);
    }

    public int clean(String pattern) {
        return this.clean(pattern, 2000);
    }

    public int clean(String pattern, int batch) {
        return this.scan(pattern, batch, keys -> {
            String[] deletedKeys = keys.toArray(new String[0]);
            this.execute(jedis -> jedis.del(deletedKeys));
        });
    }

    public int scan(String pattern, int batch, Consumer<List<String>> action) {
        ScanParams params = new ScanParams();
        params.count(Integer.valueOf(batch));
        params.match(pattern);
        int totalSize = 0;
        ScanResult result = this.execute(jedis -> jedis.scan(ScanParams.SCAN_POINTER_START, params));
        while (true) {
            List keys = result.getResult();
            totalSize += keys.size();
            action.accept(keys);
            String cursor = result.getCursor();
            if (ScanParams.SCAN_POINTER_START.equals(cursor)) break;
            result = this.execute(jedis -> jedis.scan(cursor, params));
        }
        return totalSize;
    }

    public <T> T execute(Function<Jedis, T> action) {
        try (Jedis jedis = this.pool.getResource();){
            T t = action.apply(jedis);
            return t;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.pool != null) {
                this.pool.close();
            }
        }
        catch (Exception e) {
            log.error("close redis pool: error", (Throwable)e);
        }
    }
}

