/*
 * Decompiled with CFR 0.152.
 */
package test.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import test.auth.bean.AuthToken;
import test.auth.bean.Result;

public class Util {
    public static String getLocalIp() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "127.0.0.1";
        }
    }

    public static Result<AuthToken> authorizeForTest(String advertiserId, String authCode, String channel) {
        AuthToken authToken = new AuthToken();
        authToken.setChannel(channel);
        authToken.setAdvertiserId(advertiserId);
        String s = String.valueOf(System.currentTimeMillis());
        authToken.setAccessToken(s);
        authToken.setRefreshToken(s);
        authToken.setCreateTime(System.currentTimeMillis());
        authToken.setRefreshTime(System.currentTimeMillis() + 100000L);
        return Result.ofSuccessful(authToken);
    }

    public static Result<AuthToken> refreshForTest(AuthToken authToken) {
        String s = String.valueOf(System.currentTimeMillis());
        AuthToken newAuthToken = authToken.newToken("access " + s, "refresh " + s);
        return Result.ofSuccessful(newAuthToken);
    }
}

