/*
 * Decompiled with CFR 0.152.
 */
package io.github.iac_m.jsonlogger;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.github.iac_m.jsonlogger.JsonLoggerConfig;
import io.github.iac_m.jsonlogger.LogHelper;
import io.github.iac_m.jsonlogger.LogLevel;
import io.github.iac_m.jsonlogger.LogPropertyScope;
import io.github.iac_m.jsonlogger.dto.LogMessage;
import io.github.iac_m.jsonlogger.dto.LogVariable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.mule.api.ExceptionPayload;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.transport.PropertyScope;

public class JsonLogger {
    private static final Logger LOG = LogManager.getLogger((String)"application.jsonlogger");
    private static final String PAYLOAD_NAME = "payload";
    private JsonLoggerConfig config;

    public Object log(MuleEvent context, String message, String variables, LogLevel level, String loggerName) {
        MuleMessage muleMessage = context.getMessage();
        LogMessage logMessage = LogHelper.getBasicLogMessage(muleMessage, message);
        HashSet<String> variableNames = new HashSet<String>(Arrays.asList(variables != null ? variables.replace(" ", "").split(",") : new String[]{}));
        ArrayList<LogVariable> varsToBeLogged = new ArrayList<LogVariable>();
        LogVariable payload = new LogVariable();
        if (variableNames.contains(PAYLOAD_NAME)) {
            try {
                payload.setName(PAYLOAD_NAME);
                if (muleMessage.getPayload() != null) {
                    payload.setValue(muleMessage.getPayloadForLogging());
                } else {
                    payload.setValue("NULL PAYLOAD");
                }
                variableNames.remove(PAYLOAD_NAME);
            }
            catch (Exception e) {
                String errorMessage = "Unable to log payload. Message: " + message + ". Exception: " + e.getMessage();
                LOG.fatal((Object)errorMessage, (Throwable)e);
                payload.setValue(errorMessage);
            }
            varsToBeLogged.add(payload);
        }
        varsToBeLogged.addAll(LogHelper.extractVariables(muleMessage, PropertyScope.INBOUND, variableNames, this.config.getLogVariableType()));
        varsToBeLogged.addAll(LogHelper.extractVariables(muleMessage, PropertyScope.OUTBOUND, variableNames, this.config.getLogVariableType()));
        varsToBeLogged.addAll(LogHelper.extractVariables(muleMessage, PropertyScope.INVOCATION, variableNames, this.config.getLogVariableType()));
        logMessage.setVariables(varsToBeLogged);
        this.log(logMessage, level, StringUtils.isNotBlank((CharSequence)loggerName) ? loggerName : this.config.getDefaultLoggerName());
        return context.getMessage().getPayload();
    }

    public Object logAllProperties(MuleEvent context, String message, LogPropertyScope scope, LogLevel level, String loggerName) {
        MuleMessage muleMessage = context.getMessage();
        LogMessage logMessage = LogHelper.getBasicLogMessage(muleMessage, message);
        ArrayList<LogVariable> varsToBeLogged = new ArrayList<LogVariable>();
        if (scope == LogPropertyScope.Inbound || scope == LogPropertyScope.All) {
            varsToBeLogged.addAll(LogHelper.extractVariables(muleMessage, PropertyScope.INBOUND, muleMessage.getPropertyNames(PropertyScope.INBOUND), this.config.getLogVariableType()));
        }
        if (scope == LogPropertyScope.Outbound || scope == LogPropertyScope.All) {
            varsToBeLogged.addAll(LogHelper.extractVariables(muleMessage, PropertyScope.OUTBOUND, muleMessage.getPropertyNames(PropertyScope.OUTBOUND), this.config.getLogVariableType()));
        }
        if (scope == LogPropertyScope.Invocation || scope == LogPropertyScope.All) {
            varsToBeLogged.addAll(LogHelper.extractVariables(muleMessage, PropertyScope.INVOCATION, muleMessage.getPropertyNames(PropertyScope.INVOCATION), this.config.getLogVariableType()));
        }
        logMessage.setVariables(varsToBeLogged);
        this.log(logMessage, level, loggerName == null ? this.config.getDefaultLoggerName() : loggerName);
        return context.getMessage().getPayload();
    }

    public Object logException(MuleEvent context, String message, LogLevel level, String loggerName) {
        MuleMessage muleMessage = context.getMessage();
        LogMessage logMessage = LogHelper.getBasicLogMessage(muleMessage, message);
        ExceptionPayload exceptionPayload = muleMessage.getExceptionPayload();
        if (exceptionPayload != null) {
            Throwable throwable = exceptionPayload.getException();
            logMessage.setThrowable(throwable);
        } else {
            logMessage.setThrowable(new RuntimeException("Unable to extract exception payload from message"));
        }
        ArrayList<LogVariable> varsToBeLogged = new ArrayList<LogVariable>();
        try {
            varsToBeLogged.addAll(LogHelper.extractVariables(muleMessage, PropertyScope.INBOUND, muleMessage.getPropertyNames(PropertyScope.INBOUND), this.config.getLogVariableType()));
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to extract inbound properties from mule message.", (Throwable)e);
        }
        try {
            varsToBeLogged.addAll(LogHelper.extractVariables(muleMessage, PropertyScope.OUTBOUND, muleMessage.getPropertyNames(PropertyScope.OUTBOUND), this.config.getLogVariableType()));
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to extract outbound properties from mule message.", (Throwable)e);
        }
        try {
            varsToBeLogged.addAll(LogHelper.extractVariables(muleMessage, PropertyScope.INVOCATION, muleMessage.getPropertyNames(PropertyScope.INVOCATION), this.config.getLogVariableType()));
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to extract invocation properties from mule message.", (Throwable)e);
        }
        logMessage.setVariables(varsToBeLogged);
        this.log(logMessage, level, loggerName == null ? this.config.getDefaultLoggerName() : loggerName);
        return context.getMessage().getPayload();
    }

    private void log(LogMessage logMessage, LogLevel level, String loggerName) {
        String logMessageString;
        if (this.config.getLogInPlainString().booleanValue()) {
            StringBuilder sb = new StringBuilder();
            sb.append("[CID: ").append(logMessage.getCorrelationId());
            if (StringUtils.isNotBlank((CharSequence)logMessage.getCorrelationIdLocal())) {
                sb.append(" CID.Local: ").append(logMessage.getCorrelationIdLocal());
            }
            sb.append("] ").append(logMessage.getMessage());
            String varsInString = LogHelper.variablesToString(logMessage.getVariables(), this.config.getLogVariableType());
            if (varsInString.length() > 0) {
                sb.append(" [").append(varsInString).append("]");
            }
            if (logMessage.getThrowable() != null) {
                Throwable t = logMessage.getThrowable();
                sb.append("\nException: ").append(ExceptionUtils.getMessage((Throwable)t)).append(" ").append(ExceptionUtils.getStackTrace((Throwable)logMessage.getThrowable()));
                sb.append("");
            }
            logMessageString = sb.toString();
        } else {
            TimeZone tz = TimeZone.getTimeZone("UTC");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            df.setTimeZone(tz);
            logMessage.setTimestamp(df.format(new Date()));
            logMessage.setLevel(level.toString());
            logMessage.setLogger(loggerName);
            logMessage.setThread(Thread.currentThread().toString());
            Gson gson = new GsonBuilder().disableHtmlEscaping().disableHtmlEscaping().create();
            logMessageString = gson.toJson((Object)logMessage);
        }
        Logger logger = LogManager.getLogger((String)loggerName);
        switch (level) {
            case INFO: {
                logger.info((Object)logMessageString);
                break;
            }
            case ERROR: {
                logger.error((Object)logMessageString);
                break;
            }
            case FATAL: {
                logger.fatal((Object)logMessageString);
                break;
            }
            case DEBUG: {
                logger.debug((Object)logMessageString);
            }
        }
    }

    public JsonLoggerConfig getConfig() {
        return this.config;
    }

    public void setConfig(JsonLoggerConfig config) {
        this.config = config;
    }
}

