/*
 * Decompiled with CFR 0.152.
 */
package io.github.iac_m.jsonlogger;

import io.github.iac_m.jsonlogger.dto.LogMessage;
import io.github.iac_m.jsonlogger.dto.LogVariable;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.mule.api.MuleMessage;
import org.mule.api.transport.PropertyScope;

public class LogHelper {
    private static final String CORRELATION_ID_INCOMING_HEADER_NAME = "x-correlation-id";
    public static final String MSG_VAR_CORRELATION_ID = "correlation_id";
    public static final String MSG_VAR_MESSAGE = "message";

    public static LogMessage getBasicLogMessage(MuleMessage muleMessage, String message) {
        LogMessage logMessage = new LogMessage();
        logMessage.setCorrelationId(LogHelper.getOrGenerateCorrelationId(muleMessage));
        String messageUniqueId = muleMessage.getUniqueId();
        if (!messageUniqueId.equals(muleMessage.getMessageRootId())) {
            logMessage.setCorrelationIdLocal(messageUniqueId);
        }
        logMessage.setMessage(message);
        return logMessage;
    }

    public static Collection<LogVariable> extractVariables(MuleMessage message, PropertyScope scope, Collection<String> varNames, Boolean logType) {
        HashSet<LogVariable> variables = new HashSet<LogVariable>();
        Set definedProperties = message.getPropertyNames(scope);
        for (String varName : varNames) {
            if (varName.equalsIgnoreCase("rootMessage") || !definedProperties.contains(varName)) continue;
            Object value = message.getProperty(varName, scope);
            LinkedHashMap<String, Object> variable = new LinkedHashMap<String, Object>();
            variable.put("name", varName);
            variable.put("value", value);
            variable.put("scope", scope.toString());
            if (logType.booleanValue()) {
                variable.put("type", value != null ? value.getClass().getName() : null);
            }
            variables.add(new LogVariable(scope.toString(), varName, value, value.getClass().getName()));
        }
        return variables;
    }

    public static String variablesToString(List<LogVariable> variables, boolean logType) {
        HashSet<String> variableStrings = new HashSet<String>();
        for (LogVariable v : variables) {
            variableStrings.add(v.toString(logType));
        }
        return StringUtils.join(variableStrings, (String)", ");
    }

    private static String getOrGenerateCorrelationId(MuleMessage muleMessage) {
        String cid = (String)muleMessage.getInvocationProperty(MSG_VAR_CORRELATION_ID);
        if (cid == null) {
            cid = muleMessage.getInboundProperty(CORRELATION_ID_INCOMING_HEADER_NAME) != null ? muleMessage.getInboundProperty(CORRELATION_ID_INCOMING_HEADER_NAME).toString() : muleMessage.getMessageRootId();
            muleMessage.setInvocationProperty(MSG_VAR_CORRELATION_ID, (Object)cid);
        }
        return cid;
    }
}

