/*
 * Decompiled with CFR 0.152.
 */
package io.github.iac_m.jsonlogger.generated.config;

import io.github.iac_m.jsonlogger.generated.config.JsonLoggerJsonLoggerConfigConfigDefinitionParser;
import io.github.iac_m.jsonlogger.generated.config.LogAllPropertiesDefinitionParser;
import io.github.iac_m.jsonlogger.generated.config.LogDefinitionParser;
import io.github.iac_m.jsonlogger.generated.config.LogExceptionDefinitionParser;
import org.mule.config.MuleManifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

public class JsonLoggerNamespaceHandler
extends NamespaceHandlerSupport {
    private static Logger logger = LoggerFactory.getLogger(JsonLoggerNamespaceHandler.class);

    private void handleException(String beanName, String beanScope, NoClassDefFoundError noClassDefFoundError) {
        String muleVersion = "";
        try {
            muleVersion = MuleManifest.getProductVersion();
        }
        catch (Exception _x) {
            logger.error("Problem while reading mule version");
        }
        logger.error("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [json-logger] is not supported in mule " + muleVersion);
        throw new FatalBeanException("Cannot launch the mule app, the  " + beanScope + " [" + beanName + "] within the connector [json-logger] is not supported in mule " + muleVersion, (Throwable)noClassDefFoundError);
    }

    public void init() {
        try {
            this.registerBeanDefinitionParser("config", (BeanDefinitionParser)new JsonLoggerJsonLoggerConfigConfigDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("config", "@Config", ex);
        }
        try {
            this.registerBeanDefinitionParser("log", (BeanDefinitionParser)new LogDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("log", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("log-all-properties", (BeanDefinitionParser)new LogAllPropertiesDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("log-all-properties", "@Processor", ex);
        }
        try {
            this.registerBeanDefinitionParser("log-exception", (BeanDefinitionParser)new LogExceptionDefinitionParser());
        }
        catch (NoClassDefFoundError ex) {
            this.handleException("log-exception", "@Processor", ex);
        }
    }
}

