package io.github.ibony.ats;


import io.github.ibony.ats.android.Device;
import io.github.ibony.ats.common.command.Command;
import io.github.ibony.ats.utils.FileUtil;
import io.github.ibony.ats.utils.ImageUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.*;

/**
 * Created by Bony on 2018-08-15.
 * STEP_01="aapt package -f -m -M AndroidManifest.xml -I android.jar -S res -J gen";
 * STEP_02="javac -encoding GBK -bootclasspath android.jar -d out gen\\com\\test\\app\\*.java src\\java\\*.java";
 * STEP_03="dx --dex --output=out\\classes.dex out";
 * STEP_04="aapt package -f -M AndroidManifest.xml -S res -I android.jar -F out\\app.ap_";
 * STEP_05="java -cp sdklib-26.0.0-dev.jar com.android.sdklib.build.ApkBuilderMain out\\app.apk -v -u -z out/app.ap_ -f out\\classes.dex";
 * STEP_06="jarsigner -verbose -keystore app.keystore -storepass 123456 -keypass 123456 out\\app.apk app";
 * STEP_07="zipalign -v 4 out\\app.apk jarsigner_zipalign_app.apk";
 */
public class AppMill {


    private final Log logger = LogFactory.getLog(AppMill.class);
    //working
    String WORKING_SPACE_PATH = "app-mill" + File.separator;
    String APP_PROJECT_PATH = WORKING_SPACE_PATH + "app-project" + File.separator;
    String APP_PROJECT_TEMPLATE_PATH = "app-mill" + File.separator + "app-project-template" + File.separator;
    //dir path
    String RES_GEN = "gen" + File.separator;
    String RES_OUT = "out" + File.separator;
    String RES_LAYOUT_PATH = String.format("%s%s", "res" + File.separator, "layout" + File.separator);
    String RES_MIPMAP_XXHDPI_PATH = String.format("%s%s", "res" + File.separator, "mipmap-xxhdpi" + File.separator);
    String RES_VALUES_PATH = String.format("%s%s", "res" + File.separator, "values" + File.separator);
    String SRC_JAVA_PATH = String.format("%s%s", "src" + File.separator, "java" + File.separator);
    //file path
    String RES_LAYOUT_ACTIVITY_MAIN_XML_PATH = RES_LAYOUT_PATH + "activity_main.xml";
    String RES_MIPMAP_XXHDPI_IC_LAUNCHER_PNG_PATH = RES_MIPMAP_XXHDPI_PATH + "ic_launcher.png";
    String RES_VALUES_STRINGS_XML_PATH = RES_VALUES_PATH + "strings.xml";
    String SRC_JAVA_MAIN_ACTIVITY_JAVA_PATH = SRC_JAVA_PATH + "MainActivity.java";
    String ANDROID_MANIFEST_XML_PATH = "AndroidManifest.xml";
    //file content
    String RES_LAYOUT_ACTIVITY_MAIN_XML_CONTENT = "";
    String RES_VALUES_STRINGS_XML_CONTENT = "";
    String SRC_JAVA_MAIN_ACTIVITY_JAVA_CONTENT = "";
    String ANDROID_MANIFEST_XML_CONTENT = "";
    //tools
    String TOOLS_ROOT = "tools";
    //command script
    String STEP_01 = "%saapt package -f -m -M %s -I %sandroid.jar -S %sres -J %sgen";
    String STEP_02 = "javac -encoding GBK -bootclasspath %sandroid.jar -d %sout %sgen%s*.java %s*java";
    String STEP_03 = "%sdx.bat --dex --output=%sout%sapp.dex %sout";
    String STEP_04 = "%saapt package -f -M %s -S %sres -I %sandroid.jar -F %sout%sapp.ap_";
    String STEP_05 = "java -cp %ssdklib-26.0.0-dev.jar com.android.sdklib.build.ApkBuilderMain %sout%sapp.apk -v -u -z %sout%sapp.ap_ -f %sout%sapp.dex";
    String STEP_06 = "jarsigner -verbose -keystore %skey.keystore -storepass 123456 -keypass 123456 %sout%sapp.apk mock";
    String STEP_07 = "%szipalign -v 4 %sout%sapp.apk %s";

    /**
     * reset workingSpacePath
     *
     * @param workingSpacePath workingSpacePath
     */
    protected void resetWorkingSpacePath(String workingSpacePath) {
        /*reset path*/
        WORKING_SPACE_PATH = workingSpacePath + File.separator;
        APP_PROJECT_PATH = WORKING_SPACE_PATH + "app-project" + File.separator;
        TOOLS_ROOT = WORKING_SPACE_PATH + "tools" + File.separator;
    }


    public AppMill() {
        resetWorkingSpacePath("app-mill");
        initWorkingSpace();
        initTools();
        initLoadTemplateContent();
    }

    public AppMill(String workingSpacePath) {
        resetWorkingSpacePath(workingSpacePath);
        initWorkingSpace();
        initTools();
        initLoadTemplateContent();
    }

    /**
     * make apk
     *
     * @param appName     app name
     * @param packageName app package name
     */
    public void make(String appName, String packageName) {
        make(appName, packageName, WORKING_SPACE_PATH + "app.apk");
    }

    /**
     * make apk
     *
     * @param appName     app name
     * @param packageName app package name
     * @param apkFilePath apk file out path
     */
    public void make(String appName, String packageName, String apkFilePath) {
        clean();
        FileUtil.checkDel(new File(apkFilePath));
        String stringsXmlContent = RES_VALUES_STRINGS_XML_CONTENT.replaceAll("\\{\\{AppName\\}\\}", appName);
        String activityMainCmlContent = RES_LAYOUT_ACTIVITY_MAIN_XML_CONTENT.replaceAll("\\{\\{PackageName\\}\\}", packageName);
        activityMainCmlContent = activityMainCmlContent.replaceAll("\\{\\{AppName\\}\\}", appName);
        String activityJavaContent = SRC_JAVA_MAIN_ACTIVITY_JAVA_CONTENT.replaceAll("\\{\\{PackageName\\}\\}", packageName);
        String androidManifestXmlContent = ANDROID_MANIFEST_XML_CONTENT.replaceAll("\\{\\{PackageName\\}\\}", packageName);
        try {
            FileUtil.writeContent(APP_PROJECT_PATH + RES_VALUES_STRINGS_XML_PATH, stringsXmlContent);
            FileUtil.writeContent(APP_PROJECT_PATH + RES_LAYOUT_ACTIVITY_MAIN_XML_PATH, activityMainCmlContent);
            FileUtil.writeContent(APP_PROJECT_PATH + SRC_JAVA_MAIN_ACTIVITY_JAVA_PATH, activityJavaContent);
            FileUtil.writeContent(APP_PROJECT_PATH + ANDROID_MANIFEST_XML_PATH, androidManifestXmlContent);
            ImageUtil.textToImage(appName, APP_PROJECT_PATH + RES_MIPMAP_XXHDPI_IC_LAUNCHER_PNG_PATH);
        } catch (IOException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
        try {
            runingScript(packageName, apkFilePath);
        } catch (Exception e) {
            e.printStackTrace();
        }
        new File(APP_PROJECT_PATH).delete();
    }

    /**
     * 清空文件夹
     */
    public void clean() {
        FileUtil.cleanDirectory(new File(APP_PROJECT_PATH + RES_OUT));
        FileUtil.cleanDirectory(new File(APP_PROJECT_PATH + RES_GEN));
    }

    /**
     * reset script
     *
     * @param packageName packageName
     */
    private void runingScript(String packageName, String apkFilePath) throws Exception {
        String pagPath = packageName.replaceAll("\\.", File.separator + File.separator);
        /*reset command script*/
        String STEP_CMD_01 = String.format(STEP_01, TOOLS_ROOT, APP_PROJECT_PATH + ANDROID_MANIFEST_XML_PATH, TOOLS_ROOT, APP_PROJECT_PATH, APP_PROJECT_PATH);
        logger.debug("STEP_CMD_01:" + STEP_CMD_01);
        logger.debug(new Command(STEP_CMD_01).readClose());
        String STEP_CMD_02 = String.format(STEP_02, TOOLS_ROOT, APP_PROJECT_PATH, APP_PROJECT_PATH, File.separator + pagPath + File.separator, APP_PROJECT_PATH + SRC_JAVA_PATH);
        logger.debug("STEP_CMD_02:" + STEP_CMD_02);
        logger.debug(new Command(STEP_CMD_02).readClose());
        String STEP_CMD_03 = String.format(STEP_03, TOOLS_ROOT, APP_PROJECT_PATH, File.separator, APP_PROJECT_PATH);
        logger.debug("STEP_CMD_03:" + STEP_CMD_03);
        logger.debug(new Command(STEP_CMD_03).readClose());
        String STEP_CMD_04 = String.format(STEP_04, TOOLS_ROOT, APP_PROJECT_PATH + ANDROID_MANIFEST_XML_PATH, APP_PROJECT_PATH, TOOLS_ROOT, APP_PROJECT_PATH, File.separator);
        logger.debug("STEP_CMD_04:" + STEP_CMD_04);
        logger.debug(new Command(STEP_CMD_04).readClose());
        String STEP_CMD_05 = String.format(STEP_05, TOOLS_ROOT, APP_PROJECT_PATH, File.separator, APP_PROJECT_PATH, File.separator, APP_PROJECT_PATH, File.separator);
        logger.debug("STEP_CMD_05:" + STEP_CMD_05);
        logger.debug(new Command(STEP_CMD_05).readClose());
        String STEP_CMD_06 = String.format(STEP_06, TOOLS_ROOT, APP_PROJECT_PATH, File.separator);
        logger.debug("STEP_CMD_06:" + STEP_CMD_06);
        logger.debug(new Command(STEP_CMD_06).readClose());
        String STEP_CMD_07 = String.format(STEP_07, TOOLS_ROOT, APP_PROJECT_PATH, File.separator, apkFilePath);
        logger.debug("STEP_CMD_07:" + STEP_CMD_07);
        logger.debug(new Command(STEP_CMD_07).readClose());
    }

    /**
     * Init Working Space
     */
    private void initWorkingSpace() {
        new File(WORKING_SPACE_PATH).mkdirs();
        new File(APP_PROJECT_PATH).mkdirs();
        new File(APP_PROJECT_PATH + RES_GEN).mkdirs();
        new File(APP_PROJECT_PATH + RES_OUT).mkdirs();
        new File(APP_PROJECT_PATH + RES_LAYOUT_PATH).mkdirs();
        new File(APP_PROJECT_PATH + RES_VALUES_PATH).mkdirs();
        new File(APP_PROJECT_PATH + RES_MIPMAP_XXHDPI_PATH).mkdirs();
        new File(APP_PROJECT_PATH + SRC_JAVA_PATH).mkdirs();
        new File(TOOLS_ROOT).mkdirs();

    }

    /**
     * Init tools
     */
    private void initTools() {
        try {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("app-mill/tools.7z");
            FileUtil.copy(
                    inputStream,
                    new FileOutputStream(WORKING_SPACE_PATH + "tools.7z")
            );
            FileUtil.un7z(WORKING_SPACE_PATH + "tools.7z", TOOLS_ROOT);
            new File(WORKING_SPACE_PATH + "tools.7z").delete();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }


    /**
     * init project template file content
     */
    public void initLoadTemplateContent() {
        //init activity_main.xml template content
        try {
            RES_LAYOUT_ACTIVITY_MAIN_XML_CONTENT = FileUtil.readJarFileContent(
                    this.getClass().getClassLoader().getResourceAsStream(
                            (APP_PROJECT_TEMPLATE_PATH + RES_LAYOUT_ACTIVITY_MAIN_XML_PATH).replaceAll("\\\\", "/")));
        } catch (IOException e) {
            e.printStackTrace();
        }
        //init strings.xml template content
        try {
            RES_VALUES_STRINGS_XML_CONTENT = FileUtil.readJarFileContent(
                    this.getClass().getClassLoader().getResourceAsStream(
                            (APP_PROJECT_TEMPLATE_PATH + RES_VALUES_STRINGS_XML_PATH).replaceAll("\\\\", "/")));
        } catch (IOException e) {
            e.printStackTrace();
        }
        //init MainActivity.java template content
        try {
            SRC_JAVA_MAIN_ACTIVITY_JAVA_CONTENT = FileUtil.readJarFileContent(
                    this.getClass().getClassLoader().getResourceAsStream(
                            (APP_PROJECT_TEMPLATE_PATH + SRC_JAVA_MAIN_ACTIVITY_JAVA_PATH).replaceAll("\\\\", "/")));
        } catch (IOException e) {
            e.printStackTrace();
        }
        //init AndroidManifest.xml template content
        try {
            ANDROID_MANIFEST_XML_CONTENT = FileUtil.readJarFileContent(
                    this.getClass().getClassLoader().getResourceAsStream(
                            (APP_PROJECT_TEMPLATE_PATH + ANDROID_MANIFEST_XML_PATH).replaceAll("\\\\", "/")));
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
