package io.github.ibony.ats.android;

import io.github.ibony.ats.common.command.Command;
import io.github.ibony.ats.common.command.CommandListener;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class ActivityChangeListener {
    private String odlActivity = null;
    //    private String newActivity=null;
    private boolean STATUS = false;

    public abstract void handler(String odlActivity, String newActivity);

    protected void start(Device device) {
        STATUS = true;
        new Thread(new ActivityChangRunnable(device)).start();
    }

    protected void stop() {
        STATUS = false;
    }

    /**
     * 界面变化监控
     */
    private class ActivityChangRunnable implements Runnable {
        private Device device;

        public ActivityChangRunnable(Device device) {
            this.device = device;
        }

        public void run() {
            Command adbCommand = device.adbCommand("adb shell");
            Pattern pattern = Pattern.compile("(\\S+/\\S+)");
            adbCommand.setCommandListener(new CommandListener() {
                @Override
                public void handler(String message) {
                    Matcher m = pattern.matcher(message);
                    String str = "";
                    if (m.find()) {
                        str = m.group(0);
                    }
                    chang(str.replaceAll("\\{", "").replaceAll("}", ""));
                }
            });
            while (STATUS) {
                try {
                    Thread.sleep(250);
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
                adbCommand.put("dumpsys window |grep mCurrentFocus");
            }
            adbCommand.close();
        }
    }

    private void chang(String activity) {
        if (activity != null&&!activity.equals("")) {
            if (odlActivity == null) {
                odlActivity = activity;
            } else {
                if (!activity.equals(odlActivity)) handler( odlActivity,activity);
                odlActivity = activity;
            }
        }
    }
}
