package io.github.ibony.ats.android;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 应用的内存信息
 * Created by bony on 2017-05-12.
 */
public class AppMemoryInfo {
    private static String mCmd = "adb shell dumpsys meminfo %s";
    private static String MEMINFO_TEXT = null;
    private static String[] dataKeys = {"PssTotal", "PrivateDirty", "PrivateClean", "SwappedDirty", "HeapSize", "HeapAlloc", "HeapFree"};
    private static Map<String, Integer> nativeHeapData = new HashMap<>();
    private static Map<String, Integer> dalvikHeapData = new HashMap<>();
    private static Map<String, Integer> totalData = new HashMap<>();
    private static ArrayList<Integer> dataList = new ArrayList<Integer>();
    private static Map<String, Integer> objMap = new HashMap<>();
    private final static SimpleDateFormat SIMPLE_DATE_FORMAT_MILLISECOND = new SimpleDateFormat("yyMMdd HH:mm:ss.SSS");
    private static String realtime = null;


    /**
     * update MemoryInfo text
     *
     * @param device      Device Class
     * @param packageName app package name
     * @return boolean, check whether the application start or not
     */
    public static boolean upDate(Device device, String packageName) {
        objMap.clear();
        MEMINFO_TEXT = device.adbCommand(
                String.format(mCmd, packageName)
        ).readClose();
        realtime = SIMPLE_DATE_FORMAT_MILLISECOND.format(new Date());
        //判断应用是否启动
        if (MEMINFO_TEXT.contains("No process found for")) {
            MEMINFO_TEXT = null;
            return false;
        } else {
            return true;
        }
    }

    public static boolean upDate() {
        return true;
    }

    public static String getRealtime() {
        if (realtime == null) return SIMPLE_DATE_FORMAT_MILLISECOND.format(new Date());
        else return realtime;
    }

    private static ArrayList<Integer> getMemoryDataList(String category) {
        dataList.clear();
        for (String meminfo : MEMINFO_TEXT.split("\n")) {
            if (meminfo.contains(category)) {
                Pattern pattern = Pattern.compile("\\d+");
                Matcher matcher = pattern.matcher(meminfo);
                while (matcher.find()) {
                    dataList.add(Integer.parseInt(matcher.group(0)));
                }
                return dataList;
            }
        }
        return dataList;
    }

    public static Map<String, Integer> getObjects() {
        if (objMap.size() <= 1) {
            boolean flag = false;
            for (String meminfo : MEMINFO_TEXT.split("\r\n")) {
                if (meminfo.trim().equals("SQL")) {
                    break;
                }
                if (flag) {
                    Pattern pattern = Pattern.compile("(\\S+)\\s+(\\d+)");
                    Matcher matcher = pattern.matcher(meminfo);
                    while (matcher.find()) {
                        String[] res = matcher.group().split(":");
                        try {
                            objMap.put(res[0].trim(), Integer.parseInt(res[1].trim()));
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (meminfo.trim().equals("Objects")) {
                    flag = true;
                }
            }
        }
        return objMap;
    }

    /**
     * 获取NativeHeap各值
     *
     * @return nativeHeapData Map对象
     */
    public static Map<String, Integer> getNativeHeap() {
        nativeHeapData.clear();
        try {
            int a = 0;
            for (int memory_data : getMemoryDataList("Native Heap")) {
                nativeHeapData.put(dataKeys[a], memory_data);
                a++;
            }
            return nativeHeapData;
        } catch (Exception e) {
            return nativeHeapData;
        }
    }

    /**
     * 获取DalvikHeap各值
     *
     * @return nativeHeapData Map对象
     */
    public static Map<String, Integer> getDalvikHeap() {
        dalvikHeapData.clear();
        try {
            int a = 0;
            for (int memory_data : getMemoryDataList("Dalvik Heap")) {
                dalvikHeapData.put(dataKeys[a], memory_data);
                a++;
            }
            return dalvikHeapData;
        } catch (Exception e) {
            return dalvikHeapData;
        }
    }

    /**
     * 获取TOTAL各值
     *
     * @return nativeHeapData Map对象
     */
    public static Map<String, Integer> getTOTAL() {
        totalData.clear();
        try {
            int a = 0;
            for (int memory_data : getMemoryDataList("TOTAL")) {
                totalData.put(dataKeys[a], memory_data);
                a++;
            }
            return totalData;
        } catch (Exception e) {
            return totalData;
        }
    }
}
