package io.github.ibony.ats.android;

import io.github.ibony.ats.common.command.Command;

/**
 * Created by bony on 2017-07-18.
 */

public class Choreographer {
    public Device DEVICE;
    private Command command = new Command();
    private final String _set_state_ = "adb shell setprop debug.choreographer.skipwarning 1";
    private final String _get_state_ = "adb shell getprop debug.choreographer.skipwarning";
    private final String _restart_state_ = "adb shell setprop ctl.restart surfaceflinger; setprop ctl.restart zygote";
    private final String _logcat_ = "adb shell logcat -v time -s Choreographer:I *:S";
    private final String _logcat_c_ = "adb shell logcat -c";

    public Choreographer(Device device) {
        DEVICE = device;
    }

    public boolean checkState() {
        if (DEVICE.adbCommand(_get_state_).readClose().trim().equals("1")) {
            return true;
        } else {
            return false;
        }
    }

    public void setState() {
        DEVICE.adbCommand(_set_state_).readClose();
    }

    public void restartState() {
        DEVICE.adbCommand(_restart_state_).readClose();
    }

    public void startLogcat() {
        command = DEVICE.adbCommand(_logcat_);
    }
    public void logcatClear() {
        // DEVICE.adbCommand("adb logcat -c").readClose();
        DEVICE.adbCommand(_logcat_c_).readClose();
    }

    public void closeLogcat() {
        command.close();
    }

    public String getResult() {
        return command.readClose();
    }

}