package io.github.ibony.ats.android;

import org.dom4j.Attribute;
import org.dom4j.Element;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by bony on 2017-07-14.
 */
public class DElement {
    private DElement PARENT = null;
    private ArrayList<DElement> IElements = new ArrayList();
    private int INDEX;
    private String TEXT;
    private String CLASS;
    private String PACKAGE;
    private String RESOURCE_ID;
    private String CONTENT_DESC;
    private boolean CHECKED;
    private boolean CLICKABLE;
    private boolean LONG_CLICKABLE;
    private boolean ENABLED;
    private boolean FOCUSABLE;
    private boolean FOCUSED;
    private boolean SCROLLABLE;
    private boolean PASSWORD;
    private boolean SELECTED;
    private String BOUNDS;
    private int X0;
    private int Y0;
    private int X1;
    private int Y1;
    private Device device;

    public DElement(Device device) {
        this.device = device;
    }

    public DElement(Device device, DElement PARENT) {
        this.device = device;
        if (PARENT != null) {
            this.PARENT = PARENT;
        }
    }

    public DElement(Device device, Element element, DElement PARENT) {
        this(device, PARENT);
        INDEX = getElementIntegerValue(element, DElementType.INDEX);
        TEXT = getElementStringValue(element, DElementType.TEXT);
        CLASS = getElementStringValue(element, DElementType.CLASS);
        PACKAGE = getElementStringValue(element, DElementType.PACKAGE);
        RESOURCE_ID = getElementStringValue(element, DElementType.RESOURCE_ID);
        CONTENT_DESC = getElementStringValue(element, DElementType.CONTENT_DESC);
        CHECKED = getElementBooleanValue(element, DElementType.CHECKED);
        CLICKABLE = getElementBooleanValue(element, DElementType.CLICKABLE);
        LONG_CLICKABLE = getElementBooleanValue(element, DElementType.LONG_CLICKABLE);
        ENABLED = getElementBooleanValue(element, DElementType.ENABLED);
        FOCUSABLE = getElementBooleanValue(element, DElementType.FOCUSABLE);
        FOCUSED = getElementBooleanValue(element, DElementType.FOCUSED);
        SCROLLABLE = getElementBooleanValue(element, DElementType.SCROLLABLE);
        PASSWORD = getElementBooleanValue(element, DElementType.PASSWORD);
        SELECTED = getElementBooleanValue(element, DElementType.SELECTED);
        BOUNDS = getElementStringValue(element, DElementType.BOUNDS);
        if (BOUNDS != null) {
            //正则取坐标
            // 创建 Pattern 对象
            Pattern r = Pattern.compile("\\d+");
            // 创建 matcher 对象
            Matcher m = r.matcher(BOUNDS);
            if (m.find()) {
                X0 = Integer.parseInt(m.group(0));
            }
            if (m.find()) {
                Y0 = Integer.parseInt(m.group(0));
            }
            if (m.find()) {
                X1 = Integer.parseInt(m.group(0));
            }
            if (m.find()) {
                Y1 = Integer.parseInt(m.group(0));
            }
        }
    }

    public String getElementStringValue(Element element, String Type) {
        Attribute attribute = element.attribute(Type);
        if (attribute != null) {
//            System.out.println(attribute.getValue().trim().replace("\n", ""));
            return attribute.getValue().trim().replace("\n", "");
        } else return null;
    }

    public Boolean getElementBooleanValue(Element element, String Type) {
        Attribute attribute = element.attribute(Type);
        if (attribute != null) {
            return Boolean.valueOf(attribute.getValue());
        } else return false;
    }

    public Integer getElementIntegerValue(Element element, String Type) {
        Attribute attribute = element.attribute(Type);
        if (attribute != null) {
            return Integer.parseInt(attribute.getValue());
        } else return 0;
    }

    public DElement getParent() {
        return PARENT;
    }

    public void setParent(DElement PARENT) {
        this.PARENT = PARENT;
    }

    public ArrayList<DElement> getElements() {
        return IElements;
    }

    public void add(DElement... dElements) {
        for (DElement dElement : dElements) IElements.add(dElement);
    }

    public void add(int index, DElement dElement) {
        IElements.add(index, dElement);
    }

    /**
     * 根据属性获取元素
     *
     * @param elementtype  控件属性
     * @param elementvalue 控件属性值
     * @return 元素
     */
    public DElement findTypeElement(String elementtype, String elementvalue) {
        for (DElement element : IElements) {
            if (element.getType(elementtype).replace("\n", "").trim().equals(elementvalue)) {
                return element;
            }
            DElement dele = element.findTypeElement(elementtype, elementvalue);
            if (dele != null) {
                return dele;
            }
        }
        return null;
    }

    public boolean isTypeElement(String elementtype, String elementvalue) {
        if (findTypeElement(elementtype, elementvalue) == null) return false;
        else return true;
    }

    /**
     * 根据index获取元素
     *
     * @param elementIndex 控件下标
     * @return 元素
     */
    public DElement findIndexPathElement(int[] elementIndex) {
        DElement dElement = getElements().get(elementIndex[0]);
        for (int i = 1; i < elementIndex.length; i++) {
            dElement = dElement.getElements().get(i);
        }
        return dElement;
    }

    /**
     * 根据属性获取元素群
     *
     * @param elementtype  控件属性
     * @param elementvalue 控件属性值
     * @return 元素列表
     */
    public ArrayList<DElement> findTypeElements(String elementtype, String elementvalue) {
        ArrayList<DElement> elements = new ArrayList<>();
        for (DElement element : IElements) {
            if (element.getType(elementtype).equals(elementvalue)) {
                elements.add(element);
            }
            for (DElement el : element.findTypeElements(elementtype, elementvalue)) {
                elements.add(el);
            }
        }
        return elements;
    }

    public String getType(String type) {
        switch (type) {
            case "index":
                return INDEX + "";
            case "text":
                return TEXT + "";
            case "class":
                return CLASS + "";
            case "package":
                return PACKAGE + "";
            case "resource-id":
                return RESOURCE_ID + "";
            case "content-desc":
                return CONTENT_DESC + "";
            case "checked":
                return CHECKED + "";
            case "clickable":
                return CLICKABLE + "";
            case "long-clickable":
                return LONG_CLICKABLE + "";
            case "enabled":
                return ENABLED + "";
            case "focusable":
                return FOCUSABLE + "";
            case "focused":
                return FOCUSED + "";
            case "scrollable":
                return SCROLLABLE + "";
            case "password":
                return PASSWORD + "";
            case "selected":
                return SELECTED + "";
            case "bounds":
                return BOUNDS + "";
            case "x0":
                return X0 + "";
            case "y0":
                return Y0 + "";
            case "x1":
                return X1 + "";
            case "y1":
                return Y1 + "";
            default:
                return null;
        }
    }

    /**
     * 控件点击方法
     */
    public void click() {
        try {
            device.click((X0 + X1) / 2, (Y0 + Y1) / 2);
        } catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public void clickByPercent(double xPercent, double yPercent) {
        try {
            device.click((X0 + X1) * xPercent, (Y0 + Y1) * yPercent);
        } catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public void clear() {
        try {
            device.click((X0 + X1) / 2, (Y0 + Y1) / 2);
            device.inputTextEn("");
        } catch (Exception e) {
            System.err.println(e.getMessage());

        }
    }

    public void input(String text) {
        try {
            device.click((X0 + X1) / 2, (Y0 + Y1) / 2);
            Thread.sleep(1000);
            device.inputTextEn(text);
        } catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public void inputTextZh(String text) {
        try {
            device.click((X0 + X1) / 2, (Y0 + Y1) / 2);
            Thread.sleep(1000);
            device.inputTextZh(text);
        } catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public void swipeToLeft(double d) {
        if (d > 1) {
            new Exception("value out of range").printStackTrace();
            d = 1;
        }
        d = 1 - d;
        device.swipe(
                X1 - ((X1 - X0) * d * 0.5),
                Y0 + (Y1 - Y0) * 0.5,
                X0 + ((X1 - X0) * d * 0.5),
                Y0 + (Y1 - Y0) * 0.5
        );
    }

    public void swipeToLeft() {
        swipeToLeft(1);
    }

    public void swipeToRight(double d) {
        if (d > 1) {
            new Exception("value out of range").printStackTrace();
            d = 1;
        }
        d = 1 - d;
        device.swipe(
                X0 + ((X1 - X0) * d * 0.5),
                Y0 + (Y1 - Y0) * 0.5,
                X1 - ((X1 - X0) * d * 0.5),
                Y0 + (Y1 - Y0) * 0.5
        );
    }

    public void swipeToRight() {
        swipeToRight(1);
    }

    public void swipeToUp(double d) {
        if (d > 1) {
            new Exception("value out of range").printStackTrace();
            d = 1;
        }
        d = 1 - d;
        device.swipe(
                X0 + (X1 - X0) * 0.5,
                Y1 - ((Y1 - Y0) * d * 0.5),
                X0 + (X1 - X0) * 0.5,
                Y0 + ((Y1 - Y0) * d * 0.5)
        );
    }

    public void swipeToUp() {
        swipeToUp(1);
    }

    public void swipeToDown(double d) {
        if (d > 1) {
            new Exception("value out of range").printStackTrace();
            d = 1;
        }
        d = 1 - d;
        device.swipe(
                X0 + (X1 - X0) * 0.5,
                Y0 + ((Y1 - Y0) * d * 0.5),
                X0 + (X1 - X0) * 0.5,
                Y1 - ((Y1 - Y0) * d * 0.5)
        );
    }

    public void swipeToDown() {
        swipeToDown(1);
    }

    public int getINDEX() {
        return INDEX;
    }

    public void setINDEX(int INDEX) {
        this.INDEX = INDEX;
    }

    public String getTEXT() {
        return TEXT;
    }

    public void setTEXT(String TEXT) {
        this.TEXT = TEXT;
    }

    public String getCLASS() {
        return CLASS;
    }

    public void setCLASS(String CLASS) {
        this.CLASS = CLASS;
    }

    public String getPACKAGE() {
        return PACKAGE;
    }

    public void setPACKAGE(String PACKAGE) {
        this.PACKAGE = PACKAGE;
    }

    public String getRESOURCE_ID() {
        return RESOURCE_ID;
    }

    public void setRESOURCE_ID(String RESOURCE_ID) {
        this.RESOURCE_ID = RESOURCE_ID;
    }

    public String getCONTENT_DESC() {
        return CONTENT_DESC;
    }

    public void setCONTENT_DESC(String CONTENT_DESC) {
        this.CONTENT_DESC = CONTENT_DESC;
    }

    public boolean isCHECKED() {
        return CHECKED;
    }

    public void setCHECKED(boolean CHECKED) {
        this.CHECKED = CHECKED;
    }

    public boolean isCLICKABLE() {
        return CLICKABLE;
    }

    public void setCLICKABLE(boolean CLICKABLE) {
        this.CLICKABLE = CLICKABLE;
    }

    public boolean isLONG_CLICKABLE() {
        return LONG_CLICKABLE;
    }

    public void setLONG_CLICKABLE(boolean LONG_CLICKABLE) {
        this.LONG_CLICKABLE = LONG_CLICKABLE;
    }

    public boolean isENABLED() {
        return ENABLED;
    }

    public void setENABLED(boolean ENABLED) {
        this.ENABLED = ENABLED;
    }

    public boolean isFOCUSABLE() {
        return FOCUSABLE;
    }

    public void setFOCUSABLE(boolean FOCUSABLE) {
        this.FOCUSABLE = FOCUSABLE;
    }

    public boolean isFOCUSED() {
        return FOCUSED;
    }

    public void setFOCUSED(boolean FOCUSED) {
        this.FOCUSED = FOCUSED;
    }

    public boolean isSCROLLABLE() {
        return SCROLLABLE;
    }

    public void setSCROLLABLE(boolean SCROLLABLE) {
        this.SCROLLABLE = SCROLLABLE;
    }

    public boolean isPASSWORD() {
        return PASSWORD;
    }

    public void setPASSWORD(boolean PASSWORD) {
        this.PASSWORD = PASSWORD;
    }

    public boolean isSELECTED() {
        return SELECTED;
    }

    public void setSELECTED(boolean SELECTED) {
        this.SELECTED = SELECTED;
    }

    public String getBOUNDS() {
        return BOUNDS;
    }

    public void setBOUNDS(String BOUNDS) {
        this.BOUNDS = BOUNDS;
    }

    public int getX0() {
        return X0;
    }

    public int getY0() {
        return Y0;
    }

    public int getX1() {
        return X1;
    }

    public int getY1() {
        return Y1;
    }

    public String toString() {
        return String.format("(%s)%s{%s}%s", INDEX, CLASS, TEXT, BOUNDS);
    }
}