package io.github.ibony.ats.android;

import io.github.ibony.ats.common.command.Command;
import io.github.ibony.ats.utils.BaseUtil;
import io.github.ibony.ats.utils.FileUtil;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by bony on 2017-06-22.
 */
public class Driver {
    public static boolean DEBUG = false;
    public static String ADB_PATH = null;
//    private static awdaw=
    /**
     * 获取设备列表
     *
     * @return devices
     * @author BONY
     */
    {
        FileUtil.checkNew(new File("logs" + File.separator + "layout-xml" + File.separator));
    }

    public static void setDebug(boolean debug) {
        DEBUG = debug;
    }

    public static List<Device> getDevices() {
        List<Device> devices = new ArrayList<Device>();
        List<String> Result = command("adb devices -l").readLinesClose();//.split("\n");
        for (String result : Result) {
            if (result.contains("product")) {
                try {
                    Matcher matcher_tmp = Pattern.compile("[\\S:\\S]+").matcher(result.toString());
                    ArrayList<String> list = new ArrayList<String>();
                    while (matcher_tmp.find()) {
                        list.add(matcher_tmp.group(0));
                    }
                    String name = "function";
                    for (String str : list) if (str.contains("device:")) name = str.replace("device:", "");
                    devices.add(new Device(list.get(0), name));
                } catch (Exception e) {
                }
            }
        }
        return devices;
    }

    /**
     * 判断设备是否已经连接
     *
     * @return 判断结果
     */
    public boolean isConnected() {
        String res = command("adb get-state").readClose();
        if (!BaseUtil.isEmpty(res) && res.contains("device")) {
            return true;
        } else {
            return false;
        }
    }

    /**
     *  获取设备
     * @return Device对象
     */
    public static Device getDevice() {
        List<Device> devices = getDevices();
        if (devices.size() > 0) {
            return devices.get(0);
        } else {
            return null;
        }
    }

    /**
     * 根据串号获取设备
     * @param serial 串号
     * @return 设备对象
     */
    public static Device getDevice(String serial) {
        List<Device> devices = getDevices();
        if (devices.size() > 0) {
            for (Device device : devices) {
                if (device.getSerial().equals(serial)) return device;
            }
        }
        return null;
    }

    public static Command command(String param) {
        if (ADB_PATH != null) ADB_PATH += "\\" + param;
        try {
            return new Command(param, DEBUG);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Command command(String[] param) {
        if (ADB_PATH != null) ADB_PATH += "\\" + param;
        try {
            return new Command(param, DEBUG);
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}
