package io.github.ibony.ats.android;

import io.github.ibony.ats.common.command.Command;

import java.util.List;

/**
 * 手机设备logcat日志过滤采集
 * Created by bony on 2017-08-20.
 */
public class LogCat {
    private static Command instantLogCommand = new Command();

    public static void clear(Device device) {
        device.adbCommand("adb shell logcat -c").readClose();
    }

    public static List<String> getLog(Device device,String tag, String... greps) {
        String cmdStr = String.format("adb shell \"logcat -d -s %s",tag);
        for (String grep : greps) {
            cmdStr = String.format("%s |grep \'%s\'", cmdStr, grep);
        }
        cmdStr = String.format("%s \"", cmdStr);
        return device.adbCommand(cmdStr).readLinesClose();
    }

    public static List<String> getLog(Device device,String tag, List<String> greps) {
        String cmdStr = String.format("adb shell \"logcat -d -s %s",tag);
        for (String grep : greps) {
            cmdStr = String.format("%s |grep \'%s\'", cmdStr, grep);
        }
        cmdStr = String.format("%s \"", cmdStr);
        return device.adbCommand(cmdStr).readLinesClose();
    }

    public static void startRealTimeLog(Device device,String tag, String... greps) {
        String cmdStr = String.format("adb shell \"logcat -s %s",tag);
        for (String grep : greps) {
            cmdStr = String.format("%s |grep \'%s\'", cmdStr, grep);
        }
        cmdStr = String.format("%s \"", cmdStr);
        startRealTimeLog(device,cmdStr);
    }
    public static void startRealTimeLog(Device device,String cmdStr) {
        instantLogCommand = device.adbCommand(cmdStr);
    }

    public static List<String> stopRealTimeLog() {
        return instantLogCommand.readLinesClose();
    }
}