package io.github.ibony.ats.android;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProcessInformation {
    String USER = "";//用户
    String PID = "";//进程ID
    String PPID = "";//父进程ID
    String VSZ = "";//进程的虚拟内存大小，以KB为单位
    String RSS = "";//进程实际占用的内存大小，以KB为单位
    String WCHAN = "";//进程正在睡眠的内核函数名称
    String NAME = "";//进程状态（注：状态说明见下）和名称

    ProcessInformation(String user, String pid, String ppid, String vsz, String rss, String wchan, String name) {
        this.USER = user;
        this.PID = pid;
        this.PPID = ppid;
        this.VSZ = vsz;
        this.RSS = rss;
        this.WCHAN = wchan;
        this.NAME = name;
    }

    protected static List<ProcessInformation> getProcessInformationList(Device device, String keyword) {
        List<String> lines = device.adbCommand("adb shell \"ps |grep " + keyword + " |grep -v grep\"").readLinesClose();
        List<ProcessInformation> processInformations = new ArrayList<>();
        for (String line : lines) {
            ProcessInformation processInformation = initProcessInformation(line);
            if (processInformation != null) processInformations.add(initProcessInformation(line));
        }
        return processInformations;
    }

    private static ProcessInformation initProcessInformation(String s) {
        Matcher m = Pattern.compile("(\\S+)").matcher(s);
        List<String> result = new ArrayList<String>();
        while (m.find()) {
            result.add(m.group());
        }
        if (result.size() >= 8)
            return new ProcessInformation(result.get(0), result.get(1), result.get(2), result.get(3), result.get(4), result.get(5), result.get(8));
        else return null;
    }

    @Override
    public String toString() {
        return "ProcessInformation{" +
                "USER='" + USER + '\'' +
                ", PID='" + PID + '\'' +
                ", PPID='" + PPID + '\'' +
                ", VSZ='" + VSZ + '\'' +
                ", RSS='" + RSS + '\'' +
                ", WCHAN='" + WCHAN + '\'' +
                ", NAME='" + NAME + '\'' +
                '}';
    }

    public String getUSER() {
        return USER;
    }

    public String getPID() {
        return PID;
    }

    public String getPPID() {
        return PPID;
    }

    public String getVSZ() {
        return VSZ;
    }

    public String getRSS() {
        return RSS;
    }

    public String getWCHAN() {
        return WCHAN;
    }

    public String getNAME() {
        return NAME;
    }
}
