package io.github.ibony.ats.android;

/**
 * 应用的系统信息
 * Created by bony on 2017-07-27.
 */
public class SystemInfo {
    private static String mAddressCmd = "adb shell cat /sys/class/net/wlan0/address";
    private static String mCpuCmd = "adb shell getprop ro.product.cpu.abi";
    private static String mSdkCmd = "adb shell getprop ro.product.cpu.abi";

    /**
     * 获取CPU版本
     *
     * @param device 设备
     * @return cpu信息
     */
    public static String getCPU(Device device) {
        String result = device.adbCommand(mCpuCmd).readClose();
        if (result.contains("error")) {
            return null;
        } else {
            return result.trim().replaceAll("\r|\n", "");
        }
    }

    /**
     * 获取SDK版本
     *
     * @param device 设备
     * @return SDK信息
     */
    public static String getSDK(Device device) {
        String result = device.adbCommand(mSdkCmd).readClose();
        if (result.contains("error")) {
            return null;
        } else {
            return result.trim().replaceAll("\r|\n", "");
        }
    }

    /**
     * @param device 设备
     * @return MacAddress
     */
    public static String getMacAddress(Device device) {
        return device.adbCommand(mAddressCmd).readClose();
    }
}
