package io.github.ibony.ats.android.adblistener;


/***
 * Created by bony on 2018-01-21.
 ***/
public class DeviceManager {
    private static DeviceManager INSTANCE = null;

    public static DeviceManager getInstance() {
        if (INSTANCE == null)
        {
            INSTANCE = new DeviceManager();
        }

        return INSTANCE;
    }
    /**
     * 包装类
     */
    private AndroidDebugBridgeWrapper androidDebugBridgeWrapper;

    /**
     * 设备监听器
     */
    private DeviceChangeListener deviceChangeListener;

    /**
     * 私有构造函数
     */
    private DeviceManager() {}

    /**
     * 启动方法
     * @param deviceChangeListener DeviceChangeListener
     */
    public void start(DeviceChangeListener deviceChangeListener) {
        this.deviceChangeListener = deviceChangeListener;
        androidDebugBridgeWrapper = new AndroidDebugBridgeWrapper();
        androidDebugBridgeWrapper.addDeviceChangeListener(deviceChangeListener);
        androidDebugBridgeWrapper.init(false);

        System.out.println("Device manager start successful.");
    }

    /**
     * 销毁方法
     */
    public void destory() {
        if (androidDebugBridgeWrapper == null)
        {
            return;
        }

        androidDebugBridgeWrapper.removeDeviceChangeListener(deviceChangeListener);
        androidDebugBridgeWrapper.terminate();
    }

}
